/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copisWarpsPlugin;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class CopisWarpsPlugin
extends JavaPlugin {
    private final Map<String, Warp> warps = new HashMap<String, Warp>();
    private final Map<UUID, Location> teleportStart = new HashMap<UUID, Location>();
    private static final int TELEPORT_DELAY = 5;

    public void onEnable() {
        this.getLogger().info("CopisWarps v1.0 enabled!");
    }

    public void onDisable() {
        this.getLogger().info("CopisWarps disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "setwarp": {
                return this.handleSetWarp(player, args);
            }
            case "warp": {
                return this.handleWarp(player, args);
            }
            case "delwarp": {
                return this.handleDelWarp(player, args);
            }
            case "warplist": {
                return this.handleWarpList(player);
            }
        }
        return false;
    }

    private boolean handleSetWarp(Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage("\u00a7cUsage: /setwarp <name> [description]");
            return true;
        }
        String name = args[0].toLowerCase();
        String description = args.length > 1 ? String.join((CharSequence)" ", args).replaceFirst(name + " ", "") : "No description";
        Warp warp = new Warp(player.getLocation(), description);
        this.warps.put(name, warp);
        player.sendMessage("\u00a7aWarp \u00a7e" + name + " \u00a7aset at your location! Description: \u00a77" + description);
        return true;
    }

    private boolean handleWarp(final Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage("\u00a7cUsage: /warp <name>");
            return true;
        }
        final String name = args[0].toLowerCase();
        if (!this.warps.containsKey(name)) {
            player.sendMessage("\u00a7cWarp not found!");
            return true;
        }
        Warp warp = this.warps.get(name);
        final Location destination = warp.location;
        this.teleportStart.put(player.getUniqueId(), player.getLocation());
        player.sendMessage("\u00a7eStand still for 5 seconds to teleport to \u00a7a" + name);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    CopisWarpsPlugin.this.teleportStart.remove(player.getUniqueId());
                    return;
                }
                Location start = CopisWarpsPlugin.this.teleportStart.get(player.getUniqueId());
                if (start == null) {
                    this.cancel();
                    return;
                }
                Location current = player.getLocation();
                if (!current.getBlock().equals((Object)start.getBlock())) {
                    player.sendMessage("\u00a7cTeleport cancelled because you moved!");
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                if (!current.getBlock().getType().isAir()) {
                    player.sendMessage("\u00a7cTeleport cancelled! You are inside a block.");
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                if (current.getY() < start.getY() - 1.0) {
                    player.sendMessage("\u00a7cTeleport cancelled! You are falling.");
                    this.cancelTeleport();
                    this.cancel();
                    return;
                }
                player.getWorld().spawnParticle(Particle.PORTAL, current.add(0.0, 1.0, 0.0), 10, 0.5, 1.0, 0.5, 0.1);
                player.getWorld().playSound(current, Sound.BLOCK_BEACON_POWER_SELECT, 0.5f, 1.0f);
                ++this.counter;
                if (this.counter >= 5) {
                    player.teleport(destination);
                    player.sendMessage("\u00a7aTeleported to warp \u00a7e" + name);
                    this.cancelTeleport();
                    this.cancel();
                }
            }

            private void cancelTeleport() {
                CopisWarpsPlugin.this.teleportStart.remove(player.getUniqueId());
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
        return true;
    }

    private boolean handleDelWarp(Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage("\u00a7cUsage: /delwarp <name>");
            return true;
        }
        String name = args[0].toLowerCase();
        if (this.warps.remove(name) != null) {
            player.sendMessage("\u00a7aWarp \u00a7e" + name + " \u00a7adeleted!");
        } else {
            player.sendMessage("\u00a7cWarp not found!");
        }
        return true;
    }

    private boolean handleWarpList(Player player) {
        if (this.warps.isEmpty()) {
            player.sendMessage("\u00a7cNo warps set.");
            return true;
        }
        player.sendMessage("\u00a7aAvailable Warps:");
        for (Map.Entry<String, Warp> entry : this.warps.entrySet()) {
            String name = entry.getKey();
            Warp warp = entry.getValue();
            TextComponent warpMessage = new TextComponent("\u00a7e" + name + " \u00a77- " + warp.description + " ");
            TextComponent clickWarp = new TextComponent("[Warp]");
            clickWarp.setColor(ChatColor.GREEN);
            clickWarp.setBold(Boolean.valueOf(true));
            clickWarp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/warp " + name));
            warpMessage.addExtra((BaseComponent)clickWarp);
            player.spigot().sendMessage((BaseComponent)warpMessage);
        }
        return true;
    }

    private static class Warp {
        final Location location;
        final String description;

        Warp(Location location, String description) {
            this.location = location;
            this.description = description;
        }
    }
}

