/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copis_warps_mod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1922;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5321;

public class Copis_warps_mod
implements ModInitializer {
    private static final Map<String, WarpLocation> warps = new HashMap<String, WarpLocation>();
    private static final File warpsFile = new File("config/copis_warps.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void onInitialize() {
        Copis_warps_mod.loadWarps();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"setwarp").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String name = ((String)ctx.getArgument("name", String.class)).toLowerCase();
                warps.put(name, new WarpLocation(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455(), player.method_37908().method_27983().method_29177().toString()));
                Copis_warps_mod.saveWarps();
                player.method_7353(class_2561.method_30163((String)("\u00a7aWarp '" + name + "' set.")), false);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String name = ((String)ctx.getArgument("name", String.class)).toLowerCase();
                if (!warps.containsKey(name)) {
                    player.method_7353(class_2561.method_30163((String)"\u00a7cWarp not found."), false);
                    return 0;
                }
                WarpLocation loc = warps.get(name);
                new Thread(() -> {
                    try {
                        int i = 5;
                        while (i > 0) {
                            int finalI = i--;
                            player.method_5682().execute(() -> player.method_7353(class_2561.method_30163((String)("\u00a7eTeleporting to \u00a7b" + name + "\u00a7e in " + finalI + "...")), false));
                            Thread.sleep(1000L);
                        }
                        player.method_5682().execute(() -> {
                            class_5321 worldKey = player.method_5682().method_29435().stream().filter(k -> k.method_29177().toString().equals(loc.world)).findFirst().orElse(player.method_37908().method_27983());
                            class_3218 world = player.method_5682().method_3847(worldKey);
                            if (world == null) {
                                player.method_7353(class_2561.method_30163((String)"\u00a7cWorld not found!"), false);
                                return;
                            }
                            class_2338 pos = new class_2338((int)loc.x, (int)loc.y, (int)loc.z);
                            if (!world.method_8320(pos).method_26220((class_1922)world, pos).method_1110()) {
                                player.method_7353(class_2561.method_30163((String)"\u00a7cWarp blocked by solid blocks."), false);
                                return;
                            }
                            class_243 dest = new class_243(loc.x + 0.5, loc.y, loc.z + 0.5);
                            player.method_14251(world, dest.field_1352, dest.field_1351, dest.field_1350, loc.yaw, loc.pitch);
                            world.method_8406((class_2394)class_2398.field_11214, dest.field_1352, dest.field_1351 + 1.0, dest.field_1350, 0.0, 1.0, 0.0);
                            player.method_5783(class_3417.field_14879, 1.0f, 1.0f);
                            player.method_7353(class_2561.method_30163((String)("\u00a7aTeleported to warp \u00a7b" + name)), false);
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }).start();
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"delwarp").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String name = ((String)ctx.getArgument("name", String.class)).toLowerCase();
                if (warps.remove(name) != null) {
                    Copis_warps_mod.saveWarps();
                    player.method_7353(class_2561.method_30163((String)("\u00a7cWarp '" + name + "' deleted.")), false);
                } else {
                    player.method_7353(class_2561.method_30163((String)"\u00a7cWarp not found."), false);
                }
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"warps").executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                if (warps.isEmpty()) {
                    player.method_7353(class_2561.method_30163((String)"\u00a7cNo warps set."), false);
                } else {
                    player.method_7353(class_2561.method_30163((String)("\u00a7aAvailable warps: \u00a7b" + String.join((CharSequence)", ", warps.keySet()))), false);
                }
                return 1;
            }));
        });
    }

    private static void saveWarps() {
        try {
            warpsFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(warpsFile);){
                gson.toJson(warps, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadWarps() {
        if (!warpsFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(warpsFile);){
            Type type = new TypeToken<Map<String, WarpLocation>>(){}.getType();
            Map loaded = (Map)gson.fromJson((Reader)reader, type);
            if (loaded != null) {
                warps.putAll(loaded);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class WarpLocation {
        double x;
        double y;
        double z;
        float yaw;
        float pitch;
        String world;

        WarpLocation(double x, double y, double z, float yaw, float pitch, String world) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.world = world;
        }
    }
}

