/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.mojang.blaze3d.platform.InputConstants;
import games.enchanted.eg_bedrock_books.common.Logging;
import games.enchanted.eg_bedrock_books.common.config.option.BoolOption;
import games.enchanted.eg_bedrock_books.common.config.option.ConfigOption;
import games.enchanted.eg_bedrock_books.common.config.option.IntOption;
import games.enchanted.eg_bedrock_books.common.config.option.KeyOption;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import games.enchanted.eg_bedrock_books.platform.PlatformHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ConfigOptions {
    public static final ConfigOption<Boolean> CLOSE_BOOK_WHEN_RUNNING_COMMAND;
    public static final ConfigOption<InputConstants.Key> MOVE_FORWARD_PAGE_KEY;
    public static final ConfigOption<InputConstants.Key> MOVE_BACKWARD_PAGE_KEY;
    public static final ConfigOption<Boolean> VANILLA_BOOK_KEY_ENABLED;
    public static final ConfigOption<InputConstants.Key> VANILLA_BOOK_KEY;
    public static final ConfigOption<Boolean> SHOW_X_BUTTON;
    public static final ConfigOption<Integer> RIBBON_HEIGHT;
    public static final ConfigOption<Boolean> DEBUG_TEXT_BOUNDS;
    public static final ConfigOption<Boolean> DEBUG_WIDGET_BOUNDS;
    public static final ConfigOption<Boolean> DEBUG_CONTAINER_DATA;
    public static final ConfigOption<Boolean> DEBUG_VARIABLES;
    private static final List<ConfigOption<?>> OPTIONS;
    private static final String FILE_NAME = "eg_bedrock_books.json";

    private static void registerOption(ConfigOption<?> option) {
        OPTIONS.add(option);
    }

    private static File getConfigFile() {
        return PlatformHelper.getConfigPath().resolve(FILE_NAME).toFile();
    }

    public static void saveIfAnyDirtyOptions() {
        if (OPTIONS.stream().noneMatch(ConfigOption::isDirty)) {
            return;
        }
        for (ConfigOption<?> option : OPTIONS) {
            if (!option.isDirty()) continue;
            option.applyPendingValue();
        }
        ConfigOptions.saveConfig();
    }

    public static void saveConfig() {
        JsonObject root = new JsonObject();
        for (ConfigOption<?> option : OPTIONS) {
            root.add(option.getJsonKey(), option.toJson());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String encodedJson = gson.toJson((JsonElement)root);
        try (FileWriter writer = new FileWriter(ConfigOptions.getConfigFile());){
            writer.write(encodedJson);
        }
        catch (IOException e) {
            Logging.error("Failed to write config file '{}', {}", FILE_NAME, e);
        }
    }

    public static void readConfig() {
        Gson gson = new Gson();
        JsonObject decodedConfig = new JsonObject();
        try {
            JsonReader jsonReader = gson.newJsonReader((Reader)new FileReader(ConfigOptions.getConfigFile()));
            jsonReader.setStrictness(Strictness.LENIENT);
            decodedConfig = JsonParser.parseReader((JsonReader)jsonReader).getAsJsonObject();
        }
        catch (JsonParseException e) {
            Logging.error("Failed to parse config file '{}', {}", new Object[]{FILE_NAME, e});
        }
        catch (FileNotFoundException e) {
            Logging.info("Config file '{}' not found", FILE_NAME);
            ConfigOptions.saveConfig();
        }
        for (ConfigOption<?> option : OPTIONS) {
            option.fromJson(decodedConfig);
        }
    }

    public static void resetAndSaveAllOptions() {
        for (ConfigOption<?> option : OPTIONS) {
            option.resetToDefault(true);
        }
        ConfigOptions.saveConfig();
    }

    public static void clearAllPendingValues() {
        for (ConfigOption<?> option : OPTIONS) {
            option.clearPendingValue();
        }
    }

    static {
        OPTIONS = new ArrayList();
        CLOSE_BOOK_WHEN_RUNNING_COMMAND = new BoolOption(true, true, "close_book_when_running_command");
        ConfigOptions.registerOption(CLOSE_BOOK_WHEN_RUNNING_COMMAND);
        MOVE_FORWARD_PAGE_KEY = new KeyOption(InputUtil.getKey(267), InputUtil.getKey(267), "move_forward_page_key");
        ConfigOptions.registerOption(MOVE_FORWARD_PAGE_KEY);
        MOVE_BACKWARD_PAGE_KEY = new KeyOption(InputUtil.getKey(266), InputUtil.getKey(266), "move_backward_page_key");
        ConfigOptions.registerOption(MOVE_BACKWARD_PAGE_KEY);
        VANILLA_BOOK_KEY_ENABLED = new BoolOption(false, false, "vanilla_book_key_enabled");
        ConfigOptions.registerOption(VANILLA_BOOK_KEY_ENABLED);
        VANILLA_BOOK_KEY = new KeyOption(InputUtil.getKey(342), InputUtil.getKey(342), "vanilla_book_key");
        ConfigOptions.registerOption(VANILLA_BOOK_KEY);
        SHOW_X_BUTTON = new BoolOption(true, true, "show_x_button");
        ConfigOptions.registerOption(SHOW_X_BUTTON);
        RIBBON_HEIGHT = new IntOption(76, 76, "ribbon_height");
        ConfigOptions.registerOption(RIBBON_HEIGHT);
        DEBUG_TEXT_BOUNDS = new BoolOption(false, false, "debug_text_bounds");
        ConfigOptions.registerOption(DEBUG_TEXT_BOUNDS);
        DEBUG_WIDGET_BOUNDS = new BoolOption(false, false, "debug_widget_bounds");
        ConfigOptions.registerOption(DEBUG_WIDGET_BOUNDS);
        DEBUG_CONTAINER_DATA = new BoolOption(false, false, "debug_container_data");
        ConfigOptions.registerOption(DEBUG_CONTAINER_DATA);
        DEBUG_VARIABLES = new BoolOption(false, false, "debug_variables");
        ConfigOptions.registerOption(DEBUG_VARIABLES);
    }
}

