/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.config.ConfigScreenBehaviour;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.EditControls;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBedrockBookScreen<PageContent, TextView extends TextAreaView<PageContent>>
extends Screen {
    protected static final int BACKGROUND_WIDTH = 512;
    protected static final int BACKGROUND_HEIGHT = 256;
    protected static final int PAGE_EDIT_BOX_WIDTH = 122;
    protected static final int PAGE_EDIT_BOX_HEIGHT = 134;
    protected static final int PAGE_TEXT_WIDTH = 114;
    protected static final int PAGE_TEXT_HEIGHT = 128;
    protected static final int CENTER_PADDING = 22;
    protected static final int CURSOR_COLOUR = -16777216;
    protected static final int TEXT_COLOUR = -16777216;
    protected static final int PAGE_INDICATOR_COLOUR = -4414585;
    protected static final boolean TEXT_SHADOW = false;
    protected static final int FOOTER_BUTTON_WIDTH = 90;
    protected static final int FOOTER_BUTTON_SPACING = 8;
    protected static final String BOOK_PAGE_INDICATOR = "book.pageIndicator";
    protected static final Component SIGN_BUTTON_COMPONENT = Component.translatable((String)"book.signButton");
    protected static final Component SAVE_BUTTON_COMPONENT = Component.translatable((String)"selectWorld.edit.save");
    private static final int TURN_PAGE_BUTTON_SIZE = 24;
    private static final Component PAGE_LEFT_BUTTON_LABEL = Component.translatable((String)"book.page_button.previous");
    private static final CustomSpriteButton.ButtonConfig PAGE_LEFT_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/page_backward"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/page_backward_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/page_backward_focus"));
    private static final Component PAGE_RIGHT_BUTTON_LABEL = Component.translatable((String)"book.page_button.next");
    private static final CustomSpriteButton.ButtonConfig PAGE_RIGHT_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/page_forward"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/page_forward_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/page_forward_focus"));
    private static final int CLOSE_BUTTON_SIZE = 9;
    private static final Component CLOSE_BUTTON_LABEL = CommonComponents.GUI_DONE;
    private static final CustomSpriteButton.ButtonConfig CLOSE_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/close"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/close_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/close_focus"));
    private static final int CONFIG_BUTTON_SIZE = 24;
    private static final Component CONFIG_BUTTON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.config.title");
    private static final CustomSpriteButton.ButtonConfig CONFIG_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config_button"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config_button_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config_button_focus"));
    protected static final int MAX_PAGES = 100;
    private int currentLeftPageIndex = 0;
    protected List<PageContent> pages = new ArrayList<PageContent>();
    protected CustomSpriteButton turnLeftButton;
    protected CustomSpriteButton turnRightButton;
    protected final boolean canEditAndCreatePages;
    protected Component leftPageNumberMessage = CommonComponents.EMPTY;
    protected TextView leftPageTextView;
    @Nullable
    private EditControls leftPageEditControls = null;
    protected Component rightPageNumberMessage = CommonComponents.EMPTY;
    protected TextView rightPageTextView;
    @Nullable
    private EditControls rightPageEditControls = null;
    protected LinearLayout footerButtonLayout;
    protected CustomSpriteButton configButton;
    protected CustomSpriteButton xButton;

    public AbstractBedrockBookScreen(Component message, boolean editable) {
        super(message);
        this.canEditAndCreatePages = editable;
    }

    protected void init() {
        int editBoxYPos = this.height / 2 - 134 + 45;
        int turnPageButtonYPos = this.height / 2 + 47;
        int editControlsYPos = this.height / 2 + 44;
        this.xButton = new CustomSpriteButton(this.width / 2 + 11 + 120, this.height / 2 - 134 + 33, 9, 9, button -> this.onClose(), CLOSE_BUTTON_LABEL, CLOSE_BUTTON_CONFIG);
        this.addRenderableWidget((GuiEventListener)this.xButton);
        this.xButton.visible = ConfigOptions.SHOW_X_BUTTON.getValue();
        TextViewAndWidget<PageContent, TextView> leftPageWidget = this.createTextWidgetAndView(this.width / 2 - 11 - 122, editBoxYPos, PageSide.LEFT);
        this.leftPageTextView = leftPageWidget.view();
        if (leftPageWidget.widget() != null) {
            this.addRenderableWidget((GuiEventListener)leftPageWidget.widget());
            this.setInitialFocus((GuiEventListener)leftPageWidget.widget());
        }
        if (this.canEditAndCreatePages) {
            this.leftPageEditControls = new EditControls(this.width / 2 - 11 - 61 - 42, editControlsYPos, new EditControls.Actions(() -> this.handlePageMove(PageMoveDirection.LEFT, this.currentLeftPageIndex), () -> this.handleAddPage(this.currentLeftPageIndex), () -> this.handlePageDelete(this.currentLeftPageIndex), () -> this.handlePageMove(PageMoveDirection.RIGHT, this.currentLeftPageIndex)));
            this.leftPageEditControls.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.addRenderableOnly(this.leftPageEditControls);
        }
        this.addWidgetsBetweenPages();
        TextViewAndWidget<PageContent, TextView> rightPageWidget = this.createTextWidgetAndView(this.width / 2 + 11, editBoxYPos, PageSide.RIGHT);
        this.rightPageTextView = rightPageWidget.view();
        if (rightPageWidget.widget() != null) {
            this.addRenderableWidget((GuiEventListener)rightPageWidget.widget());
        }
        if (this.canEditAndCreatePages) {
            this.rightPageEditControls = new EditControls(this.width / 2 - 11 + 42, editControlsYPos, new EditControls.Actions(() -> this.handlePageMove(PageMoveDirection.LEFT, this.currentLeftPageIndex + 1), () -> this.handleAddPage(this.currentLeftPageIndex + 1), () -> this.handlePageDelete(this.currentLeftPageIndex + 1), () -> this.handlePageMove(PageMoveDirection.RIGHT, this.currentLeftPageIndex + 1)));
            this.rightPageEditControls.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.addRenderableOnly(this.rightPageEditControls);
        }
        this.turnLeftButton = new CustomSpriteButton(this.width / 2 - 147, turnPageButtonYPos, 24, 24, button -> this.turnBackPage(), PAGE_LEFT_BUTTON_LABEL, PAGE_LEFT_BUTTON_CONFIG);
        this.addRenderableWidget((GuiEventListener)this.turnLeftButton);
        this.turnRightButton = new CustomSpriteButton(this.width / 2 + 123, turnPageButtonYPos, 24, 24, button -> this.turnForwardPage(), PAGE_RIGHT_BUTTON_LABEL, PAGE_RIGHT_BUTTON_CONFIG);
        this.addRenderableWidget((GuiEventListener)this.turnRightButton);
        this.footerButtonLayout = LinearLayout.horizontal().spacing(8);
        this.makeFooterButtons();
        this.footerButtonLayout.arrangeElements();
        this.footerButtonLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.updateVisibleContents();
        this.addConfigButton();
    }

    protected abstract TextViewAndWidget<PageContent, TextView> createTextWidgetAndView(int var1, int var2, PageSide var3);

    protected void addWidgetsBetweenPages() {
    }

    protected void makeFooterButtons() {
    }

    protected void addConfigButton() {
        this.configButton = new CustomSpriteButton(4, this.height - 24 - 4, 24, 24, button -> ConfigScreenBehaviour.openConfigScreen(this), CONFIG_BUTTON_LABEL, CONFIG_BUTTON_CONFIG);
        this.addRenderableWidget((GuiEventListener)this.configButton);
    }

    protected void updateVisibleContents() {
        this.turnLeftButton.visible = true;
        this.turnRightButton.visible = true;
        if (this.currentLeftPageIndex <= 1) {
            this.turnLeftButton.visible = false;
        }
        if (this.currentLeftPageIndex + 2 >= this.getCurrentAmountOfPages() && !this.canEditAndCreatePages || this.currentLeftPageIndex + 2 >= 100) {
            this.turnRightButton.visible = false;
        }
        this.leftPageNumberMessage = this.getPageIndicatorMessage(this.currentLeftPageIndex);
        this.leftPageTextView.setValue(this.getOrCreatePageIfPossible(this.currentLeftPageIndex), true);
        int rightPageIndex = this.currentLeftPageIndex + 1;
        if (this.getCurrentAmountOfPages() % 2 == 1 && this.currentLeftPageIndex >= this.getCurrentAmountOfPages() - 1) {
            this.rightPageNumberMessage = Component.empty();
            this.rightPageTextView.setVisibility(false);
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.setVisibility(false);
            }
        } else {
            this.rightPageNumberMessage = this.getPageIndicatorMessage(this.currentLeftPageIndex + 1);
            this.rightPageTextView.setVisibility(true);
            this.rightPageTextView.setValue(this.getPageOrEmpty(rightPageIndex), true);
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.setVisibility(true);
            }
        }
        if (this.canEditAndCreatePages) {
            if (this.leftPageEditControls != null) {
                this.leftPageEditControls.setMoveBackButtonVisible(this.currentLeftPageIndex > 0);
                this.leftPageEditControls.setMoveForwardButtonVisible(this.currentLeftPageIndex < this.getCurrentAmountOfPages() - 1);
            }
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.setMoveBackButtonVisible(rightPageIndex > 0);
                this.rightPageEditControls.setMoveForwardButtonVisible(rightPageIndex < this.getCurrentAmountOfPages() - 1);
            }
        }
    }

    protected void ensureEvenPageIndex(int newPageIndex) {
        if ((newPageIndex = Math.max(0, newPageIndex)) % 2 == 1) {
            this.currentLeftPageIndex = newPageIndex - 1;
            return;
        }
        this.currentLeftPageIndex = newPageIndex;
    }

    protected int getCurrentLeftPageIndex() {
        return this.currentLeftPageIndex;
    }

    protected void resetEditControls() {
        if (this.canEditAndCreatePages) {
            if (this.leftPageEditControls != null) {
                this.leftPageEditControls.toggleControls(false);
            }
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.toggleControls(false);
            }
        }
    }

    protected void handlePageMove(PageMoveDirection direction, int index) {
        if (direction == PageMoveDirection.LEFT && index > 0 && index < this.pages.size()) {
            PageContent currentPage = this.pages.get(index);
            PageContent previousPage = this.pages.get(index - 1);
            this.pages.set(index, previousPage);
            this.pages.set(index - 1, currentPage);
        } else if (index < this.pages.size() - 1) {
            PageContent currentPage = this.pages.get(index);
            PageContent nextPage = this.pages.get(index + 1);
            this.pages.set(index, nextPage);
            this.pages.set(index + 1, currentPage);
        }
        this.updateVisibleContents();
    }

    protected abstract PageContent getEmptyPageContent();

    protected void handleAddPage(int index) {
        this.addPage(this.getEmptyPageContent(), index);
        this.updateVisibleContents();
    }

    protected void handlePageDelete(int index) {
        if (index >= this.pages.size()) {
            return;
        }
        this.pages.remove(index);
        this.updateVisibleContents();
    }

    protected void addPage(PageContent contents) {
        if (!this.canEditAndCreatePages) {
            return;
        }
        this.addPage(contents, this.pages.size());
    }

    protected void addPage(PageContent contents, int index) {
        if (!this.canEditAndCreatePages) {
            return;
        }
        if (this.pages.size() >= 100) {
            return;
        }
        this.pages.add(index, contents);
    }

    protected PageContent getOrCreatePageIfPossible(int index) {
        if (index > this.pages.size() - 1) {
            if (!this.canEditAndCreatePages) {
                return this.getEmptyPageContent();
            }
            this.addPage(this.getEmptyPageContent());
            this.updateVisibleContents();
        }
        return this.pages.get(index);
    }

    protected PageContent getPageOrEmpty(int index) {
        if (index > this.pages.size() - 1) {
            return this.getEmptyPageContent();
        }
        return this.pages.get(index);
    }

    protected void setPageContent(PageContent contents, int index) {
        if (index > this.pages.size() - 1) {
            this.addPage(contents);
            return;
        }
        this.pages.set(index, contents);
    }

    protected void turnForwardPage() {
        if (this.currentLeftPageIndex + 2 >= 100) {
            return;
        }
        if (this.currentLeftPageIndex + 3 >= this.getCurrentAmountOfPages() && this.canEditAndCreatePages) {
            if (this.getCurrentAmountOfPages() % 2 == 0) {
                this.addPage(this.getEmptyPageContent());
                this.addPage(this.getEmptyPageContent());
            } else if (this.currentLeftPageIndex + 1 == this.getCurrentAmountOfPages()) {
                this.addPage(this.getEmptyPageContent());
                this.addPage(this.getEmptyPageContent());
                this.addPage(this.getEmptyPageContent());
            } else if (this.getCurrentAmountOfPages() % 2 == 1) {
                this.addPage(this.getEmptyPageContent());
            }
        }
        this.ensureEvenPageIndex(this.currentLeftPageIndex + 2);
        this.resetEditControls();
        this.updateVisibleContents();
    }

    protected void turnBackPage() {
        this.ensureEvenPageIndex(Math.max(this.currentLeftPageIndex - 2, 0));
        this.resetEditControls();
        this.updateVisibleContents();
    }

    protected int getCurrentAmountOfPages() {
        return this.pages.size();
    }

    protected Component getPageIndicatorMessage(int index) {
        int offsetIndex = index + 1;
        if (offsetIndex > this.getCurrentAmountOfPages()) {
            return CommonComponents.EMPTY;
        }
        return Component.translatable((String)BOOK_PAGE_INDICATOR, (Object[])new Object[]{offsetIndex, this.getCurrentAmountOfPages()});
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        assert (this.minecraft != null);
        int keyCode = keyEvent.key();
        MouseButtonInfo inputWithModifiers = new MouseButtonInfo(0, 0);
        if (keyCode == ConfigOptions.MOVE_BACKWARD_PAGE_KEY.getPendingOrCurrentValue().getValue() && this.turnLeftButton.visible) {
            this.turnLeftButton.onPress((InputWithModifiers)inputWithModifiers);
            this.turnLeftButton.playDownSound(this.minecraft.getSoundManager());
            return true;
        }
        if (keyCode == ConfigOptions.MOVE_FORWARD_PAGE_KEY.getPendingOrCurrentValue().getValue() && this.turnRightButton.visible) {
            this.turnRightButton.onPress((InputWithModifiers)inputWithModifiers);
            this.turnLeftButton.playDownSound(this.minecraft.getSoundManager());
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    @NotNull
    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.getPageIndicatorMessage(this.currentLeftPageIndex)});
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int pageNumberYPos = this.height / 2 - 134 + 35;
        int leftPageNumberWidth = this.font.width((FormattedText)this.leftPageNumberMessage);
        guiGraphics.drawString(this.font, this.leftPageNumberMessage, this.width / 2 - 11 - 61 - leftPageNumberWidth / 2, pageNumberYPos, -4414585, false);
        int rightPageNumberWidth = this.font.width((FormattedText)this.rightPageNumberMessage);
        guiGraphics.drawString(this.font, this.rightPageNumberMessage, this.width / 2 + 11 + 61 - rightPageNumberWidth / 2, pageNumberYPos, -4414585, false);
        if (InputUtil.shouldShowDebugVariables()) {
            guiGraphics.drawString(this.font, "leftPageIndex: " + this.getCurrentLeftPageIndex(), 0, 56, -1);
        }
    }

    protected abstract ResourceLocation getBackgroundTexture();

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderMinecraftBackgrounds(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.getBackgroundTexture(), this.width / 2 - 256, this.height / 2 - 128, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    protected void renderMinecraftBackgrounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft != null && this.minecraft.level == null) {
            this.renderPanorama(guiGraphics, partialTick);
            this.renderBlurredBackground(guiGraphics);
            this.renderMenuBackground(guiGraphics);
        } else {
            this.renderTransparentBackground(guiGraphics);
        }
    }

    public static enum PageSide {
        LEFT,
        RIGHT;

    }

    public record TextViewAndWidget<Value, TextView extends TextAreaView<Value>>(TextView view, @Nullable AbstractWidget widget) {
    }

    public static enum PageMoveDirection {
        LEFT,
        RIGHT;

    }
}

