/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.duck.BookSignScreenAdditions;
import games.enchanted.eg_bedrock_books.common.screen.AbstractBedrockBookScreen;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.MultilineEditBoxView;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookSignScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;

public class BedrockBookEditScreen
extends AbstractBedrockBookScreen<String, TextAreaView<String>> {
    protected static final Component BOOK_EDIT_TITLE = Component.translatable((String)"book.edit.title");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"textures/gui/book/edit_background.png");
    protected final Player owner;
    protected final ItemStack bookStack;
    protected final InteractionHand hand;
    protected final BookSignScreen bookSignScreen;

    public BedrockBookEditScreen(Player owner, ItemStack book, InteractionHand hand, WritableBookContent writableBookContent) {
        super(BOOK_EDIT_TITLE, true);
        writableBookContent.getPages(Minecraft.getInstance().isTextFilteringEnabled()).forEach(this.pages::add);
        if (this.pages.isEmpty()) {
            this.addPage("");
            this.addPage("");
        } else if (this.pages.size() == 1) {
            this.addPage("");
        }
        this.owner = owner;
        this.bookStack = book;
        this.hand = hand;
        this.bookSignScreen = new BookSignScreen(null, owner, hand, this.pages);
        ((BookSignScreenAdditions)this.bookSignScreen).eg_bedrock_books$setReturnScreen(this);
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            assert (this.minecraft != null);
            this.minecraft.setScreen(null);
        }).width(90).build());
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)SIGN_BUTTON_COMPONENT, button -> {
            assert (this.minecraft != null);
            this.minecraft.setScreen((Screen)this.bookSignScreen);
        }).width(90).build());
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)SAVE_BUTTON_COMPONENT, button -> this.onClose()).width(90).build());
        this.footerButtonLayout.setPosition(this.width / 2 - 143, this.height / 2 + 90);
    }

    @Override
    protected AbstractBedrockBookScreen.TextViewAndWidget<String, TextAreaView<String>> createTextWidgetAndView(int x, int y, AbstractBedrockBookScreen.PageSide side) {
        MultiLineEditBox editBox = MultiLineEditBox.builder().setTextColor(-16777216).setCursorColor(-16777216).setShowDecorations(false).setShowBackground(false).setTextShadow(false).setX(x).setY(y).build(this.font, 122, 134, CommonComponents.EMPTY);
        editBox.setCharacterLimit(1024);
        Objects.requireNonNull(this.font);
        editBox.setLineLimit(126 / 9);
        editBox.setValueListener(newValue -> this.setPageContent(newValue, this.getCurrentLeftPageIndex() + (side == AbstractBedrockBookScreen.PageSide.RIGHT ? 1 : 0)));
        return new AbstractBedrockBookScreen.TextViewAndWidget<String, TextAreaView<String>>(new MultilineEditBoxView(editBox), (AbstractWidget)editBox);
    }

    public void onClose() {
        super.onClose();
        this.savePagesToStack();
    }

    @Override
    protected String getEmptyPageContent() {
        return "";
    }

    protected void savePagesToStack() {
        int slotId;
        this.removeTrailingEmptyPages();
        this.updateLocalStack();
        int n = slotId = this.hand == InteractionHand.MAIN_HAND ? this.owner.getInventory().getSelectedSlot() : 40;
        assert (this.minecraft != null);
        ClientPacketListener clientConnection = this.minecraft.getConnection();
        if (clientConnection != null) {
            clientConnection.send((Packet)new ServerboundEditBookPacket(slotId, this.pages, Optional.empty()));
        }
    }

    private void removeTrailingEmptyPages() {
        ListIterator pageIterator = this.pages.listIterator(this.pages.size());
        while (pageIterator.hasPrevious() && ((String)pageIterator.previous()).isEmpty()) {
            pageIterator.remove();
        }
    }

    private void updateLocalStack() {
        this.bookStack.set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)new WritableBookContent(this.pages.stream().map(Filterable::passThrough).toList()));
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }
}

