/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.AbstractBedrockBookScreen;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.ComponentTextAreaView;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class BedrockBookViewScreen
extends AbstractBedrockBookScreen<Component, TextAreaView<Component>> {
    protected static final Component BOOK_VIEW_TITLE = Component.translatable((String)"book.view.title");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"textures/gui/book/view_background.png");
    protected static final int FOOTER_BUTTON_WIDTH = 200;
    protected static final int TEXT_OFFSET_LEFT = 4;
    protected static final int TEXT_OFFSET_RIGHT = 4;
    protected static final int TEXT_OFFSET_TOP = 10;
    protected static final int PAGE_CLICK_BOUNDS_EXTRA_PADDING = 2;
    protected int leftPageX = 0;
    protected int leftPageY = 0;
    protected List<FormattedCharSequence> leftPageSplitLines = List.of();
    protected int rightPageX = 0;
    protected int rightPageY = 0;
    protected List<FormattedCharSequence> rightPageSplitLines = List.of();
    protected double mouseX = 0.0;
    protected double mouseY = 0.0;
    @Nullable
    protected Style styleUnderMouseCursor = null;

    public BedrockBookViewScreen(BookViewScreen.BookAccess bookAccess) {
        super(BOOK_VIEW_TITLE, false);
        this.pages = bookAccess.pages();
    }

    public BedrockBookViewScreen() {
        this(BookViewScreen.EMPTY_ACCESS);
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
        this.footerButtonLayout.setPosition(this.width / 2 - 100, this.height / 2 + 90);
    }

    @Override
    protected AbstractBedrockBookScreen.TextViewAndWidget<Component, TextAreaView<Component>> createTextWidgetAndView(int x, int y, AbstractBedrockBookScreen.PageSide side) {
        if (side == AbstractBedrockBookScreen.PageSide.LEFT) {
            this.leftPageX = x + 8 - this.getHorizontalLeftPageTextOffset();
            this.leftPageY = y + this.getVerticalTextOffset();
        } else {
            this.rightPageX = x + this.getHorizontalRightPageTextOffset();
            this.rightPageY = y + this.getVerticalTextOffset();
        }
        return new AbstractBedrockBookScreen.TextViewAndWidget<Component, TextAreaView<Component>>(new ComponentTextAreaView(component -> {
            int offsetIndex = this.getCurrentLeftPageIndex() + (side == AbstractBedrockBookScreen.PageSide.LEFT ? 0 : 1);
            if (side == AbstractBedrockBookScreen.PageSide.LEFT) {
                this.leftPageSplitLines = this.splitPage(offsetIndex);
            } else {
                this.rightPageSplitLines = this.splitPage(offsetIndex);
            }
        }), null);
    }

    protected int getHorizontalLeftPageTextOffset() {
        return 4;
    }

    protected int getHorizontalRightPageTextOffset() {
        return 4;
    }

    protected int getVerticalTextOffset() {
        return 10;
    }

    protected List<FormattedCharSequence> splitPage(int index) {
        return this.font.split((FormattedText)this.getPageOrEmpty(index), 114);
    }

    @Override
    protected Component getEmptyPageContent() {
        return CommonComponents.EMPTY;
    }

    @Override
    protected void turnForwardPage() {
        super.turnForwardPage();
        this.refreshStyleUnderMouse();
    }

    @Override
    protected void turnBackPage() {
        super.turnBackPage();
        this.refreshStyleUnderMouse();
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        Style clickedStyle = this.getStyleAt(this.mouseX, this.mouseY, null);
        int button = mouseButtonEvent.button();
        if (button == 0 && clickedStyle != null && this.handleComponentClicked(clickedStyle)) {
            return true;
        }
        return super.mouseClicked(mouseButtonEvent, doubleClick);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.refreshStyleUnderMouse();
    }

    protected void refreshStyleUnderMouse() {
        this.styleUnderMouseCursor = this.getStyleAt(this.mouseX, this.mouseY, null);
    }

    @Nullable
    public Style getStyleAt(double x, double y, @Nullable GuiGraphics guiGraphics) {
        int closestPageY;
        if (this.leftPageSplitLines.isEmpty() && this.rightPageSplitLines.isEmpty()) {
            return null;
        }
        boolean closestToLeftHorizontally = x < (double)(this.leftPageX + 114 + 2);
        int closestPageX = closestToLeftHorizontally ? this.leftPageX : this.rightPageX;
        int n = closestPageY = closestToLeftHorizontally ? this.leftPageY : this.rightPageY;
        if (x < (double)(closestPageX - 2) || x > (double)(closestPageX + 2 + 114)) {
            return null;
        }
        if (y < (double)(closestPageY - 2) || y > (double)(closestPageY + 2 + 128)) {
            return null;
        }
        int clampedRelativeX = (int)Math.clamp(x - (double)closestPageX, 0.0, (double)(closestPageX + 114));
        int clampedRelativeY = (int)Math.clamp(y - (double)closestPageY, 0.0, (double)(closestPageY + 128));
        if (guiGraphics != null && InputUtil.shouldShowDebugTextBound()) {
            this.drawXY(closestToLeftHorizontally ? 0 : 1, closestToLeftHorizontally ? 0 : 1, 0, guiGraphics);
            this.drawXY(closestPageX, closestPageY, 8, guiGraphics);
            this.drawXY(clampedRelativeX, clampedRelativeY, 16, guiGraphics);
        }
        Minecraft minecraft = Minecraft.getInstance();
        Objects.requireNonNull(minecraft.font);
        int lineIndex = clampedRelativeY / 9;
        if (lineIndex >= 0 && lineIndex < (closestToLeftHorizontally ? this.leftPageSplitLines.size() : this.rightPageSplitLines.size())) {
            FormattedCharSequence line = (closestToLeftHorizontally ? this.leftPageSplitLines : this.rightPageSplitLines).get(lineIndex);
            return minecraft.font.getSplitter().componentStyleAtWidth(line, clampedRelativeX);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleClickEvent(Minecraft minecraft, ClickEvent clickEvent) {
        ClickEvent clickEvent2 = clickEvent;
        Objects.requireNonNull(clickEvent2);
        ClickEvent clickEvent3 = clickEvent2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.RunCommand.class, ClickEvent.ChangePage.class}, (Object)clickEvent3, n)) {
            case 0: {
                BedrockBookViewScreen bedrockBookViewScreen;
                LocalPlayer localPlayer;
                String string2;
                ClickEvent.RunCommand runCommand = (ClickEvent.RunCommand)clickEvent3;
                try {
                    String string;
                    string2 = string = runCommand.command();
                    if (ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getValue().booleanValue()) {
                        this.closeServerContainer();
                    }
                    if (minecraft.player == null) return;
                    localPlayer = minecraft.player;
                    bedrockBookViewScreen = ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getValue().booleanValue() ? null : this;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                BedrockBookViewScreen.clickCommandAction((LocalPlayer)localPlayer, (String)string2, (Screen)bedrockBookViewScreen);
                return;
            }
            case 1: {
                ClickEvent.ChangePage changePage = (ClickEvent.ChangePage)clickEvent3;
                {
                    int n2;
                    int i = n2 = changePage.page();
                    this.setPageIndex(i - 1);
                    return;
                }
            }
        }
        BedrockBookViewScreen.defaultHandleGameClickEvent((ClickEvent)clickEvent, (Minecraft)minecraft, (Screen)this);
    }

    protected void closeServerContainer() {
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        Objects.requireNonNull(this.font);
        int leftLines = Math.min(128 / 9, this.leftPageSplitLines.size());
        for (int i = 0; i < leftLines; ++i) {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, this.leftPageSplitLines.get(i), this.leftPageX, this.leftPageY + i * 9, -16777216, false);
        }
        Objects.requireNonNull(this.font);
        int rightLines = Math.min(128 / 9, this.rightPageSplitLines.size());
        for (int i = 0; i < rightLines; ++i) {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, this.rightPageSplitLines.get(i), this.rightPageX, this.rightPageY + i * 9, -16777216, false);
        }
        guiGraphics.renderComponentHoverEffect(this.font, this.styleUnderMouseCursor, mouseX, mouseY);
        if (InputUtil.shouldShowDebugTextBound()) {
            guiGraphics.fillGradient(this.leftPageX - 2, this.leftPageY - 2, this.leftPageX + 114 + 2, this.leftPageY + 128 + 2, 0x22000000, 0x22000000);
            guiGraphics.fillGradient(this.rightPageX - 2, this.rightPageY - 2, this.rightPageX + 114 + 2, this.rightPageY + 128 + 2, 0x22000000, 0x22000000);
        }
        if (InputUtil.shouldShowDebugVariables()) {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, "style under cursor: ", 0, this.height - 9 * 2, -1);
            String string = this.styleUnderMouseCursor == null ? "<none>" : this.styleUnderMouseCursor.toString();
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, string, 0, this.height - 9, -1);
        }
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }

    protected void setBookAccess(BookViewScreen.BookAccess bookAccess) {
        this.pages = bookAccess.pages();
        this.ensureEvenPageIndex(Math.clamp((long)this.getCurrentLeftPageIndex(), 0, Math.max(0, bookAccess.getPageCount() - 1)));
        this.updateVisibleContents();
    }

    protected void setPageIndex(int index) {
        this.ensureEvenPageIndex(Math.clamp((long)index, 0, Math.max(0, this.getCurrentAmountOfPages() - 1)));
        this.updateVisibleContents();
    }

    private void drawXY(int x, int y, int yoffset, GuiGraphics guiGraphics) {
        String string = String.format(Locale.ROOT, "%s, %s", x, y);
        guiGraphics.drawString(this.font, string, 0, 0 + yoffset, -1);
    }
}

