/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.BedrockBookViewScreen;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.TogglableSpriteButton;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.LecternMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BedrockLecternScreen
extends BedrockBookViewScreen
implements MenuAccess<LecternMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"textures/gui/book/lectern_background.png");
    protected static final int FOOTER_BUTTON_WIDTH = 120;
    protected static final int TEXT_OFFSET_LEFT = 7;
    protected static final int TEXT_OFFSET_RIGHT = 7;
    protected static final Component TAKE_BOOK_COMPONENT = Component.translatable((String)"lectern.take_book");
    public static final int RIBBON_WIDTH = 18;
    public static final int RIBBON_TOP_HEIGHT = 11;
    public static final int RIBBON_BOTTOM_HEIGHT = 29;
    public static final int RIBBON_Y_OFFSET = 111;
    Component RIBBON_TOOLTIP = Component.translatable((String)"ui.eg_bedrock_books.lectern.bookmark_tooltip");
    Component LEFT_RIBBON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.lectern.bookmark_left_label");
    protected static final CustomSpriteButton.ButtonConfig LEFT_RIBBON_SELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/left_page_selected_ribbon"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/left_page_selected_ribbon_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/left_page_selected_ribbon_focus"));
    protected static final CustomSpriteButton.ButtonConfig LEFT_RIBBON_UNSELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/left_page_unselected_ribbon"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/left_page_unselected_ribbon_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/left_page_unselected_ribbon_focus"));
    Component RIGHT_RIBBON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.lectern.bookmark_right_label");
    public static final ResourceLocation RIGHT_RIBBON_SELECTED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/right_page_selected_ribbon");
    protected static final CustomSpriteButton.ButtonConfig RIGHT_RIBBON_SELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), RIGHT_RIBBON_SELECTED_SPRITE, ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/right_page_selected_ribbon_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/right_page_selected_ribbon_focus"));
    protected static final CustomSpriteButton.ButtonConfig RIGHT_RIBBON_UNSELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/right_page_unselected_ribbon"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/right_page_unselected_ribbon_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/lectern/right_page_unselected_ribbon_focus"));
    private final LecternMenu menu;
    private final ContainerListener containerListener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
            BedrockLecternScreen.this.bookDataChanged();
        }

        public void dataChanged(AbstractContainerMenu menu, int slotIndex, int value) {
            if (slotIndex == 0) {
                BedrockLecternScreen.this.pageIndexChanged();
            }
        }
    };
    protected TogglableSpriteButton leftPageRibbon;
    protected TogglableSpriteButton rightPageRibbon;

    public BedrockLecternScreen(LecternMenu menu) {
        this.menu = menu;
    }

    @Override
    protected void init() {
        int totalRibbonHeight = 11 + ConfigOptions.RIBBON_HEIGHT.getValue() + 29;
        this.leftPageRibbon = new TogglableSpriteButton(this.width / 2 - 18, this.height / 2 - 111, 18, totalRibbonHeight, button -> {
            this.setPageIndex(this.getCurrentLeftPageIndex());
            this.updateVisibleContents();
        }, this.LEFT_RIBBON_LABEL, LEFT_RIBBON_UNSELECTED_CONFIG, LEFT_RIBBON_SELECTED_CONFIG);
        this.leftPageRibbon.setTooltip(Tooltip.create((Component)this.RIBBON_TOOLTIP));
        this.rightPageRibbon = new TogglableSpriteButton(this.width / 2, this.height / 2 - 111, 18, totalRibbonHeight, button -> {
            this.setPageIndex(this.getCurrentLeftPageIndex() + 1);
            this.updateVisibleContents();
        }, this.RIGHT_RIBBON_LABEL, RIGHT_RIBBON_UNSELECTED_CONFIG, RIGHT_RIBBON_SELECTED_CONFIG);
        this.rightPageRibbon.setTooltip(Tooltip.create((Component)this.RIBBON_TOOLTIP));
        super.init();
        this.menu.addSlotListener(this.containerListener);
    }

    @Override
    protected void addWidgetsBetweenPages() {
        super.addWidgetsBetweenPages();
        this.addRenderableWidget((GuiEventListener)this.leftPageRibbon);
        this.addRenderableWidget((GuiEventListener)this.rightPageRibbon);
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(120).build());
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)TAKE_BOOK_COMPONENT, button -> this.sendContainerButtonClick(3)).width(120).build());
        this.footerButtonLayout.setPosition(this.width / 2 - 124, this.height / 2 + 90);
    }

    @Override
    protected int getHorizontalLeftPageTextOffset() {
        return 7;
    }

    @Override
    protected int getHorizontalRightPageTextOffset() {
        return 7;
    }

    @Override
    protected void updateVisibleContents() {
        boolean morePagesAfterLeft;
        super.updateVisibleContents();
        if (this.isContainerOnLeftPage()) {
            this.leftPageRibbon.setToggle(true);
            this.rightPageRibbon.setToggle(false);
            this.turnRightButton.visible = this.getContainerPageIndex() < this.getCurrentAmountOfPages() - 1;
        } else {
            this.leftPageRibbon.setToggle(false);
            this.rightPageRibbon.setToggle(true);
            this.turnLeftButton.visible = true;
        }
        this.rightPageRibbon.visible = morePagesAfterLeft = this.getCurrentLeftPageIndex() < this.getCurrentAmountOfPages() - 1;
        this.leftPageRibbon.visible = !this.pages.isEmpty();
    }

    @Override
    protected void turnForwardPage() {
        if (this.isContainerOnLeftPage()) {
            if (this.getContainerPageIndex() > this.getCurrentAmountOfPages() - 1) {
                return;
            }
            this.setContainerPageIndex(this.getCurrentLeftPageIndex() + 1);
            this.updateVisibleContents();
        } else {
            super.turnForwardPage();
            this.setContainerPageIndex(this.getCurrentLeftPageIndex());
        }
    }

    @Override
    protected void turnBackPage() {
        if (this.isContainerOnLeftPage()) {
            this.setContainerPageIndex(this.getCurrentLeftPageIndex() - 1);
            super.turnBackPage();
        } else {
            if (this.getContainerPageIndex() <= 0) {
                return;
            }
            this.setContainerPageIndex(this.getCurrentLeftPageIndex());
            this.updateVisibleContents();
        }
    }

    protected boolean isContainerOnLeftPage() {
        return this.getCurrentLeftPageIndex() == this.getContainerPageIndex();
    }

    @Override
    protected void setPageIndex(int index) {
        super.setPageIndex(index);
        this.setContainerPageIndex(index);
    }

    protected void setContainerPageIndex(int index) {
        if (index != this.menu.getPage()) {
            this.sendContainerButtonClick(100 + index);
        }
    }

    protected int getContainerPageIndex() {
        return this.menu.getPage();
    }

    protected void bookDataChanged() {
        this.setBookAccess(Objects.requireNonNullElse(BookViewScreen.BookAccess.fromItem((ItemStack)this.menu.getBook()), BookViewScreen.EMPTY_ACCESS));
    }

    protected void pageIndexChanged() {
        this.setPageIndex(this.menu.getPage());
    }

    protected void sendContainerButtonClick(int buttonId) {
        Objects.requireNonNull(this.minecraft, "this.minecraft is null");
        Objects.requireNonNull(this.minecraft.gameMode, "this.minecraft.gameMode is null");
        this.minecraft.gameMode.handleInventoryButtonClick(this.menu.containerId, buttonId);
    }

    public void onClose() {
        super.onClose();
        this.closeServerContainer();
    }

    public void removed() {
        super.removed();
        this.menu.removeSlotListener(this.containerListener);
    }

    @Override
    protected void closeServerContainer() {
        Objects.requireNonNull(this.minecraft, "this.minecraft is null");
        Objects.requireNonNull(this.minecraft.player, "this.minecraft.player is null");
        this.minecraft.player.closeContainer();
    }

    @NotNull
    public LecternMenu getMenu() {
        return this.menu;
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (InputUtil.shouldShowDebugContainerData()) {
            guiGraphics.drawString(this.font, "containerIndex: " + this.menu.getPage(), 0, 64, -1);
        }
    }
}

