/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen.config;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.AbstractBedrockBookScreen;
import games.enchanted.eg_bedrock_books.common.screen.config.ConfigScreenVisual;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.KeyBox;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.DummyTextAreaView;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigScreenBehaviour
extends AbstractBedrockBookScreen<String, TextAreaView<String>> {
    protected static final Component CONFIG_TITLE = Component.translatable((String)"ui.eg_bedrock_books.config.title");
    protected static final Component RESET_BUTTON_COMPONENT = Component.translatable((String)"ui.eg_bedrock_books.config.reset");
    protected static final Component RESET_TITLE_COMPONENT = Component.translatable((String)"ui.eg_bedrock_books.config.reset.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    protected static final Component RESET_MESSAGE_COMPONENT = Component.translatable((String)"ui.eg_bedrock_books.config.reset.warning");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"textures/gui/book/config_background.png");
    @Nullable
    protected final Screen returnScreen;
    protected final boolean alwaysBlurBackground;

    protected ConfigScreenBehaviour(@Nullable Screen returnScreen, boolean alwaysBlurBackground) {
        super(CONFIG_TITLE, false);
        this.returnScreen = returnScreen;
        this.alwaysBlurBackground = alwaysBlurBackground;
        this.pages = List.of(this.getEmptyPageContent(), this.getEmptyPageContent(), this.getEmptyPageContent());
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.cancelAndClose()).width(90).build());
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)RESET_BUTTON_COMPONENT, button -> this.resetWithConfirmation()).width(90).build());
        this.footerButtonLayout.addChild((LayoutElement)Button.builder((Component)SAVE_BUTTON_COMPONENT, button -> this.saveAndClose()).width(90).build());
        this.footerButtonLayout.setPosition(this.width / 2 - 143, this.height / 2 + 90);
    }

    protected void cancelAndClose() {
        ConfigOptions.clearAllPendingValues();
        this.onClose();
    }

    protected void saveAndClose() {
        ConfigOptions.saveIfAnyDirtyOptions();
        this.onClose();
    }

    protected void resetWithConfirmation() {
        ConfirmScreen confirmScreen = new ConfirmScreen(confirmed -> {
            Minecraft.getInstance().setScreen((Screen)this);
            if (!confirmed) {
                return;
            }
            ConfigOptions.resetAndSaveAllOptions();
            this.onClose();
        }, RESET_TITLE_COMPONENT, RESET_MESSAGE_COMPONENT);
        Minecraft.getInstance().setScreen((Screen)confirmScreen);
    }

    public void onClose() {
        if (this.minecraft != null && this.returnScreen != null) {
            this.minecraft.setScreen(this.returnScreen);
        }
    }

    @Override
    protected void addConfigButton() {
    }

    @Override
    protected AbstractBedrockBookScreen.TextViewAndWidget<String, TextAreaView<String>> createTextWidgetAndView(int x, int y, AbstractBedrockBookScreen.PageSide side) {
        return new AbstractBedrockBookScreen.TextViewAndWidget<String, TextAreaView<String>>(new DummyTextAreaView(), null);
    }

    @Override
    protected String getEmptyPageContent() {
        return "";
    }

    @Override
    @NotNull
    public Component getNarrationMessage() {
        return CONFIG_TITLE;
    }

    public boolean shouldCloseOnEsc() {
        KeyBox keyBox;
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof KeyBox && (keyBox = (KeyBox)guiEventListener).isListeningForInput()) {
            return false;
        }
        return super.shouldCloseOnEsc();
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }

    @Override
    protected void renderMinecraftBackgrounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.alwaysBlurBackground) {
            super.renderMinecraftBackgrounds(guiGraphics, mouseX, mouseY, partialTick);
            return;
        }
        if (this.minecraft != null && this.minecraft.level == null) {
            this.renderPanorama(guiGraphics, partialTick);
        }
        this.renderBlurredBackground(guiGraphics);
        this.renderMenuBackground(guiGraphics);
    }

    public static Screen makeScreenForModMenu(@Nullable Screen returnScreen) {
        return new ConfigScreenVisual(returnScreen, true);
    }

    public static Screen makeScreen(@Nullable Screen returnScreen) {
        return new ConfigScreenVisual(returnScreen);
    }

    public static void openConfigScreen(@Nullable Screen returnScreen) {
        Minecraft.getInstance().setScreen(ConfigScreenBehaviour.makeScreen(returnScreen));
    }
}

