/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen.config;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.config.option.ConfigOption;
import games.enchanted.eg_bedrock_books.common.screen.AbstractBedrockBookScreen;
import games.enchanted.eg_bedrock_books.common.screen.BedrockLecternScreen;
import games.enchanted.eg_bedrock_books.common.screen.config.ConfigScreenBehaviour;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.CheckBox;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.IntegerSlider;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.KeyBox;
import games.enchanted.eg_bedrock_books.common.screen.widget.scroll.ConfigList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class ConfigScreenVisual
extends ConfigScreenBehaviour {
    protected static final int MAX_LAYOUT_WIDTH = 120;
    protected static final int MAX_LAYOUT_HEIGHT = 140;
    protected static final int CENTER_PADDING = 24;
    protected static final int COLUMN_GAP = 8;
    protected static final int ROW_GAP = 5;
    protected static final int PAGE_TEXT_COLOUR = -6785961;
    public static final CustomSpriteButton.ButtonConfig CHECKBOX_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/checkbox_unchecked"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/checkbox_unchecked_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/checkbox_unchecked_focus"));
    public static final CustomSpriteButton.ButtonConfig CHECKBOX_UNCHECKED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/checkbox_checked"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/checkbox_checked_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/checkbox_checked_focus"));
    public static ResourceLocation SLIDER_BACKGROUND_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/slider_background");
    public static final CustomSpriteButton.ButtonConfig SLIDER_HANDLE_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/slider_handle"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/slider_handle_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/slider_handle_focus"));
    protected static final List<ConfigOption<Boolean>> DEBUG_OPTIONS = List.of(ConfigOptions.DEBUG_WIDGET_BOUNDS, ConfigOptions.DEBUG_TEXT_BOUNDS, ConfigOptions.DEBUG_CONTAINER_DATA, ConfigOptions.DEBUG_VARIABLES);
    protected ConfigList generalOptionList;
    protected ConfigList visualOptionList;
    protected ConfigList debugOptionList;

    protected ConfigScreenVisual(@Nullable Screen returnScreen, boolean alwaysBlurBackground) {
        super(returnScreen, alwaysBlurBackground);
    }

    protected ConfigScreenVisual(@Nullable Screen returnScreen) {
        super(returnScreen, false);
    }

    @Override
    protected void addWidgetsBetweenPages() {
        super.addWidgetsBetweenPages();
        this.generalOptionList = this.createPageLayout(AbstractBedrockBookScreen.PageSide.LEFT);
        this.visualOptionList = this.createPageLayout(AbstractBedrockBookScreen.PageSide.RIGHT);
        this.debugOptionList = this.createPageLayout(AbstractBedrockBookScreen.PageSide.LEFT);
        Component closeOnCommandRunLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.close_when_running_command");
        CheckBox closeOnCommandRunWidget = new CheckBox(0, 0, ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getPendingOrCurrentValue(), ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND::setPendingValue, closeOnCommandRunLabel, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG);
        closeOnCommandRunWidget.setTooltip(Tooltip.create((Component)Component.translatable((String)"ui.eg_bedrock_books.config.option.close_when_running_command.tooltip")));
        this.addHorizontalOption(this.generalOptionList, (AbstractWidget)closeOnCommandRunWidget, closeOnCommandRunLabel);
        Component turnForwardPageLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.key.turn_forward_page");
        KeyBox turnForwardPageWidget = new KeyBox(0, 0, ConfigOptions.MOVE_FORWARD_PAGE_KEY.getPendingOrCurrentValue(), ConfigOptions.MOVE_FORWARD_PAGE_KEY::setPendingValue, turnForwardPageLabel);
        this.addHorizontalOption(this.generalOptionList, (AbstractWidget)turnForwardPageWidget, turnForwardPageLabel);
        Component turnBackwardPageLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.key.turn_backward_page");
        KeyBox turnBackwardPageWidget = new KeyBox(0, 0, ConfigOptions.MOVE_BACKWARD_PAGE_KEY.getPendingOrCurrentValue(), ConfigOptions.MOVE_BACKWARD_PAGE_KEY::setPendingValue, turnBackwardPageLabel);
        this.addHorizontalOption(this.generalOptionList, (AbstractWidget)turnBackwardPageWidget, turnBackwardPageLabel);
        Component vanillaScreenKeybindEnabledLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.open_vanilla_screen_key");
        CheckBox vanillaScreenKeyEnabledWidget = new CheckBox(0, 0, ConfigOptions.VANILLA_BOOK_KEY_ENABLED.getPendingOrCurrentValue(), ConfigOptions.VANILLA_BOOK_KEY_ENABLED::setPendingValue, vanillaScreenKeybindEnabledLabel, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG);
        Tooltip vanillaScreenKeyTooltip = Tooltip.create((Component)Component.translatable((String)"ui.eg_bedrock_books.config.key.open_vanilla_screen_key.tooltip"));
        vanillaScreenKeyEnabledWidget.setTooltip(vanillaScreenKeyTooltip);
        this.addHorizontalOption(this.generalOptionList, (AbstractWidget)vanillaScreenKeyEnabledWidget, vanillaScreenKeybindEnabledLabel);
        Component vanillaScreenKeyLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.key.open_vanilla_screen_key");
        KeyBox vanillaScreenKeyInput = new KeyBox(0, 0, ConfigOptions.VANILLA_BOOK_KEY.getPendingOrCurrentValue(), ConfigOptions.VANILLA_BOOK_KEY::setPendingValue, vanillaScreenKeyLabel);
        vanillaScreenKeyInput.setTooltip(vanillaScreenKeyTooltip);
        this.addHorizontalOption(this.generalOptionList, (AbstractWidget)vanillaScreenKeyInput, vanillaScreenKeyLabel);
        Component showXButtonLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.show_x_button");
        CheckBox showXButtonWidget = new CheckBox(0, 0, ConfigOptions.SHOW_X_BUTTON.getPendingOrCurrentValue(), value -> {
            ConfigOptions.SHOW_X_BUTTON.setPendingValue(value);
            this.xButton.visible = value;
        }, showXButtonLabel, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG);
        this.addHorizontalOption(this.visualOptionList, (AbstractWidget)showXButtonWidget, showXButtonLabel);
        Component ribbonHeightLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.ribbon_height");
        IntegerSlider ribbonHeightWidget = new IntegerSlider(0, 0, 120, 16, ribbonHeightLabel, ConfigOptions.RIBBON_HEIGHT.getPendingOrCurrentValue(), ConfigOptions.RIBBON_HEIGHT::setPendingValue, 0, 130, SLIDER_BACKGROUND_SPRITE, SLIDER_HANDLE_CONFIG);
        this.addStackedOption(this.visualOptionList, (AbstractWidget)ribbonHeightWidget, ribbonHeightLabel);
        for (ConfigOption<Boolean> option : DEBUG_OPTIONS) {
            Component optionLabel = this.literalComponentForPage(option.getJsonKey());
            this.addStackedOption(this.debugOptionList, (AbstractWidget)new CheckBox(0, 0, option.getPendingOrCurrentValue(), option::setPendingValue, optionLabel, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG), optionLabel);
        }
        this.addRenderableWidget((GuiEventListener)this.generalOptionList);
        this.addRenderableWidget((GuiEventListener)this.visualOptionList);
        this.addRenderableWidget((GuiEventListener)this.debugOptionList);
    }

    protected Component translatableComponentForPage(String translationKey) {
        return Component.translatable((String)translationKey).withStyle(Style.EMPTY.withColor(-6785961).withShadowColor(0));
    }

    protected Component literalComponentForPage(String literal) {
        return Component.literal((String)literal).withStyle(Style.EMPTY.withColor(-6785961).withShadowColor(0));
    }

    protected ConfigList createPageLayout(AbstractBedrockBookScreen.PageSide side) {
        int x = side == AbstractBedrockBookScreen.PageSide.LEFT ? this.width / 2 - 12 - 120 : this.width / 2 + 12 + 4;
        int y = this.height / 2 - 140 + 55;
        return new ConfigList(this.minecraft, 120, 135, x, y);
    }

    protected void addHorizontalOption(ConfigList configList, AbstractWidget widget, Component label) {
        MultiLineTextWidget labelWidget = new MultiLineTextWidget(label, Minecraft.getInstance().font);
        labelWidget.setMaxWidth(Math.abs(widget.getWidth() - 120) - 8);
        configList.addHorizontal(widget, labelWidget);
    }

    protected void addStackedOption(ConfigList configList, AbstractWidget widget, Component label) {
        MultiLineTextWidget labelWidget = new MultiLineTextWidget(label, Minecraft.getInstance().font);
        labelWidget.setMaxWidth(112);
        configList.addStacked(widget, labelWidget);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.getCurrentLeftPageIndex() == 0) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, BedrockLecternScreen.RIGHT_RIBBON_SELECTED_SPRITE, this.width / 2, this.height / 2 - 111, 18, 11 + ConfigOptions.RIBBON_HEIGHT.getPendingOrCurrentValue() + 29);
        }
    }

    @Override
    protected Component getPageIndicatorMessage(int index) {
        return switch (index) {
            case 0 -> Component.translatable((String)"ui.eg_bedrock_books.config.page.general");
            case 1 -> Component.translatable((String)"ui.eg_bedrock_books.config.page.visual");
            case 2 -> Component.translatable((String)"ui.eg_bedrock_books.config.page.debug");
            default -> super.getPageIndicatorMessage(index);
        };
    }

    @Override
    protected void updateVisibleContents() {
        super.updateVisibleContents();
        if (this.getCurrentLeftPageIndex() == 0) {
            this.generalOptionList.visible = true;
            this.visualOptionList.visible = true;
            this.debugOptionList.visible = false;
        } else {
            this.generalOptionList.visible = false;
            this.visualOptionList.visible = false;
            this.debugOptionList.visible = true;
        }
    }
}

