/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen.widget;

import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class EditControls
implements Renderable,
LayoutElement {
    private static final int EDIT_BUTTON_SIZE = 20;
    private static final int MAX_VISIBLE_BUTTONS = 4;
    protected static final Component PENCIL_BUTTON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.edit.open_edit_controls_label");
    protected static final CustomSpriteButton.ButtonConfig PENCIL_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/edit_button"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/edit_button_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/edit_button_focus"));
    protected static final Component MOVE_BACK_BUTTON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.edit.move_page_back_label");
    protected static final CustomSpriteButton.ButtonConfig MOVE_BACK_BUTTON = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/move_page_backward_button"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/move_page_backward_button_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/move_page_backward_button_focus"));
    protected static final Component ADD_PAGE_BUTTON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.edit.add_page_label");
    protected static final CustomSpriteButton.ButtonConfig ADD_PAGE_BUTTON = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/add_page_button"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/add_page_button_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/add_page_button_focus"));
    protected static final Component DELETE_PAGE_BUTTON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.edit.delete_page_label");
    protected static final CustomSpriteButton.ButtonConfig DELETE_PAGE_BUTTON = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/delete_page_button"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/delete_page_button_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/delete_page_button_focus"));
    protected static final Component MOVE_FORWARD_BUTTON_LABEL = Component.translatable((String)"ui.eg_bedrock_books.edit.move_page_forward_label");
    protected static final CustomSpriteButton.ButtonConfig MOVE_FORWARD_BUTTON = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/move_page_forward_button"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/move_page_forward_button_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"book/move_page_forward_button_focus"));
    protected int x;
    protected int y;
    protected boolean preventVisibilityUpdates = false;
    private boolean controlsVisible = false;
    protected boolean moveBackButtonVisible = true;
    protected boolean moveForwardButtonVisible = true;
    protected final LinearLayout layout;
    protected final CustomSpriteButton pencilButton;
    protected final Actions buttonActions;
    protected final CustomSpriteButton moveBackButton;
    protected final CustomSpriteButton addButton;
    protected final CustomSpriteButton deleteButton;
    protected final CustomSpriteButton moveForwardButton;

    public EditControls(int x, int y, Actions buttonActions) {
        this.x = x;
        this.y = y;
        this.buttonActions = buttonActions;
        this.layout = new LinearLayout(80, 20, LinearLayout.Orientation.HORIZONTAL);
        this.layout.setPosition(x, y);
        this.pencilButton = new CustomSpriteButton(0, 0, 20, 20, button -> this.toggleControls(true), PENCIL_BUTTON_LABEL, PENCIL_BUTTON_CONFIG);
        this.moveBackButton = new CustomSpriteButton(0, 0, 20, 20, button -> this.buttonActions.moveBackPressed().run(), MOVE_BACK_BUTTON_LABEL, MOVE_BACK_BUTTON);
        this.moveBackButton.visible = false;
        this.layout.addChild((LayoutElement)this.moveBackButton);
        this.addButton = new CustomSpriteButton(0, 0, 20, 20, button -> this.buttonActions.addPressed().run(), ADD_PAGE_BUTTON_LABEL, ADD_PAGE_BUTTON);
        this.addButton.visible = false;
        this.layout.addChild((LayoutElement)this.addButton);
        this.deleteButton = new CustomSpriteButton(0, 0, 20, 20, button -> this.buttonActions.deletePressed().run(), DELETE_PAGE_BUTTON_LABEL, DELETE_PAGE_BUTTON);
        this.deleteButton.visible = false;
        this.layout.addChild((LayoutElement)this.deleteButton);
        this.moveForwardButton = new CustomSpriteButton(0, 0, 20, 20, button -> this.buttonActions.moveForwardPressed().run(), MOVE_FORWARD_BUTTON_LABEL, MOVE_FORWARD_BUTTON);
        this.moveForwardButton.visible = false;
        this.layout.addChild((LayoutElement)this.moveForwardButton);
        this.layout.arrangeElements();
        this.repositionElements();
    }

    public void toggleControls(boolean showControls) {
        if (this.preventVisibilityUpdates) {
            return;
        }
        this.controlsVisible = showControls;
        this.pencilButton.visible = !showControls;
        this.moveBackButton.visible = showControls && this.moveBackButtonVisible;
        this.addButton.visible = showControls;
        this.deleteButton.visible = showControls;
        this.moveForwardButton.visible = showControls && this.moveForwardButtonVisible;
        this.repositionElements();
    }

    public void toggleControls() {
        this.toggleControls(!this.controlsVisible);
    }

    public void updateControlVisibility() {
        this.toggleControls(this.controlsVisible);
    }

    public void setMoveForwardButtonVisible(boolean newValue) {
        this.moveForwardButtonVisible = newValue;
        this.updateControlVisibility();
        this.repositionElements();
    }

    public void setMoveBackButtonVisible(boolean newValue) {
        this.moveBackButtonVisible = newValue;
        this.updateControlVisibility();
        this.repositionElements();
    }

    protected int getVisibleButtons() {
        return 2 + (this.moveBackButtonVisible ? 1 : 0) + (this.moveForwardButtonVisible ? 1 : 0);
    }

    public void setVisibility(boolean visibility) {
        boolean bl = this.preventVisibilityUpdates = !visibility;
        if (!visibility) {
            this.visitWidgets(widget -> {
                widget.visible = false;
            });
        } else {
            this.toggleControls(this.controlsVisible);
        }
    }

    public void visitWidgets(Consumer<AbstractWidget> visitor) {
        visitor.accept((AbstractWidget)this.pencilButton);
        this.layout.visitChildren(element -> element.visitWidgets(visitor));
    }

    public void repositionElements() {
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        this.layout.arrangeElements();
        int moveLeftOrRight = this.moveForwardButtonVisible ? -1 : 1;
        this.layout.setPosition(this.x + (this.getVisibleButtons() == 3 ? 10 * moveLeftOrRight : 0), this.y);
        FrameLayout.centerInRectangle((LayoutElement)this.pencilButton, (ScreenRectangle)this.getRectangle());
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 20;
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.x, this.y, this.getWidth(), this.getHeight());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!InputUtil.shouldShowDebugWidgetBound()) {
            return;
        }
        guiGraphics.fillGradient(this.getRectangle().left(), this.getRectangle().top(), this.getRectangle().right(), this.getRectangle().bottom(), -1442775041, -1442775041);
        guiGraphics.fillGradient(this.layout.getX(), this.layout.getY(), this.layout.getX() + 12, this.layout.getY() + 12, -1442775296, -1442775296);
    }

    public record Actions(Runnable moveBackPressed, Runnable addPressed, Runnable deletePressed, Runnable moveForwardPressed) {
    }
}

