/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen.widget.config;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class KeyBox
extends AbstractButton {
    public static final int TEXT_COLOUR = -6785961;
    public static final int WIDTH = 52;
    public static final int HEIGHT = 16;
    protected static final int INLINE_PADDING = 4;
    public static final CustomSpriteButton.ButtonConfig DEFAULT_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/key_input"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/key_input_hover"), ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/key_input_focus"));
    private final KeyPress onKeyPress;
    private final CustomSpriteButton.ButtonConfig buttonConfig;
    private InputConstants.Key selectedKey;
    private boolean acceptingKey = false;

    public KeyBox(int x, int y, InputConstants.Key initialKey, KeyPress onKeyPress, Component message, CustomSpriteButton.ButtonConfig buttonConfig) {
        super(x, y, 52, 16, message);
        this.onKeyPress = onKeyPress;
        this.buttonConfig = buttonConfig;
        this.selectedKey = initialKey;
    }

    public KeyBox(int x, int y, InputConstants.Key initialKey, KeyPress onKeyPress, Component message) {
        this(x, y, initialKey, onKeyPress, message, DEFAULT_BUTTON_CONFIG);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.acceptingKey) {
            this.acceptingKey = false;
            int keyCode = keyEvent.key();
            int scanCode = keyEvent.scancode();
            if (keyCode == 256 || keyCode == 258) {
                return super.keyPressed(keyEvent);
            }
            this.selectedKey = InputUtil.getKey(keyCode, scanCode);
            this.onKeyPress.keyPress(this.selectedKey);
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.acceptingKey = !this.acceptingKey;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.isHovered() ? this.buttonConfig.hoverSprite() : (this.isFocused() ? this.buttonConfig.focusedSprite() : this.buttonConfig.sprite()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.drawKeyLabel(guiGraphics, this.selectedKey.getDisplayName(), this.getX() + 4, this.getY(), this.getX() + this.getWidth() - 4, this.getY() + this.getHeight());
        Font font = Minecraft.getInstance().font;
        if (this.acceptingKey) {
            int leftWidth = font.width(">");
            int n = this.getX() - leftWidth - leftWidth / 2;
            int n2 = this.getY();
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, ">", n, n2 + 9 / 2, -6785961, false);
            int rightWidth = font.width("<");
            int n3 = this.getX() + this.getWidth() + rightWidth / 2;
            int n4 = this.getY();
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, "<", n3, n4 + 9 / 2, -6785961, false);
        }
        if (this.isHovered()) {
            guiGraphics.requestCursor(this.isActive() ? CursorTypes.POINTING_HAND : CursorTypes.NOT_ALLOWED);
        }
    }

    protected void drawKeyLabel(GuiGraphics guiGraphics, Component keyName, int minX, int minY, int maxX, int maxY) {
        Font font = Minecraft.getInstance().font;
        AbstractWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)keyName.copy().withStyle(Style.EMPTY.withShadowColor(0)), (int)minX, (int)minY, (int)maxX, (int)(maxY + 1), (int)-6785961);
        if (InputUtil.shouldShowDebugTextBound()) {
            guiGraphics.fill(minX, minY, maxX, maxY, -1157562624);
        }
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        return Component.translatable((String)"narrator.controls.bound", (Object[])new Object[]{this.getMessage(), this.selectedKey.getDisplayName()});
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }

    public boolean isListeningForInput() {
        return this.acceptingKey;
    }

    public static interface KeyPress {
        public void keyPress(InputConstants.Key var1);
    }
}

