/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen.widget.scroll;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import games.enchanted.eg_bedrock_books.common.mixin.accessor.AbstractScrollAreaAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ConfigList
extends ContainerObjectSelectionList<Entry> {
    private static final ResourceLocation SCROLLER_HANDLE_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/scroller_handle");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/scroller_background");
    private static final ResourceLocation SCROLLER_BACKGROUND_FILLED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"eg_bedrock_books", (String)"config/scroller_background_filled");

    public ConfigList(Minecraft minecraft, int width, int height, int x, int y) {
        super(minecraft, width + 10, height, y, 70);
        this.setPosition(x, y);
    }

    public void addHorizontal(AbstractWidget widget, MultiLineTextWidget label) {
        this.addEntry((AbstractSelectionList.Entry)new HorizontalEntry(widget, label));
    }

    public void addStacked(AbstractWidget widget, MultiLineTextWidget label) {
        this.addEntry((AbstractSelectionList.Entry)new StackedEntry(widget, label));
    }

    public int getRowWidth() {
        return this.width - 16;
    }

    public int getRowLeft() {
        return super.getRowLeft() - 10;
    }

    protected int scrollBarX() {
        return super.scrollBarX() - 3;
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
    }

    protected void renderScrollbar(GuiGraphics graphics, int mouseX, int mouseY) {
        int HANDLE_WIDTH = 14;
        int HANDLE_HEIGHT = 6;
        int BACKGROUND_WIDTH = 6;
        if (this.scrollbarVisible()) {
            int top = this.getY();
            int bottom = this.getBottom();
            int barX = this.scrollBarX();
            double scrollAmount = this.scrollAmount() / (double)this.maxScrollAmount();
            int handleY = (int)((double)(this.getBottom() - top) * scrollAmount);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_BACKGROUND_SPRITE, barX, top, 6, bottom - top);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_BACKGROUND_FILLED_SPRITE, barX, top, 6, handleY);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_HANDLE_SPRITE, barX - 4, handleY + top - 3, 14, 6);
            if (this.isOverScrollbar(mouseX, mouseY)) {
                graphics.requestCursor(((AbstractScrollAreaAccessor)((Object)this)).eg_bedrock_books$isScrolling() ? CursorTypes.RESIZE_NS : CursorTypes.POINTING_HAND);
            }
        }
    }

    protected static class HorizontalEntry
    extends Entry {
        static final int GAP = 4;
        protected final AbstractWidget child;
        protected final MultiLineTextWidget label;

        protected HorizontalEntry(AbstractWidget child, MultiLineTextWidget label) {
            this.child = child;
            this.label = label;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.label, this.child);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.label, this.child);
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int top = this.getContentY();
            int left = this.getContentX();
            int middleY = this.getContentYMiddle();
            int right = this.getContentRight();
            this.label.setY(top);
            this.label.setX(left);
            this.label.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.child.setY(middleY - 8);
            this.child.setX(right - this.child.getWidth() + 4);
            this.child.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public int getHeight() {
            return Math.max(this.child.getHeight(), this.label.getHeight()) + 4;
        }
    }

    protected static class StackedEntry
    extends HorizontalEntry {
        static final int BETWEEN_WIDGET_GAP = 2;

        protected StackedEntry(AbstractWidget child, MultiLineTextWidget label) {
            super(child, label);
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int top = this.getContentY();
            int left = this.getContentX();
            this.label.setY(top);
            this.label.setX(left);
            this.label.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.child.setY(this.label.getBottom() + 2);
            this.child.setX(left);
            this.child.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public int getHeight() {
            return this.child.getHeight() + 2 + this.label.getHeight() + 4;
        }
    }

    protected static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected Entry() {
        }
    }
}

