package games.enchanted.eg_bedrock_books.common.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import games.enchanted.eg_bedrock_books.common.ModConstants;
import games.enchanted.eg_bedrock_books.common.duck.BookSignScreenAdditions;
import net.minecraft.class_10799;
import net.minecraft.class_11385;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value = class_11385.class, priority = 995)
public class BookSignScreenMixin extends class_437 implements BookSignScreenAdditions {
    @Unique
    private static final int eg_bedrock_books$BACKGROUND_WIDTH = 256;
    @Unique
    private static final int eg_bedrock_books$BACKGROUND_HEIGHT = 256;
    @Unique
    private static final class_2960 eg_bedrock_books$BACKGROUND_TEXTURE = class_2960.method_60655(ModConstants.MOD_ID, "textures/gui/book/sign_background.png");

    @Unique
    private static final int eg_bedrock_books$MAIN_TEXT_COLOUR = 0xfffaf3e6;
    @Unique
    private static final int eg_bedrock_books$SECONDARY_TEXT_COLOUR = 0xfff0dbaf;

    @Unique
    private class_437 eg_bedrock_books$returnScreen = null;

    protected BookSignScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public void eg_bedrock_books$setReturnScreen(class_437 screen) {
        this.eg_bedrock_books$returnScreen = screen;
    }

    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"),
        method = "method_71541"
    )
    private void eg_bedrock_books$modifyReturnScreenIfPresent(class_310 instance, class_437 old, Operation<Void> original) {
        if(this.eg_bedrock_books$returnScreen != null) {
            original.call(instance, this.eg_bedrock_books$returnScreen);
            return;
        }
        original.call(instance, old);
    }

    // buttons
    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/Button$Builder;bounds(IIII)Lnet/minecraft/client/gui/components/Button$Builder;"),
        method = "init"
    )
    private class_4185.class_7840 eg_bedrock_books$modifyButtons(class_4185.class_7840 instance, int x, int y, int width, int height, Operation<class_4185.class_7840> original) {
        return original.call(instance, x, (this.field_22790 / 2) + 90, width, height);
    }

    // background
    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;blit(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V"),
        method = "renderBackground"
    )
    private void eg_bedrock_books$modifyBackgroundImage(class_332 instance, RenderPipeline pipeline, class_2960 atlas, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, Operation<Void> original) {
        original.call(
            instance,
            class_10799.field_56883,
            eg_bedrock_books$BACKGROUND_TEXTURE,
            (this.field_22789 / 2) - (eg_bedrock_books$BACKGROUND_WIDTH / 2),
            (this.field_22790 / 2) - (eg_bedrock_books$BACKGROUND_HEIGHT / 2),
            0f,
            0f,
            eg_bedrock_books$BACKGROUND_WIDTH,
            eg_bedrock_books$BACKGROUND_HEIGHT,
            eg_bedrock_books$BACKGROUND_WIDTH,
            eg_bedrock_books$BACKGROUND_HEIGHT
        );
    }

    // title label
    @WrapOperation(
        slice = @Slice(from = @At(value = "FIELD", target = "Lnet/minecraft/client/gui/screens/inventory/BookSignScreen;EDIT_TITLE_LABEL:Lnet/minecraft/network/chat/Component;", opcode = Opcodes.GETSTATIC)),
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V", ordinal = 0),
        method = "render"
    )
    private void eg_bedrock_books$modifyEditTitleLabel(class_332 instance, class_327 font, class_2561 text, int x, int y, int color, boolean drawShadow, Operation<Void> original) {
        int textWidth = font.method_27525(text);
        original.call(
            instance,
            font,
            text,
            (this.field_22789 / 2) - textWidth / 2,
            (this.field_22790 / 2) - 86,
            eg_bedrock_books$MAIN_TEXT_COLOUR,
            drawShadow
        );
    }


    // title box
    @WrapOperation(
        at = @At(value = "NEW", target = "(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/network/chat/Component;)Lnet/minecraft/client/gui/components/EditBox;"),
        method = "init"
    )
    private class_342 eg_bedrock_books$modifyInputPosition(class_327 font, int x, int y, int width, int height, class_2561 message, Operation<class_342> original) {
        return original.call(font, x, (this.field_22790 / 2) - 70, width, height, message);
    }

    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/EditBox;setTextColor(I)V"),
        method = "init"
    )
    private void eg_bedrock_books$modifyInputColour(class_342 instance, int color, Operation<Void> original) {
        original.call(instance, eg_bedrock_books$MAIN_TEXT_COLOUR);
    }

    // owner label
    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;"),
        method = "<init>"
    )
    private class_5250 eg_bedrock_books$modifyOwnerLabelColour(class_5250 instance, class_124 format, Operation<class_5250> original) {
        return original.call(instance, format).method_27696(class_2583.field_24360.method_36139(eg_bedrock_books$SECONDARY_TEXT_COLOUR));
    }

    @WrapOperation(
        slice = @Slice(from = @At(value = "FIELD", target = "Lnet/minecraft/client/gui/screens/inventory/BookSignScreen;ownerText:Lnet/minecraft/network/chat/Component;", opcode = Opcodes.GETFIELD)),
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V", ordinal = 0),
        method = "render"
    )
    private void eg_bedrock_books$modifyOwnerLabel(class_332 instance, class_327 font, class_2561 text, int x, int y, int color, boolean drawShadow, Operation<Void> original) {
        int textWidth = font.method_27525(text);
        original.call(
            instance,
            font,
            text,
            (this.field_22789 / 2) - textWidth / 2,
            (this.field_22790 / 2) - 56,
            -1,
            drawShadow
        );
    }

    // note text
    @WrapOperation(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;drawWordWrap(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/FormattedText;IIIIZ)V"),
        method = "render"
    )
    private void eg_bedrock_books$modifyNoteText(class_332 instance, class_327 font, class_5348 text, int x, int y, int lineWidth, int color, boolean drawShadow, Operation<Void> original) {
        original.call(
            instance,
            font,
            text,
            (this.field_22789 / 2) - lineWidth / 2,
            (this.field_22790 / 2) - 16,
            lineWidth,
            eg_bedrock_books$MAIN_TEXT_COLOUR,
            drawShadow
        );
    }
}
