package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.ModConstants;
import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.config.ConfigScreenBehaviour;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.EditControls;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8667;
import net.minecraft.class_9301;

public abstract class AbstractBedrockBookScreen<PageContent, TextView extends TextAreaView<PageContent>> extends class_437 {
    // book spacing
    protected static final int BACKGROUND_WIDTH = 512;
    protected static final int BACKGROUND_HEIGHT = 256;
    protected static final int PAGE_EDIT_BOX_WIDTH = 122;
    protected static final int PAGE_EDIT_BOX_HEIGHT = 134;
    protected static final int PAGE_TEXT_WIDTH = 114;
    protected static final int PAGE_TEXT_HEIGHT = 128;
    protected static final int CENTER_PADDING = 22;

    // text style
    protected static final int CURSOR_COLOUR = 0xff000000;
    protected static final int TEXT_COLOUR = 0xff000000;
    protected static final int PAGE_INDICATOR_COLOUR = 0xffbca387;
    protected static final boolean TEXT_SHADOW = false;

    // footer button spacing
    protected static final int FOOTER_BUTTON_WIDTH = 90;
    protected static final int FOOTER_BUTTON_SPACING = 8;

    // translations
    protected static final String BOOK_PAGE_INDICATOR = "book.pageIndicator";
    protected static final class_2561 SIGN_BUTTON_COMPONENT = class_2561.method_43471("book.signButton");
    protected static final class_2561 SAVE_BUTTON_COMPONENT = class_2561.method_43471("selectWorld.edit.save");

    // textures
    private static final int TURN_PAGE_BUTTON_SIZE = 24;
    private static final class_2561 PAGE_LEFT_BUTTON_LABEL = class_2561.method_43471("book.page_button.previous");
    private static final CustomSpriteButton.ButtonConfig PAGE_LEFT_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_4758(class_3417.field_17481, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/page_backward"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/page_backward_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/page_backward_focus")
    );
    private static final class_2561 PAGE_RIGHT_BUTTON_LABEL = class_2561.method_43471("book.page_button.next");
    private static final CustomSpriteButton.ButtonConfig PAGE_RIGHT_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_4758(class_3417.field_17481, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/page_forward"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/page_forward_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/page_forward_focus")
    );
    private static final int CLOSE_BUTTON_SIZE = 9;
    private static final class_2561 CLOSE_BUTTON_LABEL = class_5244.field_24334;
    private static final CustomSpriteButton.ButtonConfig CLOSE_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/close"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/close_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/close_focus")
    );

    private static final int CONFIG_BUTTON_SIZE = 24;
    private static final class_2561 CONFIG_BUTTON_LABEL = class_2561.method_43471("ui.eg_bedrock_books.config.title");
    private static final CustomSpriteButton.ButtonConfig CONFIG_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "config_button"),
        class_2960.method_60655(ModConstants.MOD_ID, "config_button_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "config_button_focus")
    );

    // pagination
    protected static final int MAX_PAGES = class_9301.field_51411;

    private int currentLeftPageIndex;
    protected List<PageContent> pages = new ArrayList<>();

    protected CustomSpriteButton turnLeftButton;
    protected CustomSpriteButton turnRightButton;

    protected final boolean canEditAndCreatePages;

    // two visible pages
    protected class_2561 leftPageNumberMessage = class_5244.field_39003;
    protected TextView leftPageTextView;
    @Nullable private EditControls leftPageEditControls = null;

    protected class_2561 rightPageNumberMessage = class_5244.field_39003;
    protected TextView rightPageTextView;
    @Nullable private EditControls rightPageEditControls = null;

    // buttons
    protected class_8667 footerButtonLayout;
    protected CustomSpriteButton configButton;
    protected CustomSpriteButton xButton;

    public AbstractBedrockBookScreen(class_2561 message, boolean editable) {
        super(message);

        this.currentLeftPageIndex = 0;
        this.canEditAndCreatePages = editable;
    }

    @Override
    protected void method_25426() {
        final int editBoxYPos = (this.field_22790 / 2) - PAGE_EDIT_BOX_HEIGHT + 45;
        final int turnPageButtonYPos = (this.field_22790 / 2) + 47;
        final int editControlsYPos = (this.field_22790 / 2) + 44;

        this.xButton = new CustomSpriteButton(
            (this.field_22789 / 2) + (CENTER_PADDING / 2) + 120,
            (this.field_22790 / 2) - PAGE_EDIT_BOX_HEIGHT + 33,
            CLOSE_BUTTON_SIZE,
            CLOSE_BUTTON_SIZE,
            button -> this.method_25419(),
            CLOSE_BUTTON_LABEL,
            CLOSE_BUTTON_CONFIG
        );
        this.method_37063(this.xButton);
        this.xButton.field_22764 = ConfigOptions.SHOW_X_BUTTON.getValue();

        // left page
        TextViewAndWidget<PageContent, TextView> leftPageWidget = createTextWidgetAndView((this.field_22789 / 2) - (CENTER_PADDING / 2) - PAGE_EDIT_BOX_WIDTH, editBoxYPos, PageSide.LEFT);
        this.leftPageTextView = leftPageWidget.view();
        if(leftPageWidget.widget() != null) {
            this.method_37063(leftPageWidget.widget());
            this.method_48265(leftPageWidget.widget());
        }

        if(this.canEditAndCreatePages) {
            this.leftPageEditControls = new EditControls(
                (this.field_22789 / 2) - (CENTER_PADDING / 2) - (PAGE_EDIT_BOX_WIDTH / 2) - 42,
                editControlsYPos,
                new EditControls.Actions(
                    () -> this.handlePageMove(PageMoveDirection.LEFT, this.currentLeftPageIndex),
                    () -> this.handleAddPage(this.currentLeftPageIndex),
                    () -> this.handlePageDelete(this.currentLeftPageIndex),
                    () -> this.handlePageMove(PageMoveDirection.RIGHT, this.currentLeftPageIndex)
                )
            );
            this.leftPageEditControls.method_48206(this::method_37063);
            this.method_37060(this.leftPageEditControls);
        }

        addWidgetsBetweenPages();

        // right page
        TextViewAndWidget<PageContent, TextView> rightPageWidget = createTextWidgetAndView((this.field_22789 / 2) + (CENTER_PADDING / 2), editBoxYPos, PageSide.RIGHT);
        this.rightPageTextView = rightPageWidget.view();
        if(rightPageWidget.widget() != null) {
            this.method_37063(rightPageWidget.widget());
        }

        if(this.canEditAndCreatePages) {
            this.rightPageEditControls = new EditControls(
                (this.field_22789 / 2) - (CENTER_PADDING / 2) + 42,
                editControlsYPos,
                new EditControls.Actions(
                    () -> this.handlePageMove(PageMoveDirection.LEFT, this.currentLeftPageIndex + 1),
                    () -> this.handleAddPage(this.currentLeftPageIndex + 1),
                    () -> this.handlePageDelete(this.currentLeftPageIndex + 1),
                    () -> this.handlePageMove(PageMoveDirection.RIGHT, this.currentLeftPageIndex + 1)
                )
            );
            this.rightPageEditControls.method_48206(this::method_37063);
            this.method_37060(this.rightPageEditControls);
        }

        // navigation buttons
        this.turnLeftButton = new CustomSpriteButton(
            (this.field_22789 / 2) - 147,
            turnPageButtonYPos,
            TURN_PAGE_BUTTON_SIZE,
            TURN_PAGE_BUTTON_SIZE,
            (button) -> this.turnBackPage(),
            PAGE_LEFT_BUTTON_LABEL,
            PAGE_LEFT_BUTTON_CONFIG
        );
        this.method_37063(turnLeftButton);

        this.turnRightButton = new CustomSpriteButton(
            (this.field_22789 / 2) + 123,
            turnPageButtonYPos,
            TURN_PAGE_BUTTON_SIZE,
            TURN_PAGE_BUTTON_SIZE,
            (button) -> this.turnForwardPage(),
            PAGE_RIGHT_BUTTON_LABEL,
            PAGE_RIGHT_BUTTON_CONFIG
        );
        this.method_37063(turnRightButton);

        // footer buttons
        this.footerButtonLayout = class_8667.method_52742().method_52735(FOOTER_BUTTON_SPACING);
        makeFooterButtons();
        this.footerButtonLayout.method_48222();
        this.footerButtonLayout.method_48206(this::method_37063);

        // general setup
        updateVisibleContents();

        this.addConfigButton();
    }

    protected abstract TextViewAndWidget<PageContent, TextView> createTextWidgetAndView(int x, int y, PageSide side);

    protected void addWidgetsBetweenPages() {
    }

    protected void makeFooterButtons() {
    }

    protected void addConfigButton() {
        this.configButton = new CustomSpriteButton(
            4,
            this.field_22790 - CONFIG_BUTTON_SIZE - 4,
            CONFIG_BUTTON_SIZE,
            CONFIG_BUTTON_SIZE,
            (button) -> ConfigScreenBehaviour.openConfigScreen(this),
            CONFIG_BUTTON_LABEL,
            CONFIG_BUTTON_CONFIG
        );
        this.method_37063(configButton);
    }

    protected void updateVisibleContents() {
        this.turnLeftButton.field_22764 = true;
        this.turnRightButton.field_22764 = true;

        if(this.currentLeftPageIndex <= 1) {
            this.turnLeftButton.field_22764 = false;
        }
        if((this.currentLeftPageIndex + 2 >= this.getCurrentAmountOfPages() && !this.canEditAndCreatePages) || this.currentLeftPageIndex + 2 >= MAX_PAGES) {
            this.turnRightButton.field_22764 = false;
        }

        this.leftPageNumberMessage = getPageIndicatorMessage(this.currentLeftPageIndex);
        this.leftPageTextView.setValue(getOrCreatePageIfPossible(this.currentLeftPageIndex), true);

        int rightPageIndex = this.currentLeftPageIndex + 1;
        if(this.getCurrentAmountOfPages() % 2 == 1 && this.currentLeftPageIndex >= this.getCurrentAmountOfPages() - 1) {
            this.rightPageNumberMessage = class_2561.method_43473();
            this.rightPageTextView.setVisibility(false);
            if(this.rightPageEditControls != null) {
                this.rightPageEditControls.setVisibility(false);
            }
        } else {
            this.rightPageNumberMessage = getPageIndicatorMessage(this.currentLeftPageIndex + 1);
            this.rightPageTextView.setVisibility(true);
            this.rightPageTextView.setValue(getPageOrEmpty(rightPageIndex), true);
            if(this.rightPageEditControls != null) {
                this.rightPageEditControls.setVisibility(true);
            }
        }

        if(this.canEditAndCreatePages) {
            if(this.leftPageEditControls != null) {
                this.leftPageEditControls.setMoveBackButtonVisible(this.currentLeftPageIndex > 0);
                this.leftPageEditControls.setMoveForwardButtonVisible(this.currentLeftPageIndex < this.getCurrentAmountOfPages() - 1);
            }

            if(this.rightPageEditControls != null) {
                this.rightPageEditControls.setMoveBackButtonVisible(rightPageIndex > 0);
                this.rightPageEditControls.setMoveForwardButtonVisible(rightPageIndex < this.getCurrentAmountOfPages() - 1);
            }
        }
    }

    protected void ensureEvenPageIndex(int newPageIndex) {
        newPageIndex = Math.max(0, newPageIndex);
        if(newPageIndex % 2 == 1) {
            this.currentLeftPageIndex = newPageIndex - 1;
            return;
        }
        this.currentLeftPageIndex = newPageIndex;
    }

    protected int getCurrentLeftPageIndex() {
        return this.currentLeftPageIndex;
    }

    // page edit controls
    protected void resetEditControls() {
        if(this.canEditAndCreatePages) {
            if(this.leftPageEditControls != null) {
                this.leftPageEditControls.toggleControls(false);
            }
            if(this.rightPageEditControls != null) {
                this.rightPageEditControls.toggleControls(false);
            }
        }
    }

    protected void handlePageMove(PageMoveDirection direction, int index) {
        if(direction == PageMoveDirection.LEFT && index > 0 && index < this.pages.size()) {
            PageContent currentPage = this.pages.get(index);
            PageContent previousPage = this.pages.get(index - 1);
            this.pages.set(index, previousPage);
            this.pages.set(index - 1, currentPage);
        } else if(index < this.pages.size() - 1) {
            PageContent currentPage = this.pages.get(index);
            PageContent nextPage = this.pages.get(index + 1);
            this.pages.set(index, nextPage);
            this.pages.set(index + 1, currentPage);
        }
        updateVisibleContents();
    }

    protected abstract PageContent getEmptyPageContent();

    protected void handleAddPage(int index) {
        this.addPage(this.getEmptyPageContent(), index);
        updateVisibleContents();
    }

    protected void handlePageDelete(int index) {
        if(index >= this.pages.size()) return;
        this.pages.remove(index);
        updateVisibleContents();
    }

    // page adding / editing
    protected void addPage(PageContent contents) {
        if(!this.canEditAndCreatePages) return;
        addPage(contents, this.pages.size());
    }

    protected void addPage(PageContent contents, int index) {
        if(!this.canEditAndCreatePages) return;
        if(this.pages.size() >= MAX_PAGES) return;
        this.pages.add(index, contents);
    }

    protected PageContent getOrCreatePageIfPossible(int index) {
        if(index > this.pages.size() - 1) {
            if(!this.canEditAndCreatePages) return this.getEmptyPageContent();
            addPage(this.getEmptyPageContent());
            updateVisibleContents();
        }
        return this.pages.get(index);
    }

    protected PageContent getPageOrEmpty(int index) {
        if(index > this.pages.size() - 1) {
            return this.getEmptyPageContent();
        }
        return this.pages.get(index);
    }

    protected void setPageContent(PageContent contents, int index) {
        if(index > this.pages.size() - 1) {
            this.addPage(contents);
            return;
        }
        this.pages.set(index, contents);
    }

    // page viewing
    protected void turnForwardPage() {
        if(this.currentLeftPageIndex + 2 >= MAX_PAGES) return;
        if(this.currentLeftPageIndex + 3 >= this.getCurrentAmountOfPages() && this.canEditAndCreatePages) {
            // at the end of the book and can create pages
            if(this.getCurrentAmountOfPages() % 2 == 0) {
                // even amount of pages, add two new
                addPage(this.getEmptyPageContent());
                addPage(this.getEmptyPageContent());
            }
            else if(this.currentLeftPageIndex + 1 == this.getCurrentAmountOfPages()) {
                // started on odd amount of pages, add 1 for prev double page, 2 new
                addPage(this.getEmptyPageContent());
                addPage(this.getEmptyPageContent());
                addPage(this.getEmptyPageContent());
            }
            else if(this.getCurrentAmountOfPages() % 2 == 1) {
                // turned onto a double page with 1 page, add 1 to even it out
                addPage(this.getEmptyPageContent());
            }
        }
        ensureEvenPageIndex(this.currentLeftPageIndex + 2);
        resetEditControls();
        updateVisibleContents();
    }

    protected void turnBackPage() {
        ensureEvenPageIndex(Math.max(this.currentLeftPageIndex - 2, 0));
        resetEditControls();
        updateVisibleContents();
    }

    protected int getCurrentAmountOfPages() {
        return this.pages.size();
    }

    protected class_2561 getPageIndicatorMessage(int index) {
        int offsetIndex = index + 1;
        if(offsetIndex > this.getCurrentAmountOfPages()) return class_5244.field_39003;
        return class_2561.method_43469(BOOK_PAGE_INDICATOR, offsetIndex, this.getCurrentAmountOfPages());
    }

    // general visuals and accessibility
    @Override
    public boolean method_25404(
        //? if minecraft: >= 1.21.9 {
        class_11908 keyEvent
        //?} else {
        /*int keyCode, int scanCode, int modifiers
         *///?}
    ) {
        assert this.field_22787 != null;
        //? if minecraft: >= 1.21.9 {
        int keyCode = keyEvent.comp_4795();
        class_11907 inputWithModifiers = new class_11910(class_3675.field_32000, 0);
        //?}
        if (keyCode == ConfigOptions.MOVE_BACKWARD_PAGE_KEY.getPendingOrCurrentValue().method_1444() && this.turnLeftButton.field_22764) {
            this.turnLeftButton.method_25306(
                //? if minecraft: >= 1.21.9 {
                inputWithModifiers
                //?}
            );
            this.turnLeftButton.method_25354(this.field_22787.method_1483());
            return true;
        } else if (keyCode == ConfigOptions.MOVE_FORWARD_PAGE_KEY.getPendingOrCurrentValue().method_1444() && this.turnRightButton.field_22764) {
            this.turnRightButton.method_25306(
                //? if minecraft: >= 1.21.9 {
                inputWithModifiers
                //?}
            );
            this.turnLeftButton.method_25354(this.field_22787.method_1483());
            return true;
        }
        //? if minecraft: >= 1.21.9 {
        return super.method_25404(keyEvent);
        //?} else {
        /*return super.keyPressed(keyCode, scanCode, modifiers);
         *///?}
    }

    @Override
    public @NotNull class_2561 method_25435() {
        return class_5244.method_37111(super.method_25435(), this.getPageIndicatorMessage(this.currentLeftPageIndex));
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);

        final int pageNumberYPos = (this.field_22790 / 2) - PAGE_EDIT_BOX_HEIGHT + 35;

        final int leftPageNumberWidth = this.field_22793.method_27525(this.leftPageNumberMessage);
        guiGraphics.method_51439(
            this.field_22793,
            this.leftPageNumberMessage,
            (this.field_22789 / 2) - (CENTER_PADDING / 2) - (PAGE_EDIT_BOX_WIDTH / 2) - (leftPageNumberWidth / 2),
            pageNumberYPos,
            PAGE_INDICATOR_COLOUR,
            false
        );

        final int rightPageNumberWidth = this.field_22793.method_27525(this.rightPageNumberMessage);
        guiGraphics.method_51439(
            this.field_22793,
            this.rightPageNumberMessage,
            (this.field_22789 / 2) + (CENTER_PADDING / 2) + (PAGE_EDIT_BOX_WIDTH / 2) - (rightPageNumberWidth / 2),
            pageNumberYPos,
            PAGE_INDICATOR_COLOUR,
            false
        );

        if(InputUtil.shouldShowDebugVariables()) {
            guiGraphics.method_25303(field_22793, "leftPageIndex: " + this.getCurrentLeftPageIndex(), 0, 56, -1);
        }
    }

    protected abstract class_2960 getBackgroundTexture();

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderMinecraftBackgrounds(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25290(
            class_10799.field_56883,
            getBackgroundTexture(),
            (this.field_22789 / 2) - (BACKGROUND_WIDTH / 2),
            (this.field_22790 / 2) - (BACKGROUND_HEIGHT / 2),
            0f,
            0f,
            BACKGROUND_WIDTH,
            BACKGROUND_HEIGHT,
            BACKGROUND_WIDTH,
            BACKGROUND_HEIGHT
        );
    }

    protected void renderMinecraftBackgrounds(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22787 != null && this.field_22787.field_1687 == null) {
            this.method_57728(guiGraphics, partialTick);
            this.method_57734(guiGraphics);
            this.method_57735(guiGraphics);
        } else {
            this.method_52752(guiGraphics);
        }
    }

    public enum PageMoveDirection {
        LEFT,
        RIGHT;
    }
    public enum PageSide {
        LEFT,
        RIGHT;
    }
    public record TextViewAndWidget<Value, TextView extends TextAreaView<Value>>(TextView view, @Nullable class_339 widget) {
    }
}
