package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.ModConstants;
import games.enchanted.eg_bedrock_books.common.duck.BookSignScreenAdditions;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.MultilineEditBoxView;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import java.util.ListIterator;
import java.util.Optional;
import net.minecraft.class_11385;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2820;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_634;
import net.minecraft.class_7529;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9334;

public class BedrockBookEditScreen extends AbstractBedrockBookScreen<String, TextAreaView<String>> {
    protected static final class_2561 BOOK_EDIT_TITLE = class_2561.method_43471("book.edit.title");
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655(ModConstants.MOD_ID, "textures/gui/book/edit_background.png");

    // player and item
    protected final class_1657 owner;
    protected final class_1799 bookStack;
    protected final class_1268 hand;
    protected final class_11385 bookSignScreen;

    public BedrockBookEditScreen(class_1657 owner, class_1799 book, class_1268 hand, class_9301 writableBookContent) {
        super(BOOK_EDIT_TITLE, true);

        writableBookContent.method_57517(class_310.method_1551().method_33883()).forEach(this.pages::add);
        if(this.pages.isEmpty()) {
            addPage("");
            addPage("");
        } else if (this.pages.size() == 1) {
            addPage("");
        }

        this.owner = owner;
        this.bookStack = book;
        this.hand = hand;

        this.bookSignScreen = new class_11385(null, owner, hand, this.pages);
        ((BookSignScreenAdditions) this.bookSignScreen).eg_bedrock_books$setReturnScreen(this);
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.method_52736(class_4185.method_46430(class_5244.field_24335, button -> {
            assert this.field_22787 != null;
            this.field_22787.method_1507(null);
        }).method_46432(FOOTER_BUTTON_WIDTH).method_46431());
        this.footerButtonLayout.method_52736(class_4185.method_46430(SIGN_BUTTON_COMPONENT, button -> {
            assert this.field_22787 != null;
            this.field_22787.method_1507(this.bookSignScreen);
        }).method_46432(FOOTER_BUTTON_WIDTH).method_46431());
        this.footerButtonLayout.method_52736(class_4185.method_46430(SAVE_BUTTON_COMPONENT, button -> {
            this.method_25419();
        }).method_46432(FOOTER_BUTTON_WIDTH).method_46431());
        this.footerButtonLayout.method_48229((this.field_22789 / 2) - (FOOTER_BUTTON_WIDTH * 3 + FOOTER_BUTTON_SPACING * 2) / 2, (this.field_22790 / 2) + 90);
    }

    @Override
    protected TextViewAndWidget<String, TextAreaView<String>> createTextWidgetAndView(int x, int y, PageSide side) {
        class_7529 editBox = class_7529.method_71507()
            .method_71514(TEXT_COLOUR)
            .method_71516(CURSOR_COLOUR)
            .method_71515(false)
            .method_71513(false)
            .method_71511(TEXT_SHADOW)
            .method_71508(x)
            .method_71512(y)
            .method_71509(this.field_22793, PAGE_EDIT_BOX_WIDTH, PAGE_EDIT_BOX_HEIGHT, class_5244.field_39003);
        editBox.method_44402(1024);
        editBox.method_71506(126 / this.field_22793.field_2000);
        editBox.method_44401(newValue -> setPageContent(newValue, this.getCurrentLeftPageIndex() + (side == PageSide.RIGHT ? 1 : 0)));

        return new TextViewAndWidget<>(new MultilineEditBoxView(editBox), editBox);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        this.savePagesToStack();
    }

    @Override
    protected String getEmptyPageContent() {
        return "";
    }

    protected void savePagesToStack() {
        this.removeTrailingEmptyPages();
        this.updateLocalStack();
        int slotId = this.hand == class_1268.field_5808 ? this.owner.method_31548().method_67532() : class_1661.field_30639;
        assert this.field_22787 != null;
        class_634 clientConnection = this.field_22787.method_1562();
        if(clientConnection != null) {
            clientConnection.method_52787(new class_2820(slotId, this.pages, Optional.empty()));
        }
    }
    private void removeTrailingEmptyPages() {
        ListIterator<String> pageIterator = this.pages.listIterator(this.pages.size());
        while (pageIterator.hasPrevious() && pageIterator.previous().isEmpty()) {
            pageIterator.remove();
        }
    }
    private void updateLocalStack() {
        this.bookStack.method_57379(class_9334.field_49653, new class_9301(this.pages.stream().map(class_9262::method_57137).toList()));
    }

    @Override
    protected class_2960 getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }
}
