package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.ModConstants;
import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.ComponentTextAreaView;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_11909;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3872;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5481;

public class BedrockBookViewScreen extends AbstractBedrockBookScreen<class_2561, TextAreaView<class_2561>> {
    protected static final class_2561 BOOK_VIEW_TITLE = class_2561.method_43471("book.view.title");
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655(ModConstants.MOD_ID, "textures/gui/book/view_background.png");;

    protected static final int FOOTER_BUTTON_WIDTH = 200;
    protected static final int TEXT_OFFSET_LEFT = 4;
    protected static final int TEXT_OFFSET_RIGHT = 4;
    protected static final int TEXT_OFFSET_TOP = 10;

    protected static final int PAGE_CLICK_BOUNDS_EXTRA_PADDING = 2;

    protected int leftPageX = 0;
    protected int leftPageY = 0;
    protected List<class_5481> leftPageSplitLines = List.of();
    protected int rightPageX = 0;
    protected int rightPageY = 0;
    protected List<class_5481> rightPageSplitLines = List.of();

    protected double mouseX = 0;
    protected double mouseY = 0;

    @Nullable protected class_2583 styleUnderMouseCursor = null;

    public BedrockBookViewScreen(class_3872.class_3931 bookAccess) {
        super(BOOK_VIEW_TITLE, false);

        this.pages = bookAccess.comp_2438();
    }

    public BedrockBookViewScreen() {
        this(class_3872.field_17417);
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.method_52736(class_4185.method_46430(class_5244.field_24334, button -> {
            this.method_25419();
        }).method_46432(FOOTER_BUTTON_WIDTH).method_46431());
        this.footerButtonLayout.method_48229((this.field_22789 / 2) - FOOTER_BUTTON_WIDTH / 2, (this.field_22790 / 2) + 90);
    }

    @Override
    protected TextViewAndWidget<class_2561, TextAreaView<class_2561>> createTextWidgetAndView(int x, int y, PageSide side) {
        if(side == PageSide.LEFT) {
            this.leftPageX = x + 8 - getHorizontalLeftPageTextOffset();
            this.leftPageY = y + getVerticalTextOffset();
        } else {
            this.rightPageX = x + getHorizontalRightPageTextOffset();
            this.rightPageY = y + getVerticalTextOffset();
        }

        return new TextViewAndWidget<>(new ComponentTextAreaView(component -> {
            int offsetIndex = this.getCurrentLeftPageIndex() + (side == PageSide.LEFT ? 0 : 1);
            if(side == PageSide.LEFT) {
                this.leftPageSplitLines = this.splitPage(offsetIndex);
            } else {
                this.rightPageSplitLines = this.splitPage(offsetIndex);
            }
        }), null);
    }

    protected int getHorizontalLeftPageTextOffset() {
        return TEXT_OFFSET_LEFT;
    }
    protected int getHorizontalRightPageTextOffset() {
        return TEXT_OFFSET_RIGHT;
    }
    protected int getVerticalTextOffset() {
        return TEXT_OFFSET_TOP;
    }

    protected List<class_5481> splitPage(int index) {
        return this.field_22793.method_1728(this.getPageOrEmpty(index), PAGE_TEXT_WIDTH);
    }

    @Override
    protected class_2561 getEmptyPageContent() {
        return class_5244.field_39003;
    }

    @Override
    protected void turnForwardPage() {
        super.turnForwardPage();
        refreshStyleUnderMouse();
    }

    @Override
    protected void turnBackPage() {
        super.turnBackPage();
        refreshStyleUnderMouse();
    }

    @Override
    public boolean method_25402(
        //? if minecraft: >= 1.21.9 {
        class_11909 mouseButtonEvent, boolean doubleClick
        //?} else {
        /*double mouseX, double mouseY, int button
         *///?}
    ) {
        class_2583 clickedStyle = getStyleAt(mouseX, mouseY, null);
        //? if minecraft: >= 1.21.9 {
        int button = mouseButtonEvent.method_74245();
        //?}

        if (button == class_3675.field_32000 && clickedStyle != null && method_25430(clickedStyle)) return true;

        //? if minecraft: >= 1.21.9 {
        return super.method_25402(mouseButtonEvent, doubleClick);
        //?} else {
        /*return super.mouseClicked(mouseX, mouseY, button);
        *///?}
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        refreshStyleUnderMouse();
    }

    protected void refreshStyleUnderMouse() {
        this.styleUnderMouseCursor = getStyleAt(this.mouseX, this.mouseY, null);
    }

    @Nullable
    public class_2583 getStyleAt(double x, double y, @Nullable class_332 guiGraphics) {
        if (this.leftPageSplitLines.isEmpty() && this.rightPageSplitLines.isEmpty()) {
            return null;
        }

        boolean closestToLeftHorizontally = (x < this.leftPageX + PAGE_TEXT_WIDTH + PAGE_CLICK_BOUNDS_EXTRA_PADDING);

        int closestPageX = closestToLeftHorizontally ? this.leftPageX : this.rightPageX;
        int closestPageY = closestToLeftHorizontally ? this.leftPageY : this.rightPageY;

        // not within a page bounds
        if(x < closestPageX - PAGE_CLICK_BOUNDS_EXTRA_PADDING || x > closestPageX + PAGE_CLICK_BOUNDS_EXTRA_PADDING + PAGE_TEXT_WIDTH) return null;
        if(y < closestPageY - PAGE_CLICK_BOUNDS_EXTRA_PADDING || y > closestPageY + PAGE_CLICK_BOUNDS_EXTRA_PADDING + PAGE_TEXT_HEIGHT) return null;

        int clampedRelativeX = (int) Math.clamp(x - closestPageX, 0, closestPageX + PAGE_TEXT_WIDTH);
        int clampedRelativeY = (int) Math.clamp(y - closestPageY, 0, closestPageY + PAGE_TEXT_HEIGHT);

        if(guiGraphics != null && InputUtil.shouldShowDebugTextBound()) {
            drawXY(closestToLeftHorizontally ? 0 : 1, closestToLeftHorizontally ? 0 : 1, 0, guiGraphics);
            drawXY(closestPageX, closestPageY, 8, guiGraphics);
            drawXY(clampedRelativeX, clampedRelativeY, 16, guiGraphics);
        }

        class_310 minecraft = class_310.method_1551();
        int lineIndex = clampedRelativeY / minecraft.field_1772.field_2000;
        if (lineIndex >= 0 && lineIndex < (closestToLeftHorizontally ? this.leftPageSplitLines.size() : this.rightPageSplitLines.size())) {
            class_5481 line = (closestToLeftHorizontally ? this.leftPageSplitLines : this.rightPageSplitLines).get(lineIndex);
            return minecraft.field_1772.method_27527().method_30876(line, clampedRelativeX);
        }

        return null;
    }

    @Override
    protected void method_71846(class_310 minecraft, class_2558 clickEvent) {
        switch (clickEvent) {
            case ClickEvent.RunCommand(String string):
                if(ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getValue()) {
                    closeServerContainer();
                }
                if(minecraft.player != null) {
                    clickCommandAction(minecraft.player, string, ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getValue() ? null : this);
                }
                break;
            case ClickEvent.ChangePage(int i):
                setPageIndex(i - 1);
                break;
            default:
                defaultHandleGameClickEvent(clickEvent, minecraft, this);
        }
    }

    protected void closeServerContainer() {
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);

        int leftLines = Math.min(PAGE_TEXT_HEIGHT / this.field_22793.field_2000, this.leftPageSplitLines.size());
        for (int i = 0; i < leftLines; ++i) {
            guiGraphics.method_51430(
                this.field_22793,
                this.leftPageSplitLines.get(i),
                this.leftPageX,
                this.leftPageY + i * this.field_22793.field_2000,
                TEXT_COLOUR,
                TEXT_SHADOW
            );
        }

        int rightLines = Math.min(PAGE_TEXT_HEIGHT / this.field_22793.field_2000, this.rightPageSplitLines.size());
        for (int i = 0; i < rightLines; ++i) {
            guiGraphics.method_51430(
                this.field_22793,
                this.rightPageSplitLines.get(i),
                this.rightPageX,
                this.rightPageY + i * this.field_22793.field_2000,
                TEXT_COLOUR,
                TEXT_SHADOW
            );
        }

        guiGraphics.method_51441(this.field_22793, this.styleUnderMouseCursor, mouseX, mouseY);

        if(InputUtil.shouldShowDebugTextBound()) {
            guiGraphics.method_25296(this.leftPageX - PAGE_CLICK_BOUNDS_EXTRA_PADDING, this.leftPageY - PAGE_CLICK_BOUNDS_EXTRA_PADDING, this.leftPageX + PAGE_TEXT_WIDTH + PAGE_CLICK_BOUNDS_EXTRA_PADDING, this.leftPageY + PAGE_TEXT_HEIGHT + PAGE_CLICK_BOUNDS_EXTRA_PADDING, 0x22000000, 0x22000000);
            guiGraphics.method_25296(this.rightPageX - PAGE_CLICK_BOUNDS_EXTRA_PADDING, this.rightPageY - PAGE_CLICK_BOUNDS_EXTRA_PADDING, this.rightPageX + PAGE_TEXT_WIDTH + PAGE_CLICK_BOUNDS_EXTRA_PADDING, this.rightPageY + PAGE_TEXT_HEIGHT + PAGE_CLICK_BOUNDS_EXTRA_PADDING, 0x22000000, 0x22000000);
        }
        if(InputUtil.shouldShowDebugVariables()) {
            guiGraphics.method_25303(this.field_22793, "style under cursor: ", 0, this.field_22790 - this.field_22793.field_2000 * 2, -1);
            guiGraphics.method_25303(this.field_22793, this.styleUnderMouseCursor == null ? "<none>" : this.styleUnderMouseCursor.toString(), 0, this.field_22790 - this.field_22793.field_2000, -1);
        }
    }

    @Override
    protected class_2960 getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }

    protected void setBookAccess(class_3872.class_3931 bookAccess) {
        this.pages = bookAccess.comp_2438();
        ensureEvenPageIndex(Math.clamp(this.getCurrentLeftPageIndex(), 0, Math.max(0, bookAccess.method_17560() - 1)));
        updateVisibleContents();
    }

    protected void setPageIndex(int index) {
        ensureEvenPageIndex(Math.clamp(index, 0, Math.max(0, getCurrentAmountOfPages() - 1)));
        updateVisibleContents();
    }

    private void drawXY(int x, int y, int yoffset, class_332 guiGraphics) {
        String string = String.format(Locale.ROOT, "%s, %s", x, y);
        guiGraphics.method_25303(field_22793, string, 0, 0 + yoffset, -1);
    }
}
