package games.enchanted.eg_bedrock_books.common.screen.config;

import games.enchanted.eg_bedrock_books.common.ModConstants;
import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.AbstractBedrockBookScreen;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.KeyBox;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.DummyTextAreaView;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ConfigScreenBehaviour extends AbstractBedrockBookScreen<String, TextAreaView<String>> {
    protected static final class_2561 CONFIG_TITLE = class_2561.method_43471("ui.eg_bedrock_books.config.title");
    protected static final class_2561 RESET_BUTTON_COMPONENT = class_2561.method_43471("ui.eg_bedrock_books.config.reset");
    protected static final class_2561 RESET_TITLE_COMPONENT = class_2561.method_43471("ui.eg_bedrock_books.config.reset.title").method_27696(class_2583.field_24360.method_10982(true));
    protected static final class_2561 RESET_MESSAGE_COMPONENT = class_2561.method_43471("ui.eg_bedrock_books.config.reset.warning");
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655(ModConstants.MOD_ID, "textures/gui/book/config_background.png");

    protected final @Nullable class_437 returnScreen;
    protected final boolean alwaysBlurBackground;

    protected ConfigScreenBehaviour(@Nullable class_437 returnScreen, boolean alwaysBlurBackground) {
        super(CONFIG_TITLE, false);
        this.returnScreen = returnScreen;
        this.alwaysBlurBackground = alwaysBlurBackground;

        this.pages = List.of(getEmptyPageContent(), getEmptyPageContent(), getEmptyPageContent());
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.method_52736(
            class_4185.method_46430(class_5244.field_24335, button -> this.cancelAndClose())
                .method_46432(FOOTER_BUTTON_WIDTH)
            .method_46431()
        );
        this.footerButtonLayout.method_52736(
            class_4185.method_46430(RESET_BUTTON_COMPONENT, button -> this.resetWithConfirmation())
                .method_46432(FOOTER_BUTTON_WIDTH)
            .method_46431()
        );
        this.footerButtonLayout.method_52736(
            class_4185.method_46430(SAVE_BUTTON_COMPONENT, button -> this.saveAndClose())
                .method_46432(FOOTER_BUTTON_WIDTH)
            .method_46431()
        );
        this.footerButtonLayout.method_48229((this.field_22789 / 2) - (FOOTER_BUTTON_WIDTH * 3 + FOOTER_BUTTON_SPACING * 2) / 2, (this.field_22790 / 2) + 90);
    }

    protected void cancelAndClose() {
        ConfigOptions.clearAllPendingValues();
        this.method_25419();
    }

    protected void saveAndClose() {
        ConfigOptions.saveIfAnyDirtyOptions();
        this.method_25419();
    }

    protected void resetWithConfirmation() {
        class_410 confirmScreen = new class_410(confirmed -> {
            class_310.method_1551().method_1507(this);
            if(!confirmed) {
                return;
            }
            ConfigOptions.resetAndSaveAllOptions();
            this.method_25419();
        }, RESET_TITLE_COMPONENT, RESET_MESSAGE_COMPONENT);
        class_310.method_1551().method_1507(confirmScreen);
    }

    @Override
    public void method_25419() {
        if(this.field_22787 != null && this.returnScreen != null) {
            this.field_22787.method_1507(returnScreen);
        }
    }

    @Override
    protected void addConfigButton() {
    }

    @Override
    protected TextViewAndWidget<String, TextAreaView<String>> createTextWidgetAndView(int x, int y, PageSide side) {
        return new TextViewAndWidget<>(new DummyTextAreaView(), null);
    }

    @Override
    protected String getEmptyPageContent() {
        return "";
    }

    @Override
    public @NotNull class_2561 method_25435() {
        return CONFIG_TITLE;
    }

    @Override
    public boolean method_25422() {
        if(this.method_25399() instanceof KeyBox keyBox && keyBox.isListeningForInput()) {
            return false;
        }
        return super.method_25422();
    }

    @Override
    protected class_2960 getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }

    @Override
    protected void renderMinecraftBackgrounds(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if(!this.alwaysBlurBackground) {
            super.renderMinecraftBackgrounds(guiGraphics, mouseX, mouseY, partialTick);
            return;
        }
        if (this.field_22787 != null && this.field_22787.field_1687 == null) {
            this.method_57728(guiGraphics, partialTick);
        }
        this.method_57734(guiGraphics);
        this.method_57735(guiGraphics);
    }

    public static class_437 makeScreenForModMenu(@Nullable class_437 returnScreen) {
        return new ConfigScreenVisual(returnScreen, true);
    }

    public static class_437 makeScreen(@Nullable class_437 returnScreen) {
        return new ConfigScreenVisual(returnScreen);
    }

    public static void openConfigScreen(@Nullable class_437 returnScreen) {
        class_310.method_1551().method_1507(makeScreen(returnScreen));
    }
}
