package games.enchanted.eg_bedrock_books.common.screen.config;

import games.enchanted.eg_bedrock_books.common.ModConstants;
import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.config.option.ConfigOption;
import games.enchanted.eg_bedrock_books.common.screen.BedrockLecternScreen;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.CheckBox;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.IntegerSlider;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.KeyBox;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_7940;

public class ConfigScreenVisual extends ConfigScreenBehaviour {
    protected static final int MAX_LAYOUT_WIDTH = 120;
    protected static final int MAX_LAYOUT_HEIGHT = 140;
    protected static final int CENTER_PADDING = 24;
    protected static final int COLUMN_GAP = 4;
    protected static final int ROW_GAP = 5;

    protected static final int PAGE_TEXT_COLOUR = 0xff987457;

    public static final CustomSpriteButton.ButtonConfig CHECKBOX_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "config/checkbox_unchecked"),
        class_2960.method_60655(ModConstants.MOD_ID, "config/checkbox_unchecked_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "config/checkbox_unchecked_focus")
    );
    public static final CustomSpriteButton.ButtonConfig CHECKBOX_UNCHECKED_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "config/checkbox_checked"),
        class_2960.method_60655(ModConstants.MOD_ID, "config/checkbox_checked_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "config/checkbox_checked_focus")
    );

    public static class_2960 SLIDER_BACKGROUND_SPRITE = class_2960.method_60655(ModConstants.MOD_ID, "config/slider_background");
    public static final CustomSpriteButton.ButtonConfig SLIDER_HANDLE_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "config/slider_handle"),
        class_2960.method_60655(ModConstants.MOD_ID, "config/slider_handle_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "config/slider_handle_focus")
    );

    protected static final List<ConfigOption<Boolean>> DEBUG_OPTIONS = List.of(
        ConfigOptions.DEBUG_WIDGET_BOUNDS,
        ConfigOptions.DEBUG_TEXT_BOUNDS,
        ConfigOptions.DEBUG_CONTAINER_DATA,
        ConfigOptions.DEBUG_VARIABLES
    );

    protected ConfigScreenVisual(@Nullable class_437 returnScreen, boolean alwaysBlurBackground) {
        super(returnScreen, alwaysBlurBackground);
    }

    protected ConfigScreenVisual(@Nullable class_437 returnScreen) {
        super(returnScreen, false);
    }

    protected class_7845 generalGridLayout;
    protected class_7845 visualGridLayout;
    protected class_7845 debugGridLayout;

    @Override
    protected void addWidgetsBetweenPages() {
        super.addWidgetsBetweenPages();

        this.generalGridLayout = createPageLayout(PageSide.LEFT);
        this.visualGridLayout = createPageLayout(PageSide.RIGHT);
        this.debugGridLayout = createPageLayout(PageSide.LEFT);

        // general
        final class_2561 closeOnCommandRun = translatableComponentForPage("ui.eg_bedrock_books.config.option.close_when_running_command");
        final CheckBox closeOnCommandRunWidget = new CheckBox(
            0,
            0,
            ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getPendingOrCurrentValue(),
            ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND::setPendingValue,
            closeOnCommandRun,
            CHECKBOX_CONFIG,
            CHECKBOX_UNCHECKED_CONFIG
        );
        closeOnCommandRunWidget.method_47400(class_7919.method_47407(class_2561.method_43471("ui.eg_bedrock_books.config.option.close_when_running_command.tooltip")));
        addLabeledOptionToLayout(
            closeOnCommandRunWidget,
            closeOnCommandRun,
            this.generalGridLayout,
            0,
            1
        );

        final class_2561 turnForwardPageLabel = translatableComponentForPage("ui.eg_bedrock_books.config.key.turn_forward_page");
        addLabeledOptionToLayout(
            new KeyBox(
                0,
                0,
                ConfigOptions.MOVE_FORWARD_PAGE_KEY.getPendingOrCurrentValue(),
                ConfigOptions.MOVE_FORWARD_PAGE_KEY::setPendingValue,
                turnForwardPageLabel
            ),
            turnForwardPageLabel,
            this.generalGridLayout,
            1,
            1
        );

        final class_2561 turnBackwardPageLabel = translatableComponentForPage("ui.eg_bedrock_books.config.key.turn_backward_page");
        addLabeledOptionToLayout(
            new KeyBox(
                0,
                0,
                ConfigOptions.MOVE_BACKWARD_PAGE_KEY.getPendingOrCurrentValue(),
                ConfigOptions.MOVE_BACKWARD_PAGE_KEY::setPendingValue,
                turnBackwardPageLabel
            ),
            turnBackwardPageLabel,
            this.generalGridLayout,
            2,
            1
        );


        final class_2561 vanillaScreenKeybindEnabledLabel = translatableComponentForPage("ui.eg_bedrock_books.config.option.open_vanilla_screen_key");
        final class_7919 vanillaScreenKeyTooltip = class_7919.method_47407(class_2561.method_43471("ui.eg_bedrock_books.config.key.open_vanilla_screen_key.tooltip"));
        final CheckBox vanillaScreenKeyEnabledWidget = new CheckBox(
            0,
            0,
            ConfigOptions.VANILLA_BOOK_KEY_ENABLED.getPendingOrCurrentValue(),
            ConfigOptions.VANILLA_BOOK_KEY_ENABLED::setPendingValue,
            vanillaScreenKeybindEnabledLabel,
            CHECKBOX_CONFIG,
            CHECKBOX_UNCHECKED_CONFIG
        );
        vanillaScreenKeyEnabledWidget.method_47400(vanillaScreenKeyTooltip);
        addLabeledOptionToLayout(
            vanillaScreenKeyEnabledWidget,
            vanillaScreenKeybindEnabledLabel,
            this.generalGridLayout,
            3,
            1
        );

        final class_2561 vanillaScreenKeyLabel = translatableComponentForPage("ui.eg_bedrock_books.config.key.open_vanilla_screen_key");
        final KeyBox vanillaScreenKeyInput = new KeyBox(
            0,
            0,
            ConfigOptions.VANILLA_BOOK_KEY.getPendingOrCurrentValue(),
            ConfigOptions.VANILLA_BOOK_KEY::setPendingValue,
            vanillaScreenKeyLabel
        );
        vanillaScreenKeyInput.method_47400(vanillaScreenKeyTooltip);
        addLabeledOptionToLayout(
            vanillaScreenKeyInput,
            vanillaScreenKeyLabel,
            this.generalGridLayout,
            4,
            1
        );

        // visual
        final class_2561 showXButtonLabel = translatableComponentForPage("ui.eg_bedrock_books.config.option.show_x_button");
        addLabeledOptionToLayout(
            new CheckBox(
                0,
                0,
                ConfigOptions.SHOW_X_BUTTON.getPendingOrCurrentValue(),
                value -> {
                    ConfigOptions.SHOW_X_BUTTON.setPendingValue(value);
                    this.xButton.field_22764 = value;
                },
                showXButtonLabel,
                CHECKBOX_CONFIG,
                CHECKBOX_UNCHECKED_CONFIG
            ),
            showXButtonLabel,
            this.visualGridLayout,
            0,
            1
        );

        final class_2561 ribbonHeightLabel = translatableComponentForPage("ui.eg_bedrock_books.config.option.ribbon_height");
        addStackedLabeledOptionToLayout(
            new IntegerSlider(
                0,
                0,
                MAX_LAYOUT_WIDTH,
                16,
                ribbonHeightLabel,
                ConfigOptions.RIBBON_HEIGHT.getPendingOrCurrentValue(),
                ConfigOptions.RIBBON_HEIGHT::setPendingValue,
                0,
                130,
                SLIDER_BACKGROUND_SPRITE,
                SLIDER_HANDLE_CONFIG
            ),
            ribbonHeightLabel,
            this.visualGridLayout,
            1,
            1
        );

        // debug
        for (int i = 0; i < DEBUG_OPTIONS.size(); i++) {
            ConfigOption<Boolean> option = DEBUG_OPTIONS.get(i);
            final class_2561 optionLabel = literalComponentForPage(option.getJsonKey());
            addLabeledOptionToLayout(
                new CheckBox(
                    0,
                    0,
                    option.getPendingOrCurrentValue(),
                    option::setPendingValue,
                    optionLabel,
                    CHECKBOX_CONFIG,
                    CHECKBOX_UNCHECKED_CONFIG
                ),
                optionLabel,
                this.debugGridLayout,
                i,
                1
            );
        }

        this.generalGridLayout.method_48222();
        this.visualGridLayout.method_48222();
        this.debugGridLayout.method_48222();
    }

    protected class_2561 translatableComponentForPage(String translationKey) {
        return class_2561.method_43471(translationKey).method_27696(class_2583.field_24360.method_36139(PAGE_TEXT_COLOUR).method_65302(0));
    }

    protected class_2561 literalComponentForPage(String literal) {
        return class_2561.method_43470(literal).method_27696(class_2583.field_24360.method_36139(PAGE_TEXT_COLOUR).method_65302(0));
    }

    protected class_7845 createPageLayout(PageSide side) {
        int x = side == PageSide.LEFT ? (this.field_22789 / 2) - (CENTER_PADDING / 2) - MAX_LAYOUT_WIDTH : (this.field_22789 / 2) + (CENTER_PADDING / 2) + 4;
        int y = (this.field_22790 / 2) - MAX_LAYOUT_HEIGHT + 55;

        class_7845 layout = new class_7845(x, y);
        layout.method_48635(COLUMN_GAP);
        layout.method_46458().method_46472();

        return layout;
    }

    protected void addLabeledOptionToLayout(class_339 widget, class_2561 label, class_7845 layout, int rowIndex, int occupiedRows) {
        class_7940 textWidget = new class_7940(label, class_310.method_1551().field_1772);
        textWidget.method_48984(Math.abs(widget.method_25368() - MAX_LAYOUT_WIDTH) - COLUMN_GAP);

        class_7843 frameLayout = new class_7843(
            MAX_LAYOUT_WIDTH,
            Math.max(textWidget.method_25364(), widget.method_25364()) + ROW_GAP
        );
        frameLayout.method_46449(MAX_LAYOUT_WIDTH);
        frameLayout.method_46450().method_46474();
        frameLayout.method_48229(layout.method_46426(), layout.method_46427());

        frameLayout.method_52732(textWidget, class_7847::method_46461);
        frameLayout.method_52732(widget, class_7847::method_46470);

        addFrameToLayout(
            frameLayout,
            layout,
            rowIndex,
            occupiedRows
        );
    }

    protected void addStackedLabeledOptionToLayout(class_339 widget, class_2561 label, class_7845 layout, int rowIndex, int occupiedRows) {
        class_7940 textWidget = new class_7940(label, class_310.method_1551().field_1772);
        textWidget.method_48984(MAX_LAYOUT_WIDTH);

        class_7843 frameLayout = new class_7843(
            MAX_LAYOUT_WIDTH,
            textWidget.method_25364() + widget.method_25364() + ROW_GAP
        );
        frameLayout.method_46449(MAX_LAYOUT_WIDTH);
        frameLayout.method_46447(textWidget.method_25364() + widget.method_25364());
        frameLayout.method_46450().method_46461();
        frameLayout.method_48229(layout.method_46426(), layout.method_46427());

        frameLayout.method_52732(textWidget, class_7847::method_46472);
        frameLayout.method_52732(widget, class_7847::method_46476);

        addFrameToLayout(
            frameLayout,
            layout,
            rowIndex,
            occupiedRows
        );
    }

    protected void addFrameToLayout(class_7843 frameLayout, class_7845 layout, int rowIndex, int occupiedRows) {
        layout.method_52733(
            frameLayout,
            rowIndex,
            0,
            occupiedRows,
            1,
            class_7847::method_46461
        );
        frameLayout.method_48206(this::method_37063);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);

        if(this.getCurrentLeftPageIndex() == 0) {
            guiGraphics.method_52706(
                class_10799.field_56883,
                BedrockLecternScreen.RIGHT_RIBBON_SELECTED_SPRITE,
                this.field_22789 / 2,
                (this.field_22790 / 2) - BedrockLecternScreen.RIBBON_Y_OFFSET,
                BedrockLecternScreen.RIBBON_WIDTH,
                BedrockLecternScreen.RIBBON_TOP_HEIGHT + ConfigOptions.RIBBON_HEIGHT.getPendingOrCurrentValue() + BedrockLecternScreen.RIBBON_BOTTOM_HEIGHT
            );
        }
    }

    @Override
    protected class_2561 getPageIndicatorMessage(int index) {
        return switch (index) {
            case 0 -> class_2561.method_43471("ui.eg_bedrock_books.config.page.general");
            case 1 -> class_2561.method_43471("ui.eg_bedrock_books.config.page.visual");
            case 2 -> class_2561.method_43471("ui.eg_bedrock_books.config.page.debug");
            default -> super.getPageIndicatorMessage(index);
        };
    }

    @Override
    protected void updateVisibleContents() {
        super.updateVisibleContents();
        if(this.getCurrentLeftPageIndex() == 0) {
            this.generalGridLayout.method_48206(widget -> widget.field_22764 = true);
            this.visualGridLayout.method_48206(widget -> widget.field_22764 = true);
            this.debugGridLayout.method_48206(widget -> widget.field_22764 = false);
        } else {
            this.generalGridLayout.method_48206(widget -> widget.field_22764 = false);
            this.visualGridLayout.method_48206(widget -> widget.field_22764 = false);
            this.debugGridLayout.method_48206(widget -> widget.field_22764 = true);
        }
    }
}
