package games.enchanted.eg_bedrock_books.common.screen.widget;

import games.enchanted.eg_bedrock_books.common.duck.AbstractWidgetAdditions;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_11876;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_8030;

public class CustomSpriteButton extends class_4185 implements AbstractWidgetAdditions {
    protected ButtonConfig buttonConfig;

    public CustomSpriteButton(int x, int y, int width, int height, class_4241 onPress, class_2561 message, ButtonConfig buttonConfig) {
        super(x, y, width, height, message, onPress, field_40754);
        this.buttonConfig = buttonConfig;
    }

    public void setButtonConfig(ButtonConfig config) {
        this.buttonConfig = config;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_52706(
            class_10799.field_56883,
            this.method_49606() ? buttonConfig.hoverSprite() : this.method_25370() ? buttonConfig.focusedSprite() : buttonConfig.sprite(),
            this.method_46426(),
            this.method_46427(),
            this.method_25368(),
            this.method_25364()
        );

        //? if minecraft: >= 1.21.9 {
        if (this.method_49606()) {
            guiGraphics.method_74037(this.method_37303() ? class_11876.field_62455 : class_11876.field_62459);
        }
        //?}
    }

    public void method_25354(class_1144 handler) {
        if (buttonConfig.soundInstance != null) {
            handler.method_4873(buttonConfig.soundInstance().get());
        }
    }

    @Override
    public class_8030 eg_bedrock_books$getTooltipRectangle() {
        return class_8030.method_48248();
    }

    public record ButtonConfig(@Nullable Supplier<class_1113> soundInstance, class_2960 sprite, class_2960 hoverSprite, class_2960 focusedSprite) {
    }
}
