package games.enchanted.eg_bedrock_books.common.screen.widget;

import games.enchanted.eg_bedrock_books.common.ModConstants;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import org.jetbrains.annotations.NotNull;

import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_4068;
import net.minecraft.class_7843;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8667;

public class EditControls implements class_4068, class_8021 {
    private static final int EDIT_BUTTON_SIZE = 20;
    private static final int MAX_VISIBLE_BUTTONS = 4;

    protected static final class_2561 PENCIL_BUTTON_LABEL = class_2561.method_43471("ui.eg_bedrock_books.edit.open_edit_controls_label");
    protected static final CustomSpriteButton.ButtonConfig PENCIL_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/edit_button"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/edit_button_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/edit_button_focus")
    );

    protected static final class_2561 MOVE_BACK_BUTTON_LABEL = class_2561.method_43471("ui.eg_bedrock_books.edit.move_page_back_label");
    protected static final CustomSpriteButton.ButtonConfig MOVE_BACK_BUTTON = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/move_page_backward_button"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/move_page_backward_button_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/move_page_backward_button_focus")
    );

    protected static final class_2561 ADD_PAGE_BUTTON_LABEL = class_2561.method_43471("ui.eg_bedrock_books.edit.add_page_label");
    protected static final CustomSpriteButton.ButtonConfig ADD_PAGE_BUTTON = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/add_page_button"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/add_page_button_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/add_page_button_focus")
    );

    protected static final class_2561 DELETE_PAGE_BUTTON_LABEL = class_2561.method_43471("ui.eg_bedrock_books.edit.delete_page_label");
    protected static final CustomSpriteButton.ButtonConfig DELETE_PAGE_BUTTON = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/delete_page_button"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/delete_page_button_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/delete_page_button_focus")
    );

    protected static final class_2561 MOVE_FORWARD_BUTTON_LABEL = class_2561.method_43471("ui.eg_bedrock_books.edit.move_page_forward_label");
    protected static final CustomSpriteButton.ButtonConfig MOVE_FORWARD_BUTTON = new CustomSpriteButton.ButtonConfig(
        () -> class_1109.method_47978(class_3417.field_15015, 1.0F),
        class_2960.method_60655(ModConstants.MOD_ID, "book/move_page_forward_button"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/move_page_forward_button_hover"),
        class_2960.method_60655(ModConstants.MOD_ID, "book/move_page_forward_button_focus")
    );

    protected int x;
    protected int y;
    protected boolean preventVisibilityUpdates = false;
    private boolean controlsVisible = false;
    protected boolean moveBackButtonVisible = true;
    protected boolean moveForwardButtonVisible = true;

    protected final class_8667 layout;
    protected final CustomSpriteButton pencilButton;
    protected final Actions buttonActions;
    protected final CustomSpriteButton moveBackButton;
    protected final CustomSpriteButton addButton;
    protected final CustomSpriteButton deleteButton;
    protected final CustomSpriteButton moveForwardButton;

    public EditControls(int x, int y, Actions buttonActions) {
        this.x = x;
        this.y = y;
        this.buttonActions = buttonActions;

        this.layout = new class_8667(EDIT_BUTTON_SIZE * MAX_VISIBLE_BUTTONS, EDIT_BUTTON_SIZE, class_8667.class_8668.field_45403);
        this.layout.method_48229(x, y);

        this.pencilButton = new CustomSpriteButton(0, 0, EDIT_BUTTON_SIZE, EDIT_BUTTON_SIZE, button -> this.toggleControls(true), PENCIL_BUTTON_LABEL, PENCIL_BUTTON_CONFIG);

        this.moveBackButton = new CustomSpriteButton(0, 0, EDIT_BUTTON_SIZE, EDIT_BUTTON_SIZE, button -> this.buttonActions.moveBackPressed().run(), MOVE_BACK_BUTTON_LABEL, MOVE_BACK_BUTTON);
        this.moveBackButton.field_22764 = false;
        this.layout.method_52736(this.moveBackButton);

        this.addButton = new CustomSpriteButton(0, 0, EDIT_BUTTON_SIZE, EDIT_BUTTON_SIZE, button -> this.buttonActions.addPressed().run(), ADD_PAGE_BUTTON_LABEL, ADD_PAGE_BUTTON);
        this.addButton.field_22764 = false;
        this.layout.method_52736(this.addButton);

        this.deleteButton = new CustomSpriteButton(0, 0, EDIT_BUTTON_SIZE, EDIT_BUTTON_SIZE, button -> this.buttonActions.deletePressed().run(), DELETE_PAGE_BUTTON_LABEL, DELETE_PAGE_BUTTON);
        this.deleteButton.field_22764 = false;
        this.layout.method_52736(this.deleteButton);

        this.moveForwardButton = new CustomSpriteButton(0, 0, EDIT_BUTTON_SIZE, EDIT_BUTTON_SIZE, button -> this.buttonActions.moveForwardPressed().run(), MOVE_FORWARD_BUTTON_LABEL, MOVE_FORWARD_BUTTON);
        this.moveForwardButton.field_22764 = false;
        this.layout.method_52736(this.moveForwardButton);

        this.layout.method_48222();
        this.repositionElements();
    }

    public void toggleControls(boolean showControls) {
        if(this.preventVisibilityUpdates) return;

        this.controlsVisible = showControls;

        this.pencilButton.field_22764 = !showControls;
        this.moveBackButton.field_22764 = showControls && this.moveBackButtonVisible;
        this.addButton.field_22764 = showControls;
        this.deleteButton.field_22764 = showControls;
        this.moveForwardButton.field_22764 = showControls && this.moveForwardButtonVisible;

        this.repositionElements();
    }

    public void toggleControls() {
        this.toggleControls(!this.controlsVisible);
    }

    public void updateControlVisibility() {
        this.toggleControls(this.controlsVisible);
    }

    public void setMoveForwardButtonVisible(boolean newValue) {
        this.moveForwardButtonVisible = newValue;
        updateControlVisibility();
        repositionElements();
    }

    public void setMoveBackButtonVisible(boolean newValue) {
        this.moveBackButtonVisible = newValue;
        updateControlVisibility();
        repositionElements();
    }

    protected int getVisibleButtons() {
        return 2 + (this.moveBackButtonVisible ? 1 : 0) + (this.moveForwardButtonVisible ? 1 : 0);
    }

    public void setVisibility(boolean visibility) {
        this.preventVisibilityUpdates = !visibility;
        if(!visibility) {
            method_48206(widget -> widget.field_22764 = false);
        } else {
            toggleControls(this.controlsVisible);
        }
    }

    @Override
    public void method_48206(Consumer<class_339> visitor) {
        visitor.accept(this.pencilButton);
        this.layout.method_48227(element -> element.method_48206(visitor));
    }

    public void repositionElements() {
        this.layout.method_52740().method_46467();
        this.layout.method_48222();
        int moveLeftOrRight = this.moveForwardButtonVisible ? -1 : 1;
        this.layout.method_48229(this.x + (getVisibleButtons() == 3 ? (EDIT_BUTTON_SIZE / 2) * moveLeftOrRight: 0), this.y);

        class_7843.method_48634(this.pencilButton, this.method_48202());
    }

    @Override
    public void method_46421(int x) {
        this.x = x;
    }

    @Override
    public void method_46419(int y) {
        this.y = y;
    }

    @Override
    public int method_46426() {
        return this.x;
    }

    @Override
    public int method_46427() {
        return this.y;
    }

    @Override
    public int method_25368() {
        return EDIT_BUTTON_SIZE * MAX_VISIBLE_BUTTONS;
    }

    @Override
    public int method_25364() {
        return EDIT_BUTTON_SIZE;
    }

    @Override
    public @NotNull class_8030 method_48202() {
        return new class_8030(this.x, this.y, method_25368(), method_25364());
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if(!InputUtil.shouldShowDebugWidgetBound()) return;
        guiGraphics.method_25296(method_48202().method_49620(), method_48202().method_49618(), method_48202().method_49621(), method_48202().method_49619(), 0xaa00ffff, 0xaa00ffff);
        guiGraphics.method_25296(this.layout.method_46426(), this.layout.method_46427(), this.layout.method_46426() + 12, this.layout.method_46427() + 12, 0xaa00ff00, 0xaa00ff00);
    }

    public record Actions(Runnable moveBackPressed, Runnable addPressed, Runnable deletePressed, Runnable moveForwardPressed) {
    }
}
