package games.enchanted.eg_bedrock_books.common.screen.widget.config;

import games.enchanted.eg_bedrock_books.common.screen.widget.TogglableSpriteButton;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class CheckBox extends TogglableSpriteButton {
    protected static final int SIZE = 16;

    protected final ValueChange valueChange;

    public CheckBox(int x, int y, boolean initialValue, ValueChange valueChange, class_2561 message, ButtonConfig checkedConfig, ButtonConfig uncheckedConfig) {
        super(x, y, SIZE, SIZE, button -> {}, message, checkedConfig, uncheckedConfig);
        this.valueChange = valueChange;
        this.setToggle(initialValue);
    }

    @Override
    protected @NotNull class_5250 method_25360() {
        return class_5244.method_37111(
            this.method_25369(),
            class_2561.method_43471("ui.eg_bedrock_books.widget.checkbox." + (this.getToggle() ? "checked" : "unchecked") + ".narration")
        );
    }

    @Override
    public void method_25306(
        //? if minecraft: >= 1.21.9 {
        class_11907 inputWithModifiers
        //?}
    ) {
        super.method_25306(
            //? if minecraft: >= 1.21.9 {
            inputWithModifiers
            //?}
        );
        this.setToggle(!this.getToggle());
        this.valueChange.onPress(this.getToggle());
    }

    public interface ValueChange {
        void onPress(boolean value);
    }
}
