/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.config.ConfigScreenBehaviour;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.EditControls;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBedrockBookScreen<PageContent, TextView extends TextAreaView<PageContent>>
extends class_437 {
    protected static final int BACKGROUND_WIDTH = 512;
    protected static final int BACKGROUND_HEIGHT = 256;
    protected static final int PAGE_EDIT_BOX_WIDTH = 122;
    protected static final int PAGE_EDIT_BOX_HEIGHT = 134;
    protected static final int PAGE_TEXT_WIDTH = 114;
    protected static final int PAGE_TEXT_HEIGHT = 128;
    protected static final int CENTER_PADDING = 22;
    protected static final int CURSOR_COLOUR = -16777216;
    protected static final int TEXT_COLOUR = -16777216;
    protected static final int PAGE_INDICATOR_COLOUR = -4414585;
    protected static final boolean TEXT_SHADOW = false;
    protected static final int FOOTER_BUTTON_WIDTH = 90;
    protected static final int FOOTER_BUTTON_SPACING = 8;
    protected static final String BOOK_PAGE_INDICATOR = "book.pageIndicator";
    protected static final class_2561 SIGN_BUTTON_COMPONENT = class_2561.method_43471((String)"book.signButton");
    protected static final class_2561 SAVE_BUTTON_COMPONENT = class_2561.method_43471((String)"selectWorld.edit.save");
    private static final int TURN_PAGE_BUTTON_SIZE = 24;
    private static final class_2561 PAGE_LEFT_BUTTON_LABEL = class_2561.method_43471((String)"book.page_button.previous");
    private static final CustomSpriteButton.ButtonConfig PAGE_LEFT_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/page_backward"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/page_backward_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/page_backward_focus"));
    private static final class_2561 PAGE_RIGHT_BUTTON_LABEL = class_2561.method_43471((String)"book.page_button.next");
    private static final CustomSpriteButton.ButtonConfig PAGE_RIGHT_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/page_forward"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/page_forward_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/page_forward_focus"));
    private static final int CLOSE_BUTTON_SIZE = 9;
    private static final class_2561 CLOSE_BUTTON_LABEL = class_5244.field_24334;
    private static final CustomSpriteButton.ButtonConfig CLOSE_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/close"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/close_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/close_focus"));
    private static final int CONFIG_BUTTON_SIZE = 24;
    private static final class_2561 CONFIG_BUTTON_LABEL = class_2561.method_43471((String)"ui.eg_bedrock_books.config.title");
    private static final CustomSpriteButton.ButtonConfig CONFIG_BUTTON_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"config_button"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config_button_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config_button_focus"));
    protected static final int MAX_PAGES = 100;
    private int currentLeftPageIndex = 0;
    protected List<PageContent> pages = new ArrayList<PageContent>();
    protected CustomSpriteButton turnLeftButton;
    protected CustomSpriteButton turnRightButton;
    protected final boolean canEditAndCreatePages;
    protected class_2561 leftPageNumberMessage = class_5244.field_39003;
    protected TextView leftPageTextView;
    @Nullable
    private EditControls leftPageEditControls = null;
    protected class_2561 rightPageNumberMessage = class_5244.field_39003;
    protected TextView rightPageTextView;
    @Nullable
    private EditControls rightPageEditControls = null;
    protected class_8667 footerButtonLayout;
    protected CustomSpriteButton configButton;
    protected CustomSpriteButton xButton;

    public AbstractBedrockBookScreen(class_2561 message, boolean editable) {
        super(message);
        this.canEditAndCreatePages = editable;
    }

    protected void method_25426() {
        int editBoxYPos = this.field_22790 / 2 - 134 + 45;
        int turnPageButtonYPos = this.field_22790 / 2 + 47;
        int editControlsYPos = this.field_22790 / 2 + 44;
        this.xButton = new CustomSpriteButton(this.field_22789 / 2 + 11 + 120, this.field_22790 / 2 - 134 + 33, 9, 9, button -> this.method_25419(), CLOSE_BUTTON_LABEL, CLOSE_BUTTON_CONFIG);
        this.method_37063((class_364)this.xButton);
        this.xButton.field_22764 = ConfigOptions.SHOW_X_BUTTON.getValue();
        TextViewAndWidget<PageContent, TextView> leftPageWidget = this.createTextWidgetAndView(this.field_22789 / 2 - 11 - 122, editBoxYPos, PageSide.LEFT);
        this.leftPageTextView = leftPageWidget.view();
        if (leftPageWidget.widget() != null) {
            this.method_37063((class_364)leftPageWidget.widget());
            this.method_48265((class_364)leftPageWidget.widget());
        }
        if (this.canEditAndCreatePages) {
            this.leftPageEditControls = new EditControls(this.field_22789 / 2 - 11 - 61 - 42, editControlsYPos, new EditControls.Actions(() -> this.handlePageMove(PageMoveDirection.LEFT, this.currentLeftPageIndex), () -> this.handleAddPage(this.currentLeftPageIndex), () -> this.handlePageDelete(this.currentLeftPageIndex), () -> this.handlePageMove(PageMoveDirection.RIGHT, this.currentLeftPageIndex)));
            this.leftPageEditControls.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            this.method_37060(this.leftPageEditControls);
        }
        this.addWidgetsBetweenPages();
        TextViewAndWidget<PageContent, TextView> rightPageWidget = this.createTextWidgetAndView(this.field_22789 / 2 + 11, editBoxYPos, PageSide.RIGHT);
        this.rightPageTextView = rightPageWidget.view();
        if (rightPageWidget.widget() != null) {
            this.method_37063((class_364)rightPageWidget.widget());
        }
        if (this.canEditAndCreatePages) {
            this.rightPageEditControls = new EditControls(this.field_22789 / 2 - 11 + 42, editControlsYPos, new EditControls.Actions(() -> this.handlePageMove(PageMoveDirection.LEFT, this.currentLeftPageIndex + 1), () -> this.handleAddPage(this.currentLeftPageIndex + 1), () -> this.handlePageDelete(this.currentLeftPageIndex + 1), () -> this.handlePageMove(PageMoveDirection.RIGHT, this.currentLeftPageIndex + 1)));
            this.rightPageEditControls.method_48206(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            this.method_37060(this.rightPageEditControls);
        }
        this.turnLeftButton = new CustomSpriteButton(this.field_22789 / 2 - 147, turnPageButtonYPos, 24, 24, button -> this.turnBackPage(), PAGE_LEFT_BUTTON_LABEL, PAGE_LEFT_BUTTON_CONFIG);
        this.method_37063((class_364)this.turnLeftButton);
        this.turnRightButton = new CustomSpriteButton(this.field_22789 / 2 + 123, turnPageButtonYPos, 24, 24, button -> this.turnForwardPage(), PAGE_RIGHT_BUTTON_LABEL, PAGE_RIGHT_BUTTON_CONFIG);
        this.method_37063((class_364)this.turnRightButton);
        this.footerButtonLayout = class_8667.method_52742().method_52735(8);
        this.makeFooterButtons();
        this.footerButtonLayout.method_48222();
        this.footerButtonLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.updateVisibleContents();
        this.addConfigButton();
    }

    protected abstract TextViewAndWidget<PageContent, TextView> createTextWidgetAndView(int var1, int var2, PageSide var3);

    protected void addWidgetsBetweenPages() {
    }

    protected void makeFooterButtons() {
    }

    protected void addConfigButton() {
        this.configButton = new CustomSpriteButton(4, this.field_22790 - 24 - 4, 24, 24, button -> ConfigScreenBehaviour.openConfigScreen(this), CONFIG_BUTTON_LABEL, CONFIG_BUTTON_CONFIG);
        this.method_37063((class_364)this.configButton);
    }

    protected void updateVisibleContents() {
        this.turnLeftButton.field_22764 = true;
        this.turnRightButton.field_22764 = true;
        if (this.currentLeftPageIndex <= 1) {
            this.turnLeftButton.field_22764 = false;
        }
        if (this.currentLeftPageIndex + 2 >= this.getCurrentAmountOfPages() && !this.canEditAndCreatePages || this.currentLeftPageIndex + 2 >= 100) {
            this.turnRightButton.field_22764 = false;
        }
        this.leftPageNumberMessage = this.getPageIndicatorMessage(this.currentLeftPageIndex);
        this.leftPageTextView.setValue(this.getOrCreatePageIfPossible(this.currentLeftPageIndex), true);
        int rightPageIndex = this.currentLeftPageIndex + 1;
        if (this.getCurrentAmountOfPages() % 2 == 1 && this.currentLeftPageIndex >= this.getCurrentAmountOfPages() - 1) {
            this.rightPageNumberMessage = class_2561.method_43473();
            this.rightPageTextView.setVisibility(false);
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.setVisibility(false);
            }
        } else {
            this.rightPageNumberMessage = this.getPageIndicatorMessage(this.currentLeftPageIndex + 1);
            this.rightPageTextView.setVisibility(true);
            this.rightPageTextView.setValue(this.getPageOrEmpty(rightPageIndex), true);
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.setVisibility(true);
            }
        }
        if (this.canEditAndCreatePages) {
            if (this.leftPageEditControls != null) {
                this.leftPageEditControls.setMoveBackButtonVisible(this.currentLeftPageIndex > 0);
                this.leftPageEditControls.setMoveForwardButtonVisible(this.currentLeftPageIndex < this.getCurrentAmountOfPages() - 1);
            }
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.setMoveBackButtonVisible(rightPageIndex > 0);
                this.rightPageEditControls.setMoveForwardButtonVisible(rightPageIndex < this.getCurrentAmountOfPages() - 1);
            }
        }
    }

    protected void ensureEvenPageIndex(int newPageIndex) {
        if ((newPageIndex = Math.max(0, newPageIndex)) % 2 == 1) {
            this.currentLeftPageIndex = newPageIndex - 1;
            return;
        }
        this.currentLeftPageIndex = newPageIndex;
    }

    protected int getCurrentLeftPageIndex() {
        return this.currentLeftPageIndex;
    }

    protected void resetEditControls() {
        if (this.canEditAndCreatePages) {
            if (this.leftPageEditControls != null) {
                this.leftPageEditControls.toggleControls(false);
            }
            if (this.rightPageEditControls != null) {
                this.rightPageEditControls.toggleControls(false);
            }
        }
    }

    protected void handlePageMove(PageMoveDirection direction, int index) {
        if (direction == PageMoveDirection.LEFT && index > 0 && index < this.pages.size()) {
            PageContent currentPage = this.pages.get(index);
            PageContent previousPage = this.pages.get(index - 1);
            this.pages.set(index, previousPage);
            this.pages.set(index - 1, currentPage);
        } else if (index < this.pages.size() - 1) {
            PageContent currentPage = this.pages.get(index);
            PageContent nextPage = this.pages.get(index + 1);
            this.pages.set(index, nextPage);
            this.pages.set(index + 1, currentPage);
        }
        this.updateVisibleContents();
    }

    protected abstract PageContent getEmptyPageContent();

    protected void handleAddPage(int index) {
        this.addPage(this.getEmptyPageContent(), index);
        this.updateVisibleContents();
    }

    protected void handlePageDelete(int index) {
        if (index >= this.pages.size()) {
            return;
        }
        this.pages.remove(index);
        this.updateVisibleContents();
    }

    protected void addPage(PageContent contents) {
        if (!this.canEditAndCreatePages) {
            return;
        }
        this.addPage(contents, this.pages.size());
    }

    protected void addPage(PageContent contents, int index) {
        if (!this.canEditAndCreatePages) {
            return;
        }
        if (this.pages.size() >= 100) {
            return;
        }
        this.pages.add(index, contents);
    }

    protected PageContent getOrCreatePageIfPossible(int index) {
        if (index > this.pages.size() - 1) {
            if (!this.canEditAndCreatePages) {
                return this.getEmptyPageContent();
            }
            this.addPage(this.getEmptyPageContent());
            this.updateVisibleContents();
        }
        return this.pages.get(index);
    }

    protected PageContent getPageOrEmpty(int index) {
        if (index > this.pages.size() - 1) {
            return this.getEmptyPageContent();
        }
        return this.pages.get(index);
    }

    protected void setPageContent(PageContent contents, int index) {
        if (index > this.pages.size() - 1) {
            this.addPage(contents);
            return;
        }
        this.pages.set(index, contents);
    }

    protected void turnForwardPage() {
        if (this.currentLeftPageIndex + 2 >= 100) {
            return;
        }
        if (this.currentLeftPageIndex + 3 >= this.getCurrentAmountOfPages() && this.canEditAndCreatePages) {
            if (this.getCurrentAmountOfPages() % 2 == 0) {
                this.addPage(this.getEmptyPageContent());
                this.addPage(this.getEmptyPageContent());
            } else if (this.currentLeftPageIndex + 1 == this.getCurrentAmountOfPages()) {
                this.addPage(this.getEmptyPageContent());
                this.addPage(this.getEmptyPageContent());
                this.addPage(this.getEmptyPageContent());
            } else if (this.getCurrentAmountOfPages() % 2 == 1) {
                this.addPage(this.getEmptyPageContent());
            }
        }
        this.ensureEvenPageIndex(this.currentLeftPageIndex + 2);
        this.resetEditControls();
        this.updateVisibleContents();
    }

    protected void turnBackPage() {
        this.ensureEvenPageIndex(Math.max(this.currentLeftPageIndex - 2, 0));
        this.resetEditControls();
        this.updateVisibleContents();
    }

    protected int getCurrentAmountOfPages() {
        return this.pages.size();
    }

    protected class_2561 getPageIndicatorMessage(int index) {
        int offsetIndex = index + 1;
        if (offsetIndex > this.getCurrentAmountOfPages()) {
            return class_5244.field_39003;
        }
        return class_2561.method_43469((String)BOOK_PAGE_INDICATOR, (Object[])new Object[]{offsetIndex, this.getCurrentAmountOfPages()});
    }

    public boolean method_25404(class_11908 keyEvent) {
        assert (this.field_22787 != null);
        int keyCode = keyEvent.comp_4795();
        class_11910 inputWithModifiers = new class_11910(0, 0);
        if (keyCode == ConfigOptions.MOVE_BACKWARD_PAGE_KEY.getPendingOrCurrentValue().method_1444() && this.turnLeftButton.field_22764) {
            this.turnLeftButton.method_25306((class_11907)inputWithModifiers);
            this.turnLeftButton.method_25354(this.field_22787.method_1483());
            return true;
        }
        if (keyCode == ConfigOptions.MOVE_FORWARD_PAGE_KEY.getPendingOrCurrentValue().method_1444() && this.turnRightButton.field_22764) {
            this.turnRightButton.method_25306((class_11907)inputWithModifiers);
            this.turnLeftButton.method_25354(this.field_22787.method_1483());
            return true;
        }
        return super.method_25404(keyEvent);
    }

    @NotNull
    public class_2561 method_25435() {
        return class_5244.method_37111((class_2561[])new class_2561[]{super.method_25435(), this.getPageIndicatorMessage(this.currentLeftPageIndex)});
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int pageNumberYPos = this.field_22790 / 2 - 134 + 35;
        int leftPageNumberWidth = this.field_22793.method_27525((class_5348)this.leftPageNumberMessage);
        guiGraphics.method_51439(this.field_22793, this.leftPageNumberMessage, this.field_22789 / 2 - 11 - 61 - leftPageNumberWidth / 2, pageNumberYPos, -4414585, false);
        int rightPageNumberWidth = this.field_22793.method_27525((class_5348)this.rightPageNumberMessage);
        guiGraphics.method_51439(this.field_22793, this.rightPageNumberMessage, this.field_22789 / 2 + 11 + 61 - rightPageNumberWidth / 2, pageNumberYPos, -4414585, false);
        if (InputUtil.shouldShowDebugVariables()) {
            guiGraphics.method_25303(this.field_22793, "leftPageIndex: " + this.getCurrentLeftPageIndex(), 0, 56, -1);
        }
    }

    protected abstract class_2960 getBackgroundTexture();

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderMinecraftBackgrounds(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_25290(class_10799.field_56883, this.getBackgroundTexture(), this.field_22789 / 2 - 256, this.field_22790 / 2 - 128, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    protected void renderMinecraftBackgrounds(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22787 != null && this.field_22787.field_1687 == null) {
            this.method_57728(guiGraphics, partialTick);
            this.method_57734(guiGraphics);
            this.method_57735(guiGraphics);
        } else {
            this.method_52752(guiGraphics);
        }
    }

    public static enum PageSide {
        LEFT,
        RIGHT;

    }

    public record TextViewAndWidget<Value, TextView extends TextAreaView<Value>>(TextView view, @Nullable class_339 widget) {
    }

    public static enum PageMoveDirection {
        LEFT,
        RIGHT;

    }
}

