/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.AbstractBedrockBookScreen;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.ComponentTextAreaView;
import games.enchanted.eg_bedrock_books.common.screen.widget.text.TextAreaView;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_11909;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3872;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public class BedrockBookViewScreen
extends AbstractBedrockBookScreen<class_2561, TextAreaView<class_2561>> {
    protected static final class_2561 BOOK_VIEW_TITLE = class_2561.method_43471((String)"book.view.title");
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"eg_bedrock_books", (String)"textures/gui/book/view_background.png");
    protected static final int FOOTER_BUTTON_WIDTH = 200;
    protected static final int TEXT_OFFSET_LEFT = 4;
    protected static final int TEXT_OFFSET_RIGHT = 4;
    protected static final int TEXT_OFFSET_TOP = 10;
    protected static final int PAGE_CLICK_BOUNDS_EXTRA_PADDING = 2;
    protected int leftPageX = 0;
    protected int leftPageY = 0;
    protected List<class_5481> leftPageSplitLines = List.of();
    protected int rightPageX = 0;
    protected int rightPageY = 0;
    protected List<class_5481> rightPageSplitLines = List.of();
    protected double mouseX = 0.0;
    protected double mouseY = 0.0;
    @Nullable
    protected class_2583 styleUnderMouseCursor = null;

    public BedrockBookViewScreen(class_3872.class_3931 bookAccess) {
        super(BOOK_VIEW_TITLE, false);
        this.pages = bookAccess.comp_2438();
    }

    public BedrockBookViewScreen() {
        this(class_3872.field_17417);
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(200).method_46431());
        this.footerButtonLayout.method_48229(this.field_22789 / 2 - 100, this.field_22790 / 2 + 90);
    }

    @Override
    protected AbstractBedrockBookScreen.TextViewAndWidget<class_2561, TextAreaView<class_2561>> createTextWidgetAndView(int x, int y, AbstractBedrockBookScreen.PageSide side) {
        if (side == AbstractBedrockBookScreen.PageSide.LEFT) {
            this.leftPageX = x + 8 - this.getHorizontalLeftPageTextOffset();
            this.leftPageY = y + this.getVerticalTextOffset();
        } else {
            this.rightPageX = x + this.getHorizontalRightPageTextOffset();
            this.rightPageY = y + this.getVerticalTextOffset();
        }
        return new AbstractBedrockBookScreen.TextViewAndWidget<class_2561, TextAreaView<class_2561>>(new ComponentTextAreaView(component -> {
            int offsetIndex = this.getCurrentLeftPageIndex() + (side == AbstractBedrockBookScreen.PageSide.LEFT ? 0 : 1);
            if (side == AbstractBedrockBookScreen.PageSide.LEFT) {
                this.leftPageSplitLines = this.splitPage(offsetIndex);
            } else {
                this.rightPageSplitLines = this.splitPage(offsetIndex);
            }
        }), null);
    }

    protected int getHorizontalLeftPageTextOffset() {
        return 4;
    }

    protected int getHorizontalRightPageTextOffset() {
        return 4;
    }

    protected int getVerticalTextOffset() {
        return 10;
    }

    protected List<class_5481> splitPage(int index) {
        return this.field_22793.method_1728((class_5348)this.getPageOrEmpty(index), 114);
    }

    @Override
    protected class_2561 getEmptyPageContent() {
        return class_5244.field_39003;
    }

    @Override
    protected void turnForwardPage() {
        super.turnForwardPage();
        this.refreshStyleUnderMouse();
    }

    @Override
    protected void turnBackPage() {
        super.turnBackPage();
        this.refreshStyleUnderMouse();
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        class_2583 clickedStyle = this.getStyleAt(this.mouseX, this.mouseY, null);
        int button = mouseButtonEvent.method_74245();
        if (button == 0 && clickedStyle != null && this.method_25430(clickedStyle)) {
            return true;
        }
        return super.method_25402(mouseButtonEvent, doubleClick);
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.refreshStyleUnderMouse();
    }

    protected void refreshStyleUnderMouse() {
        this.styleUnderMouseCursor = this.getStyleAt(this.mouseX, this.mouseY, null);
    }

    @Nullable
    public class_2583 getStyleAt(double x, double y, @Nullable class_332 guiGraphics) {
        int closestPageY;
        if (this.leftPageSplitLines.isEmpty() && this.rightPageSplitLines.isEmpty()) {
            return null;
        }
        boolean closestToLeftHorizontally = x < (double)(this.leftPageX + 114 + 2);
        int closestPageX = closestToLeftHorizontally ? this.leftPageX : this.rightPageX;
        int n = closestPageY = closestToLeftHorizontally ? this.leftPageY : this.rightPageY;
        if (x < (double)(closestPageX - 2) || x > (double)(closestPageX + 2 + 114)) {
            return null;
        }
        if (y < (double)(closestPageY - 2) || y > (double)(closestPageY + 2 + 128)) {
            return null;
        }
        int clampedRelativeX = (int)Math.clamp(x - (double)closestPageX, 0.0, (double)(closestPageX + 114));
        int clampedRelativeY = (int)Math.clamp(y - (double)closestPageY, 0.0, (double)(closestPageY + 128));
        if (guiGraphics != null && InputUtil.shouldShowDebugTextBound()) {
            this.drawXY(closestToLeftHorizontally ? 0 : 1, closestToLeftHorizontally ? 0 : 1, 0, guiGraphics);
            this.drawXY(closestPageX, closestPageY, 8, guiGraphics);
            this.drawXY(clampedRelativeX, clampedRelativeY, 16, guiGraphics);
        }
        class_310 minecraft = class_310.method_1551();
        Objects.requireNonNull(minecraft.field_1772);
        int lineIndex = clampedRelativeY / 9;
        if (lineIndex >= 0 && lineIndex < (closestToLeftHorizontally ? this.leftPageSplitLines.size() : this.rightPageSplitLines.size())) {
            class_5481 line = (closestToLeftHorizontally ? this.leftPageSplitLines : this.rightPageSplitLines).get(lineIndex);
            return minecraft.field_1772.method_27527().method_30876(line, clampedRelativeX);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void method_71846(class_310 minecraft, class_2558 clickEvent) {
        class_2558 class_25582 = clickEvent;
        Objects.requireNonNull(class_25582);
        class_2558 class_25583 = class_25582;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2558.class_10609.class, class_2558.class_10605.class}, (Object)class_25583, n)) {
            case 0: {
                BedrockBookViewScreen bedrockBookViewScreen;
                class_746 class_7462;
                String string2;
                class_2558.class_10609 class_106092 = (class_2558.class_10609)class_25583;
                try {
                    String string;
                    string2 = string = class_106092.comp_3506();
                    if (ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getValue().booleanValue()) {
                        this.closeServerContainer();
                    }
                    if (minecraft.field_1724 == null) return;
                    class_7462 = minecraft.field_1724;
                    bedrockBookViewScreen = ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getValue().booleanValue() ? null : this;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                BedrockBookViewScreen.method_71844((class_746)class_7462, (String)string2, (class_437)bedrockBookViewScreen);
                return;
            }
            case 1: {
                class_2558.class_10605 class_106052 = (class_2558.class_10605)class_25583;
                {
                    int n2;
                    int i = n2 = class_106052.comp_3502();
                    this.setPageIndex(i - 1);
                    return;
                }
            }
        }
        BedrockBookViewScreen.method_71999((class_2558)clickEvent, (class_310)minecraft, (class_437)this);
    }

    protected void closeServerContainer() {
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        Objects.requireNonNull(this.field_22793);
        int leftLines = Math.min(128 / 9, this.leftPageSplitLines.size());
        for (int i = 0; i < leftLines; ++i) {
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51430(this.field_22793, this.leftPageSplitLines.get(i), this.leftPageX, this.leftPageY + i * 9, -16777216, false);
        }
        Objects.requireNonNull(this.field_22793);
        int rightLines = Math.min(128 / 9, this.rightPageSplitLines.size());
        for (int i = 0; i < rightLines; ++i) {
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51430(this.field_22793, this.rightPageSplitLines.get(i), this.rightPageX, this.rightPageY + i * 9, -16777216, false);
        }
        guiGraphics.method_51441(this.field_22793, this.styleUnderMouseCursor, mouseX, mouseY);
        if (InputUtil.shouldShowDebugTextBound()) {
            guiGraphics.method_25296(this.leftPageX - 2, this.leftPageY - 2, this.leftPageX + 114 + 2, this.leftPageY + 128 + 2, 0x22000000, 0x22000000);
            guiGraphics.method_25296(this.rightPageX - 2, this.rightPageY - 2, this.rightPageX + 114 + 2, this.rightPageY + 128 + 2, 0x22000000, 0x22000000);
        }
        if (InputUtil.shouldShowDebugVariables()) {
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_25303(this.field_22793, "style under cursor: ", 0, this.field_22790 - 9 * 2, -1);
            String string = this.styleUnderMouseCursor == null ? "<none>" : this.styleUnderMouseCursor.toString();
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_25303(this.field_22793, string, 0, this.field_22790 - 9, -1);
        }
    }

    @Override
    protected class_2960 getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }

    protected void setBookAccess(class_3872.class_3931 bookAccess) {
        this.pages = bookAccess.comp_2438();
        this.ensureEvenPageIndex(Math.clamp((long)this.getCurrentLeftPageIndex(), 0, Math.max(0, bookAccess.method_17560() - 1)));
        this.updateVisibleContents();
    }

    protected void setPageIndex(int index) {
        this.ensureEvenPageIndex(Math.clamp((long)index, 0, Math.max(0, this.getCurrentAmountOfPages() - 1)));
        this.updateVisibleContents();
    }

    private void drawXY(int x, int y, int yoffset, class_332 guiGraphics) {
        String string = String.format(Locale.ROOT, "%s, %s", x, y);
        guiGraphics.method_25303(this.field_22793, string, 0, 0 + yoffset, -1);
    }
}

