/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.screen.BedrockBookViewScreen;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.TogglableSpriteButton;
import games.enchanted.eg_bedrock_books.common.util.InputUtil;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3872;
import net.minecraft.class_3916;
import net.minecraft.class_3936;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;

public class BedrockLecternScreen
extends BedrockBookViewScreen
implements class_3936<class_3916> {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"eg_bedrock_books", (String)"textures/gui/book/lectern_background.png");
    protected static final int FOOTER_BUTTON_WIDTH = 120;
    protected static final int TEXT_OFFSET_LEFT = 7;
    protected static final int TEXT_OFFSET_RIGHT = 7;
    protected static final class_2561 TAKE_BOOK_COMPONENT = class_2561.method_43471((String)"lectern.take_book");
    public static final int RIBBON_WIDTH = 18;
    public static final int RIBBON_TOP_HEIGHT = 11;
    public static final int RIBBON_BOTTOM_HEIGHT = 29;
    public static final int RIBBON_Y_OFFSET = 111;
    class_2561 RIBBON_TOOLTIP = class_2561.method_43471((String)"ui.eg_bedrock_books.lectern.bookmark_tooltip");
    class_2561 LEFT_RIBBON_LABEL = class_2561.method_43471((String)"ui.eg_bedrock_books.lectern.bookmark_left_label");
    protected static final CustomSpriteButton.ButtonConfig LEFT_RIBBON_SELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/left_page_selected_ribbon"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/left_page_selected_ribbon_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/left_page_selected_ribbon_focus"));
    protected static final CustomSpriteButton.ButtonConfig LEFT_RIBBON_UNSELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/left_page_unselected_ribbon"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/left_page_unselected_ribbon_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/left_page_unselected_ribbon_focus"));
    class_2561 RIGHT_RIBBON_LABEL = class_2561.method_43471((String)"ui.eg_bedrock_books.lectern.bookmark_right_label");
    public static final class_2960 RIGHT_RIBBON_SELECTED_SPRITE = class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/right_page_selected_ribbon");
    protected static final CustomSpriteButton.ButtonConfig RIGHT_RIBBON_SELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), RIGHT_RIBBON_SELECTED_SPRITE, class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/right_page_selected_ribbon_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/right_page_selected_ribbon_focus"));
    protected static final CustomSpriteButton.ButtonConfig RIGHT_RIBBON_UNSELECTED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/right_page_unselected_ribbon"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/right_page_unselected_ribbon_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"book/lectern/right_page_unselected_ribbon_focus"));
    private final class_3916 menu;
    private final class_1712 containerListener = new class_1712(){

        public void method_7635(class_1703 menu, int slotIndex, class_1799 stack) {
            BedrockLecternScreen.this.bookDataChanged();
        }

        public void method_7633(class_1703 menu, int slotIndex, int value) {
            if (slotIndex == 0) {
                BedrockLecternScreen.this.pageIndexChanged();
            }
        }
    };
    protected TogglableSpriteButton leftPageRibbon;
    protected TogglableSpriteButton rightPageRibbon;

    public BedrockLecternScreen(class_3916 menu) {
        this.menu = menu;
    }

    @Override
    protected void method_25426() {
        int totalRibbonHeight = 11 + ConfigOptions.RIBBON_HEIGHT.getValue() + 29;
        this.leftPageRibbon = new TogglableSpriteButton(this.field_22789 / 2 - 18, this.field_22790 / 2 - 111, 18, totalRibbonHeight, button -> {
            this.setPageIndex(this.getCurrentLeftPageIndex());
            this.updateVisibleContents();
        }, this.LEFT_RIBBON_LABEL, LEFT_RIBBON_UNSELECTED_CONFIG, LEFT_RIBBON_SELECTED_CONFIG);
        this.leftPageRibbon.method_47400(class_7919.method_47407((class_2561)this.RIBBON_TOOLTIP));
        this.rightPageRibbon = new TogglableSpriteButton(this.field_22789 / 2, this.field_22790 / 2 - 111, 18, totalRibbonHeight, button -> {
            this.setPageIndex(this.getCurrentLeftPageIndex() + 1);
            this.updateVisibleContents();
        }, this.RIGHT_RIBBON_LABEL, RIGHT_RIBBON_UNSELECTED_CONFIG, RIGHT_RIBBON_SELECTED_CONFIG);
        this.rightPageRibbon.method_47400(class_7919.method_47407((class_2561)this.RIBBON_TOOLTIP));
        super.method_25426();
        this.menu.method_7596(this.containerListener);
    }

    @Override
    protected void addWidgetsBetweenPages() {
        super.addWidgetsBetweenPages();
        this.method_37063((class_364)this.leftPageRibbon);
        this.method_37063((class_364)this.rightPageRibbon);
    }

    @Override
    protected void makeFooterButtons() {
        this.footerButtonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(120).method_46431());
        this.footerButtonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)TAKE_BOOK_COMPONENT, button -> this.sendContainerButtonClick(3)).method_46432(120).method_46431());
        this.footerButtonLayout.method_48229(this.field_22789 / 2 - 124, this.field_22790 / 2 + 90);
    }

    @Override
    protected int getHorizontalLeftPageTextOffset() {
        return 7;
    }

    @Override
    protected int getHorizontalRightPageTextOffset() {
        return 7;
    }

    @Override
    protected void updateVisibleContents() {
        boolean morePagesAfterLeft;
        super.updateVisibleContents();
        if (this.isContainerOnLeftPage()) {
            this.leftPageRibbon.setToggle(true);
            this.rightPageRibbon.setToggle(false);
            this.turnRightButton.field_22764 = this.getContainerPageIndex() < this.getCurrentAmountOfPages() - 1;
        } else {
            this.leftPageRibbon.setToggle(false);
            this.rightPageRibbon.setToggle(true);
            this.turnLeftButton.field_22764 = true;
        }
        this.rightPageRibbon.field_22764 = morePagesAfterLeft = this.getCurrentLeftPageIndex() < this.getCurrentAmountOfPages() - 1;
        this.leftPageRibbon.field_22764 = !this.pages.isEmpty();
    }

    @Override
    protected void turnForwardPage() {
        if (this.isContainerOnLeftPage()) {
            if (this.getContainerPageIndex() > this.getCurrentAmountOfPages() - 1) {
                return;
            }
            this.setContainerPageIndex(this.getCurrentLeftPageIndex() + 1);
            this.updateVisibleContents();
        } else {
            super.turnForwardPage();
            this.setContainerPageIndex(this.getCurrentLeftPageIndex());
        }
    }

    @Override
    protected void turnBackPage() {
        if (this.isContainerOnLeftPage()) {
            this.setContainerPageIndex(this.getCurrentLeftPageIndex() - 1);
            super.turnBackPage();
        } else {
            if (this.getContainerPageIndex() <= 0) {
                return;
            }
            this.setContainerPageIndex(this.getCurrentLeftPageIndex());
            this.updateVisibleContents();
        }
    }

    protected boolean isContainerOnLeftPage() {
        return this.getCurrentLeftPageIndex() == this.getContainerPageIndex();
    }

    @Override
    protected void setPageIndex(int index) {
        super.setPageIndex(index);
        this.setContainerPageIndex(index);
    }

    protected void setContainerPageIndex(int index) {
        if (index != this.menu.method_17419()) {
            this.sendContainerButtonClick(100 + index);
        }
    }

    protected int getContainerPageIndex() {
        return this.menu.method_17419();
    }

    protected void bookDataChanged() {
        this.setBookAccess(Objects.requireNonNullElse(class_3872.class_3931.method_17562((class_1799)this.menu.method_17418()), class_3872.field_17417));
    }

    protected void pageIndexChanged() {
        this.setPageIndex(this.menu.method_17419());
    }

    protected void sendContainerButtonClick(int buttonId) {
        Objects.requireNonNull(this.field_22787, "this.minecraft is null");
        Objects.requireNonNull(this.field_22787.field_1761, "this.minecraft.gameMode is null");
        this.field_22787.field_1761.method_2900(this.menu.field_7763, buttonId);
    }

    public void method_25419() {
        super.method_25419();
        this.closeServerContainer();
    }

    public void method_25432() {
        super.method_25432();
        this.menu.method_7603(this.containerListener);
    }

    @Override
    protected void closeServerContainer() {
        Objects.requireNonNull(this.field_22787, "this.minecraft is null");
        Objects.requireNonNull(this.field_22787.field_1724, "this.minecraft.player is null");
        this.field_22787.field_1724.method_7346();
    }

    @NotNull
    public class_3916 getMenu() {
        return this.menu;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    protected class_2960 getBackgroundTexture() {
        return BACKGROUND_TEXTURE;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (InputUtil.shouldShowDebugContainerData()) {
            guiGraphics.method_25303(this.field_22793, "containerIndex: " + this.menu.method_17419(), 0, 64, -1);
        }
    }
}

