/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_bedrock_books.common.screen.config;

import games.enchanted.eg_bedrock_books.common.config.ConfigOptions;
import games.enchanted.eg_bedrock_books.common.config.option.ConfigOption;
import games.enchanted.eg_bedrock_books.common.screen.AbstractBedrockBookScreen;
import games.enchanted.eg_bedrock_books.common.screen.BedrockLecternScreen;
import games.enchanted.eg_bedrock_books.common.screen.config.ConfigScreenBehaviour;
import games.enchanted.eg_bedrock_books.common.screen.widget.CustomSpriteButton;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.CheckBox;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.IntegerSlider;
import games.enchanted.eg_bedrock_books.common.screen.widget.config.KeyBox;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public class ConfigScreenVisual
extends ConfigScreenBehaviour {
    protected static final int MAX_LAYOUT_WIDTH = 120;
    protected static final int MAX_LAYOUT_HEIGHT = 140;
    protected static final int CENTER_PADDING = 24;
    protected static final int COLUMN_GAP = 4;
    protected static final int ROW_GAP = 5;
    protected static final int PAGE_TEXT_COLOUR = -6785961;
    public static final CustomSpriteButton.ButtonConfig CHECKBOX_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/checkbox_unchecked"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/checkbox_unchecked_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/checkbox_unchecked_focus"));
    public static final CustomSpriteButton.ButtonConfig CHECKBOX_UNCHECKED_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/checkbox_checked"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/checkbox_checked_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/checkbox_checked_focus"));
    public static class_2960 SLIDER_BACKGROUND_SPRITE = class_2960.method_60655((String)"eg_bedrock_books", (String)"config/slider_background");
    public static final CustomSpriteButton.ButtonConfig SLIDER_HANDLE_CONFIG = new CustomSpriteButton.ButtonConfig(() -> class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/slider_handle"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/slider_handle_hover"), class_2960.method_60655((String)"eg_bedrock_books", (String)"config/slider_handle_focus"));
    protected static final List<ConfigOption<Boolean>> DEBUG_OPTIONS = List.of(ConfigOptions.DEBUG_WIDGET_BOUNDS, ConfigOptions.DEBUG_TEXT_BOUNDS, ConfigOptions.DEBUG_CONTAINER_DATA, ConfigOptions.DEBUG_VARIABLES);
    protected class_7845 generalGridLayout;
    protected class_7845 visualGridLayout;
    protected class_7845 debugGridLayout;

    protected ConfigScreenVisual(@Nullable class_437 returnScreen, boolean alwaysBlurBackground) {
        super(returnScreen, alwaysBlurBackground);
    }

    protected ConfigScreenVisual(@Nullable class_437 returnScreen) {
        super(returnScreen, false);
    }

    @Override
    protected void addWidgetsBetweenPages() {
        super.addWidgetsBetweenPages();
        this.generalGridLayout = this.createPageLayout(AbstractBedrockBookScreen.PageSide.LEFT);
        this.visualGridLayout = this.createPageLayout(AbstractBedrockBookScreen.PageSide.RIGHT);
        this.debugGridLayout = this.createPageLayout(AbstractBedrockBookScreen.PageSide.LEFT);
        class_2561 closeOnCommandRun = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.close_when_running_command");
        CheckBox closeOnCommandRunWidget = new CheckBox(0, 0, ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND.getPendingOrCurrentValue(), ConfigOptions.CLOSE_BOOK_WHEN_RUNNING_COMMAND::setPendingValue, closeOnCommandRun, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG);
        closeOnCommandRunWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"ui.eg_bedrock_books.config.option.close_when_running_command.tooltip")));
        this.addLabeledOptionToLayout((class_339)closeOnCommandRunWidget, closeOnCommandRun, this.generalGridLayout, 0, 1);
        class_2561 turnForwardPageLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.key.turn_forward_page");
        this.addLabeledOptionToLayout((class_339)new KeyBox(0, 0, ConfigOptions.MOVE_FORWARD_PAGE_KEY.getPendingOrCurrentValue(), ConfigOptions.MOVE_FORWARD_PAGE_KEY::setPendingValue, turnForwardPageLabel), turnForwardPageLabel, this.generalGridLayout, 1, 1);
        class_2561 turnBackwardPageLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.key.turn_backward_page");
        this.addLabeledOptionToLayout((class_339)new KeyBox(0, 0, ConfigOptions.MOVE_BACKWARD_PAGE_KEY.getPendingOrCurrentValue(), ConfigOptions.MOVE_BACKWARD_PAGE_KEY::setPendingValue, turnBackwardPageLabel), turnBackwardPageLabel, this.generalGridLayout, 2, 1);
        class_2561 vanillaScreenKeybindEnabledLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.open_vanilla_screen_key");
        class_7919 vanillaScreenKeyTooltip = class_7919.method_47407((class_2561)class_2561.method_43471((String)"ui.eg_bedrock_books.config.key.open_vanilla_screen_key.tooltip"));
        CheckBox vanillaScreenKeyEnabledWidget = new CheckBox(0, 0, ConfigOptions.VANILLA_BOOK_KEY_ENABLED.getPendingOrCurrentValue(), ConfigOptions.VANILLA_BOOK_KEY_ENABLED::setPendingValue, vanillaScreenKeybindEnabledLabel, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG);
        vanillaScreenKeyEnabledWidget.method_47400(vanillaScreenKeyTooltip);
        this.addLabeledOptionToLayout((class_339)vanillaScreenKeyEnabledWidget, vanillaScreenKeybindEnabledLabel, this.generalGridLayout, 3, 1);
        class_2561 vanillaScreenKeyLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.key.open_vanilla_screen_key");
        KeyBox vanillaScreenKeyInput = new KeyBox(0, 0, ConfigOptions.VANILLA_BOOK_KEY.getPendingOrCurrentValue(), ConfigOptions.VANILLA_BOOK_KEY::setPendingValue, vanillaScreenKeyLabel);
        vanillaScreenKeyInput.method_47400(vanillaScreenKeyTooltip);
        this.addLabeledOptionToLayout((class_339)vanillaScreenKeyInput, vanillaScreenKeyLabel, this.generalGridLayout, 4, 1);
        class_2561 showXButtonLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.show_x_button");
        this.addLabeledOptionToLayout((class_339)new CheckBox(0, 0, ConfigOptions.SHOW_X_BUTTON.getPendingOrCurrentValue(), value -> {
            ConfigOptions.SHOW_X_BUTTON.setPendingValue(value);
            this.xButton.field_22764 = value;
        }, showXButtonLabel, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG), showXButtonLabel, this.visualGridLayout, 0, 1);
        class_2561 ribbonHeightLabel = this.translatableComponentForPage("ui.eg_bedrock_books.config.option.ribbon_height");
        this.addStackedLabeledOptionToLayout((class_339)new IntegerSlider(0, 0, 120, 16, ribbonHeightLabel, ConfigOptions.RIBBON_HEIGHT.getPendingOrCurrentValue(), ConfigOptions.RIBBON_HEIGHT::setPendingValue, 0, 130, SLIDER_BACKGROUND_SPRITE, SLIDER_HANDLE_CONFIG), ribbonHeightLabel, this.visualGridLayout, 1, 1);
        for (int i = 0; i < DEBUG_OPTIONS.size(); ++i) {
            ConfigOption<Boolean> option = DEBUG_OPTIONS.get(i);
            class_2561 optionLabel = this.literalComponentForPage(option.getJsonKey());
            this.addLabeledOptionToLayout((class_339)new CheckBox(0, 0, option.getPendingOrCurrentValue(), option::setPendingValue, optionLabel, CHECKBOX_CONFIG, CHECKBOX_UNCHECKED_CONFIG), optionLabel, this.debugGridLayout, i, 1);
        }
        this.generalGridLayout.method_48222();
        this.visualGridLayout.method_48222();
        this.debugGridLayout.method_48222();
    }

    protected class_2561 translatableComponentForPage(String translationKey) {
        return class_2561.method_43471((String)translationKey).method_27696(class_2583.field_24360.method_36139(-6785961).method_65302(0));
    }

    protected class_2561 literalComponentForPage(String literal) {
        return class_2561.method_43470((String)literal).method_27696(class_2583.field_24360.method_36139(-6785961).method_65302(0));
    }

    protected class_7845 createPageLayout(AbstractBedrockBookScreen.PageSide side) {
        int x = side == AbstractBedrockBookScreen.PageSide.LEFT ? this.field_22789 / 2 - 12 - 120 : this.field_22789 / 2 + 12 + 4;
        int y = this.field_22790 / 2 - 140 + 55;
        class_7845 layout = new class_7845(x, y);
        layout.method_48635(4);
        layout.method_46458().method_46472();
        return layout;
    }

    protected void addLabeledOptionToLayout(class_339 widget, class_2561 label, class_7845 layout, int rowIndex, int occupiedRows) {
        class_7940 textWidget = new class_7940(label, class_310.method_1551().field_1772);
        textWidget.method_48984(Math.abs(widget.method_25368() - 120) - 4);
        class_7843 frameLayout = new class_7843(120, Math.max(textWidget.method_25364(), widget.method_25364()) + 5);
        frameLayout.method_46449(120);
        frameLayout.method_46450().method_46474();
        frameLayout.method_48229(layout.method_46426(), layout.method_46427());
        frameLayout.method_52732((class_8021)textWidget, class_7847::method_46461);
        frameLayout.method_52732((class_8021)widget, class_7847::method_46470);
        this.addFrameToLayout(frameLayout, layout, rowIndex, occupiedRows);
    }

    protected void addStackedLabeledOptionToLayout(class_339 widget, class_2561 label, class_7845 layout, int rowIndex, int occupiedRows) {
        class_7940 textWidget = new class_7940(label, class_310.method_1551().field_1772);
        textWidget.method_48984(120);
        class_7843 frameLayout = new class_7843(120, textWidget.method_25364() + widget.method_25364() + 5);
        frameLayout.method_46449(120);
        frameLayout.method_46447(textWidget.method_25364() + widget.method_25364());
        frameLayout.method_46450().method_46461();
        frameLayout.method_48229(layout.method_46426(), layout.method_46427());
        frameLayout.method_52732((class_8021)textWidget, class_7847::method_46472);
        frameLayout.method_52732((class_8021)widget, class_7847::method_46476);
        this.addFrameToLayout(frameLayout, layout, rowIndex, occupiedRows);
    }

    protected void addFrameToLayout(class_7843 frameLayout, class_7845 layout, int rowIndex, int occupiedRows) {
        layout.method_52733((class_8021)frameLayout, rowIndex, 0, occupiedRows, 1, class_7847::method_46461);
        frameLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.getCurrentLeftPageIndex() == 0) {
            guiGraphics.method_52706(class_10799.field_56883, BedrockLecternScreen.RIGHT_RIBBON_SELECTED_SPRITE, this.field_22789 / 2, this.field_22790 / 2 - 111, 18, 11 + ConfigOptions.RIBBON_HEIGHT.getPendingOrCurrentValue() + 29);
        }
    }

    @Override
    protected class_2561 getPageIndicatorMessage(int index) {
        return switch (index) {
            case 0 -> class_2561.method_43471((String)"ui.eg_bedrock_books.config.page.general");
            case 1 -> class_2561.method_43471((String)"ui.eg_bedrock_books.config.page.visual");
            case 2 -> class_2561.method_43471((String)"ui.eg_bedrock_books.config.page.debug");
            default -> super.getPageIndicatorMessage(index);
        };
    }

    @Override
    protected void updateVisibleContents() {
        super.updateVisibleContents();
        if (this.getCurrentLeftPageIndex() == 0) {
            this.generalGridLayout.method_48206(widget -> {
                widget.field_22764 = true;
            });
            this.visualGridLayout.method_48206(widget -> {
                widget.field_22764 = true;
            });
            this.debugGridLayout.method_48206(widget -> {
                widget.field_22764 = false;
            });
        } else {
            this.generalGridLayout.method_48206(widget -> {
                widget.field_22764 = false;
            });
            this.visualGridLayout.method_48206(widget -> {
                widget.field_22764 = false;
            });
            this.debugGridLayout.method_48206(widget -> {
                widget.field_22764 = true;
            });
        }
    }
}

