/*
 * Decompiled with CFR 0.152.
 */
package me.drex.votelistener;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.vexsoftware.votifier.model.Vote;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.drex.vanish.api.VanishAPI;
import me.drex.votelistener.command.Commands;
import me.drex.votelistener.config.ConfigManager;
import me.drex.votelistener.data.PlayerVoteData;
import me.drex.votelistener.data.VoteData;
import me.drex.votelistener.util.VotePlaceholders;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoteListener
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "votelistener";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"votelistener");
    public static final boolean VANISH_PRESENT = FabricLoader.getInstance().isModLoaded("melius-vanish");
    public static final Codec<Vote> VOTE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("serviceName").forGetter(Vote::getServiceName), (App)Codec.STRING.fieldOf("username").forGetter(Vote::getUsername), (App)Codec.STRING.fieldOf("address").forGetter(Vote::getAddress), (App)Codec.STRING.fieldOf("timeStamp").forGetter(Vote::getTimeStamp)).apply((Applicative)instance, Vote::new));
    private static MinecraftServer server;
    public static VoteData voteData;

    public void onInitializeServer() {
        if (!ConfigManager.loadConfig()) {
            throw new IllegalStateException("Failed to load config, please fix your config file!");
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            VoteListener.loadData(server);
            VoteListener.server = server;
        });
        ServerLifecycleEvents.AFTER_SAVE.register((server, flush, force) -> VoteListener.saveData(server));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> Commands.register((CommandDispatcher<class_2168>)dispatcher));
        ServerTickEvents.START_SERVER_TICK.register(VoteListener::onTick);
        com.vexsoftware.votifier.fabric.event.VoteListener.EVENT.register(VoteListener::onVote);
        VotePlaceholders.register();
    }

    private static void onVote(Vote vote) {
        class_11561 userNameToIdResolver = server.method_73550().comp_4407();
        class_156.method_55473().execute(() -> {
            Optional optional = userNameToIdResolver.method_14515(vote.getUsername());
            optional.ifPresentOrElse(nameAndId -> server.method_20493(() -> VoteListener.onVote(vote, nameAndId)), () -> LOGGER.info("Unknown player name \"{}\", discarding vote.", (Object)vote.getUsername()));
        });
    }

    private static void onVote(Vote vote, class_11560 nameAndId) {
        voteData.onVote(vote, nameAndId);
        for (String command : ConfigManager.CONFIG.commands) {
            server.method_3734().method_44252(server.method_3739(), VoteListener.formatCommand(vote, nameAndId, command));
        }
    }

    private static void onTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            PlayerVoteData playerVoteData;
            if (VANISH_PRESENT && VanishAPI.isVanished((class_1297)player) || (playerVoteData = voteData.players().get(player.method_5667())) == null) continue;
            for (Vote vote : playerVoteData.unprocessedVotes()) {
                for (String command : ConfigManager.CONFIG.onlineCommands) {
                    VoteListener.performCommand(server, player, vote, command);
                }
                int voteCount = playerVoteData.votes().indexOf(vote) + 1;
                List<String> milestoneCommands = ConfigManager.CONFIG.milestones.get(voteCount);
                if (milestoneCommands == null) continue;
                for (String command : milestoneCommands) {
                    VoteListener.performCommand(server, player, vote, command);
                }
            }
            playerVoteData.unprocessedVotes().clear();
        }
    }

    private static void performCommand(MinecraftServer server, class_3222 player, Vote vote, String command) {
        server.method_3734().method_44252(server.method_3739().method_9232((class_1297)player).method_9217(), VoteListener.formatCommand(vote, player.method_72498(), command));
    }

    private static void loadData(MinecraftServer server) {
        Path path = server.method_27050(class_5218.field_24188).resolve("votes.dat");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                class_2487 compoundTag = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
                DataResult dataResult = VoteData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag);
                voteData = (VoteData)dataResult.getOrThrow(RuntimeException::new);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            voteData = new VoteData(new HashMap<UUID, PlayerVoteData>());
        }
    }

    public static void saveData(MinecraftServer server) {
        Path path = server.method_27050(class_5218.field_24188).resolve("votes.dat");
        DataResult dataResult = VoteData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)voteData);
        Optional optional = dataResult.resultOrPartial(error -> LOGGER.error("Failed to encode vote data, data will get lost: {}", error));
        optional.ifPresent(tag -> {
            try {
                class_2507.method_30614((class_2487)((class_2487)tag), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save vote data, data will get lost", (Throwable)e);
            }
        });
    }

    private static String formatCommand(Vote vote, class_11560 nameAndId, String command) {
        return command.replace("${uuid}", nameAndId.comp_4422().toString()).replace("${username}", nameAndId.comp_4423()).replace("${serviceName}", vote.getServiceName()).replace("${address}", vote.getAddress()).replace("${timeStamp}", vote.getTimeStamp());
    }
}

