/*
 * Decompiled with CFR 0.152.
 */
package me.drex.votelistener.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.drex.votelistener.VoteListener;
import me.drex.votelistener.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    public static Config CONFIG = null;
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setLenient().create();

    public static boolean loadConfig() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path configFilePath = configDir.resolve("%s.json".formatted("votelistener"));
        if (Files.notExists(configFilePath, new LinkOption[0])) {
            CONFIG = new Config();
            String json = GSON.toJson((Object)CONFIG);
            try {
                Files.writeString(configFilePath, (CharSequence)json, new OpenOption[0]);
                return true;
            }
            catch (IOException e) {
                VoteListener.LOGGER.error("Failed to write default config...", (Throwable)e);
                return false;
            }
        }
        try {
            CONFIG = (Config)GSON.fromJson(Files.readString(configFilePath), Config.class);
            return true;
        }
        catch (IOException e) {
            VoteListener.LOGGER.error("Failed to load config, using default options", (Throwable)e);
            CONFIG = new Config();
            return false;
        }
    }
}

