/*
 * Decompiled with CFR 0.152.
 */
package me.drex.votelistener.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.vexsoftware.votifier.model.Vote;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import me.drex.votelistener.VoteListener;
import me.drex.votelistener.data.VoteData;

public final class PlayerVoteData {
    public static final Codec<PlayerVoteData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VoteListener.VOTE_CODEC.listOf().fieldOf("votes").forGetter(PlayerVoteData::votes), (App)VoteListener.VOTE_CODEC.listOf().fieldOf("unprocessedVotes").forGetter(PlayerVoteData::unprocessedVotes)).apply((Applicative)instance, (votes, unprocessedVotes) -> new PlayerVoteData(new LinkedList<Vote>((Collection<Vote>)votes), new LinkedList<Vote>((Collection<Vote>)unprocessedVotes))));
    private final List<Vote> votes;
    private final List<Vote> unprocessedVotes;

    public PlayerVoteData(List<Vote> votes, List<Vote> unprocessedVotes) {
        this.votes = votes;
        this.votes.sort(VoteData.TIME_COMPARATOR);
        this.unprocessedVotes = unprocessedVotes;
    }

    public void onVote(Vote vote) {
        this.votes.add(vote);
        this.unprocessedVotes.add(vote);
    }

    public List<Vote> votesByTime(Duration duration) {
        return VoteData.binarySearchVotesByTime(this.votes, duration.toMillis());
    }

    public List<Vote> votes() {
        return this.votes;
    }

    public List<Vote> unprocessedVotes() {
        return this.unprocessedVotes;
    }
}

