/*
 * Decompiled with CFR 0.152.
 */
package me.drex.votelistener.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.vexsoftware.votifier.model.Vote;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.drex.votelistener.VoteListener;
import me.drex.votelistener.data.PlayerVoteData;
import net.minecraft.class_11560;
import net.minecraft.class_4844;

public final class VoteData {
    public static final Codec<VoteData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_41525, PlayerVoteData.CODEC).fieldOf("players").forGetter(VoteData::players)).apply((Applicative)instance, players -> new VoteData(new HashMap<UUID, PlayerVoteData>((Map<UUID, PlayerVoteData>)players))));
    public static final Comparator<Vote> TIME_COMPARATOR = Comparator.comparing(VoteData::getTimeStamp);
    private final Map<UUID, PlayerVoteData> players;
    private final ArrayList<Vote> votesByTime = new ArrayList();

    public VoteData(Map<UUID, PlayerVoteData> players) {
        this.players = players;
        players.forEach((key, value) -> this.votesByTime.addAll(value.votes()));
        this.votesByTime.sort(TIME_COMPARATOR);
    }

    public void onVote(Vote vote, class_11560 nameAndId) {
        PlayerVoteData playerVoteData = this.players.computeIfAbsent(nameAndId.comp_4422(), uuid -> new PlayerVoteData(new LinkedList<Vote>(), new LinkedList<Vote>()));
        playerVoteData.onVote(vote);
        this.votesByTime.add(vote);
    }

    public Map<UUID, PlayerVoteData> players() {
        return this.players;
    }

    static List<Vote> binarySearchVotesByTime(List<Vote> votesByTime, long minUnixMS) {
        int low = 0;
        int high = votesByTime.size();
        while (low < high) {
            int mid = low + (high - low) / 2;
            if (minUnixMS <= VoteData.getTimeStamp(votesByTime.get(mid))) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        if (low < votesByTime.size() && VoteData.getTimeStamp(votesByTime.get(low)) < minUnixMS) {
            ++low;
        }
        return votesByTime.subList(low, votesByTime.size());
    }

    public List<Vote> votesByTime(Duration duration) {
        return VoteData.binarySearchVotesByTime(this.votesByTime, duration.toMillis());
    }

    public static long getTimeStamp(Vote vote) {
        String timeStamp = vote.getTimeStamp();
        try {
            return Long.parseLong(timeStamp);
        }
        catch (NumberFormatException e) {
            VoteListener.LOGGER.error("Failed to convert vote timestamp", (Throwable)e);
            return 0L;
        }
    }
}

