/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class ModConfig {
    private static final Path CONFIG_FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("camera-obscura.json");
    private static ModConfig instance;
    private static final Gson gson;
    public int renderDistance = 128;
    public boolean showSystemMessages = false;
    public boolean renderEntities = false;
    public int renderEntitiesAmount = 20;
    public boolean fullbright = false;
    public int fov = 70;
    public int biomeBlend = 1;
    public class_2960 cameraItem = class_2960.method_60656((String)"spyglass");
    public boolean cameraConsumesItem = true;
    public class_2960 cameraConsumeItem = class_2960.method_60656((String)"map");
    public int commandPermissionLevel = 2;

    public static ModConfig getInstance() {
        if (instance == null && !ModConfig.load()) {
            ModConfig.save();
        }
        return instance;
    }

    public static boolean load() {
        if (!CONFIG_FILE_PATH.toFile().exists()) {
            instance = new ModConfig();
            try {
                if (CONFIG_FILE_PATH.toFile().createNewFile()) {
                    FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());
                    stream.write(gson.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        try {
            instance = (ModConfig)gson.fromJson((Reader)new FileReader(CONFIG_FILE_PATH.toFile()), ModConfig.class);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private static void save() {
        try {
            FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());
            stream.write(gson.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        gson = new GsonBuilder().registerTypeHierarchyAdapter(class_2960.class, (Object)new CachedResourceLocationDeserializer()).setPrettyPrinting().create();
    }
}

