/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextManager;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class Permissions {
    static boolean loaded = FabricLoader.getInstance().isModLoaded("luckperms");

    public static boolean check(class_3222 player, String node, int defaultCheck) {
        return loaded && Permissions.hasLuckPermsPermission(player, node) || player.method_64475(defaultCheck);
    }

    public static Predicate<class_2168> require(String node, int fallbackLevel) {
        return source -> {
            try {
                return Permissions.check(source.method_9207(), node, fallbackLevel);
            }
            catch (CommandSyntaxException e) {
                return source.method_9259(fallbackLevel);
            }
        };
    }

    private static boolean hasLuckPermsPermission(class_3222 player, String node) {
        User user = LuckPermsProvider.get().getUserManager().getUser(player.method_5667());
        if (user == null) {
            return false;
        }
        ContextManager contextManager = LuckPermsProvider.get().getContextManager();
        QueryOptions options = contextManager.getQueryOptions(user).orElse(contextManager.getStaticQueryOptions());
        return user.getCachedData().getPermissionData(options).checkPermission(node).asBoolean();
    }
}

