/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import de.tomalbrc.cameraobscura.ModConfig;
import de.tomalbrc.cameraobscura.Permissions;
import de.tomalbrc.cameraobscura.render.renderer.BufferedImageRenderer;
import de.tomalbrc.cameraobscura.render.renderer.CanvasImageRenderer;
import de.tomalbrc.cameraobscura.util.RPHelper;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9209;
import net.minecraft.class_9334;

public class CameraCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder camera_obscura = (LiteralArgumentBuilder)class_2170.method_9247((String)"camera-obscura").requires(Permissions.require("camera-obscura.command", 2));
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)camera_obscura.executes(CameraCommand::createMapOfSourceForSource)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).requires(Permissions.require("camera-obscura.command.scale", ModConfig.getInstance().commandPermissionLevel))).executes(CameraCommand::createMapOfSourceScaled))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"source", (ArgumentType)class_2186.method_9309()).requires(Permissions.require("camera-obscura.command.type", 2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(CameraCommand::createMapOfSourceForSource)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).requires(Permissions.require("camera-obscura.command.type.scale", ModConfig.getInstance().commandPermissionLevel))).executes(CameraCommand::createMapOfSourceForSourceScaled))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(Permissions.require("camera-obscura.command.save", ModConfig.getInstance().commandPermissionLevel))).executes(x -> {
            class_1297 patt0$temp = ((class_2168)x.getSource()).method_9228();
            if (patt0$temp instanceof class_1309) {
                class_1309 livingEntity = (class_1309)patt0$temp;
                CameraCommand.createImageAsync((CommandContext<class_2168>)x, livingEntity, 1);
            }
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"source", (ArgumentType)class_2186.method_9309()).requires(Permissions.require("camera-obscura.command.save.type", ModConfig.getInstance().commandPermissionLevel))).executes(x -> CameraCommand.createImageFromSource((CommandContext<class_2168>)x, 1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).requires(Permissions.require("camera-obscura.command.save.type.scale", ModConfig.getInstance().commandPermissionLevel))).executes(x -> CameraCommand.createImageFromSource((CommandContext<class_2168>)x, IntegerArgumentType.getInteger((CommandContext)x, (String)"scale")))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).requires(Permissions.require("camera-obscura.command.save.scale", ModConfig.getInstance().commandPermissionLevel))).executes(x -> {
            class_1297 patt0$temp = ((class_2168)x.getSource()).method_9228();
            if (patt0$temp instanceof class_1309) {
                class_1309 livingEntity = (class_1309)patt0$temp;
                CameraCommand.createImageAsync((CommandContext<class_2168>)x, livingEntity, IntegerArgumentType.getInteger((CommandContext)x, (String)"scale"));
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear-cache").requires(Permissions.require("camera-obscura.command.clear-cache", 2))).executes(x -> {
            RPHelper.clearCache();
            return 0;
        }))).build();
        dispatcher.getRoot().addChild((CommandNode)node);
    }

    private static int createImageFromSource(CommandContext<class_2168> x, int scale) throws CommandSyntaxException {
        class_1297 source = class_2186.method_9313(x, (String)"source");
        if (source instanceof class_1309) {
            class_1309 livingEntity = (class_1309)source;
            CameraCommand.createImageAsync(x, livingEntity, scale);
        }
        return 0;
    }

    private static int createMapOfSourceScaled(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_44023() == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Needs to be executed as player!"));
        }
        int scale = IntegerArgumentType.getInteger(context, (String)"scale");
        return CameraCommand.createMap(context, (class_1309)((class_2168)context.getSource()).method_44023(), (class_1657)((class_2168)context.getSource()).method_44023(), scale);
    }

    private static int createMapOfSourceForSourceScaled(CommandContext<class_2168> context) {
        class_3222 player;
        class_1297 source;
        if (((class_2168)context.getSource()).method_44023() == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Needs to be executed as player!"));
        }
        int scale = IntegerArgumentType.getInteger(context, (String)"scale");
        try {
            source = class_2186.method_9313(context, (String)"source");
            player = class_2186.method_9315(context, (String)"player");
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (source instanceof class_1309) {
            class_1309 livingEntity = (class_1309)source;
            return CameraCommand.createMap(context, livingEntity, (class_1657)player, scale);
        }
        return 0;
    }

    private static int createMapOfSourceForSource(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_44023() == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Needs to be executed as player!"));
        }
        return CameraCommand.createMap(context, (class_1309)((class_2168)context.getSource()).method_44023(), (class_1657)((class_2168)context.getSource()).method_44023(), 1);
    }

    private static int createMap(CommandContext<class_2168> context, class_1309 entity, class_1657 player, int scale) {
        class_2168 source = (class_2168)context.getSource();
        if (ModConfig.getInstance().showSystemMessages) {
            source.method_9226(() -> class_2561.method_43470((String)"Taking photo..."), false);
        }
        long startTime = System.nanoTime();
        int size = 128 * scale;
        CanvasImageRenderer renderer = new CanvasImageRenderer(entity, size, size, ModConfig.getInstance().renderDistance);
        CompletableFuture.supplyAsync(() -> {
            try {
                return renderer.render();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).thenAcceptAsync(mapImage -> CameraCommand.finalize(player, mapImage, source, startTime), (Executor)source.method_9211());
        return 1;
    }

    private static void finalize(class_1657 player, CanvasImage mapImage, class_2168 source, long startTime) {
        if (mapImage != null) {
            source.method_9226(() -> class_2561.method_43470((String)"Took a photo!"), false);
            List<class_1799> items = CameraCommand.mapItems(mapImage, source.method_9225());
            if (player != null) {
                items.forEach(arg_0 -> ((class_1657)player).method_7270(arg_0));
            } else if (source.method_44023() != null) {
                items.forEach(arg_0 -> ((class_3222)source.method_44023()).method_7270(arg_0));
            }
            if (ModConfig.getInstance().showSystemMessages) {
                long durationInMillis = (System.nanoTime() - startTime) / 1000000L;
                long millis = durationInMillis % 1000L;
                long secs = durationInMillis / 1000L;
                String time = secs > 0L ? String.format("%ds %dms", secs, millis) : String.format("%dms", millis);
                source.method_9226(() -> class_2561.method_43470((String)("Done! (" + time + ")")), false);
            }
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Something went wrong while trying to take a photo!").method_54663(-65536));
        }
    }

    public static List<class_1799> mapItems(CanvasImage image, class_3218 level) {
        int xSections = class_3532.method_15384((double)((double)image.getWidth() / 128.0));
        int ySections = class_3532.method_15384((double)((double)image.getHeight() / 128.0));
        int xDelta = (xSections * 128 - image.getWidth()) / 2;
        int yDelta = (ySections * 128 - image.getHeight()) / 2;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int ys = 0; ys < ySections; ++ys) {
            for (int xs = 0; xs < xSections; ++xs) {
                class_9209 id = level.method_17889();
                class_22 state = class_22.method_32363((double)0.0, (double)0.0, (byte)0, (boolean)false, (boolean)false, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"camera-obscura", (String)"generated")));
                for (int xl = 0; xl < 128; ++xl) {
                    for (int yl = 0; yl < 128; ++yl) {
                        int x = xl + xs * 128 - xDelta;
                        int y = yl + ys * 128 - yDelta;
                        if (x < 0 || y < 0 || x >= image.getWidth() || y >= image.getHeight()) continue;
                        state.field_122[xl + yl * 128] = image.getRaw(x, y);
                    }
                }
                level.method_17890(id, state);
                class_1799 stack = new class_1799((class_1935)class_1802.field_8204);
                stack.method_57379(class_9334.field_49646, (Object)id);
                items.add(stack);
            }
        }
        return items;
    }

    private static void createImageAsync(CommandContext<class_2168> context, class_1309 entity, int scale) {
        class_2168 source = (class_2168)context.getSource();
        if (ModConfig.getInstance().showSystemMessages) {
            source.method_9226(() -> class_2561.method_43470((String)"Taking photo..."), false);
        }
        BufferedImageRenderer renderer = new BufferedImageRenderer(entity, 128 * scale, 128 * scale, ModConfig.getInstance().renderDistance);
        long startTime = System.nanoTime();
        CompletableFuture.supplyAsync(renderer::render).thenAcceptAsync(mapImage -> CameraCommand.finalizeImage(mapImage, startTime, source), (Executor)source.method_9211());
    }

    private static void finalizeImage(BufferedImage mapImage, long startTime, class_2168 source) {
        Path rendersDir = FabricLoader.getInstance().getGameDir().resolve("renders").toAbsolutePath();
        File f = rendersDir.toFile();
        if (!f.exists() && !f.mkdir()) {
            return;
        }
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH).format(new Date());
        File file = rendersDir.resolve(date + ".png").toFile();
        try {
            ImageIO.write((RenderedImage)mapImage, "PNG", file);
            if (ModConfig.getInstance().showSystemMessages) {
                long durationInMillis = (System.nanoTime() - startTime) / 1000000L;
                long millis = durationInMillis % 1000L;
                long secs = durationInMillis / 1000L;
                String time = secs > 0L ? String.format("%ds %dms", secs, millis) : String.format("%dms", millis);
                source.method_9226(() -> class_2561.method_43470((String)("Done! (" + time + ")")), false);
            }
        }
        catch (IOException e) {
            LogUtils.getLogger().error("Could not write image to " + file.getPath());
        }
    }
}

