/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render.model.resource;

import com.google.gson.annotations.SerializedName;
import java.util.Map;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class RPElement {
    public Vector3f from;
    public Vector3f to;
    public Rotation rotation;
    public Map<String, TextureInfo> faces;
    public String name;
    public boolean shade = true;
    public transient boolean light = true;

    public static class Rotation {
        public String axis;
        public float angle;
        public Vector3f origin;

        public Quaternionf toQuaternionf() {
            return new AxisAngle4f(this.angle * ((float)Math.PI / 180), this.axis.equals("x") ? 1.0f : 0.0f, this.axis.equals("y") ? 1.0f : 0.0f, this.axis.equals("z") ? 1.0f : 0.0f).get(new Quaternionf());
        }

        public Vector3f getOrigin() {
            return new Vector3f((Vector3fc)this.origin).sub(8.0f, 8.0f, 8.0f).div(16.0f);
        }
    }

    public static class TextureInfo {
        @SerializedName(value="tintindex")
        public int tintIndex = -1;
        public String texture;
        public int rotation;
        public Vector4f uv;

        public TextureInfo(String texture, Vector4f uv, int rotation) {
            this.texture = texture;
            this.uv = uv;
            this.rotation = rotation;
        }

        public TextureInfo() {
        }
    }
}

