/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render.model.resource.state;

import de.tomalbrc.cameraobscura.render.model.resource.state.Variant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

public class MultipartDefinition {
    public List<Variant> apply;
    public Condition when;

    public static class OrCondition
    extends Condition {
        public List<Map<String, String>> blockStateValueList;

        @Override
        public boolean canApply(class_2680 blockState) {
            for (int i = 0; i < this.blockStateValueList.size(); ++i) {
                boolean matches = this.testMap(blockState, this.blockStateValueList.get(i));
                if (!matches) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndCondition
    extends Condition {
        public List<Map<String, String>> blockStateValueList;

        @Override
        public boolean canApply(class_2680 blockState) {
            for (int i = 0; i < this.blockStateValueList.size(); ++i) {
                boolean matches = this.testMap(blockState, this.blockStateValueList.get(i));
                if (matches) continue;
                return false;
            }
            return true;
        }
    }

    public static class Condition {
        public AndCondition AND;
        public OrCondition OR;
        public Map<String, String> blockStateValues;

        public boolean canApply(class_2680 blockState) {
            if (this.AND != null) {
                return this.AND.canApply(blockState);
            }
            if (this.OR != null) {
                return this.OR.canApply(blockState);
            }
            return this.testMap(blockState, this.blockStateValues);
        }

        protected boolean testMap(class_2680 blockState, Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String propertyName = entry.getKey();
                String[] valueKeys = entry.getValue().split("\\|");
                class_2689 stateDefinition = blockState.method_26204().method_9595();
                class_2769 prop = stateDefinition.method_11663(propertyName);
                boolean match = false;
                for (int i = 0; i < valueKeys.length; ++i) {
                    String valueKey = valueKeys[i];
                    Optional propVal = prop.method_11900(valueKey);
                    if (!propVal.isPresent()) {
                        throw new RuntimeException(String.format("Unknown value '%s' for property '%s' on '%s'", valueKey, propertyName, stateDefinition.method_11660()));
                    }
                    Comparable val = blockState.method_11654(prop);
                    if (!((Comparable)propVal.get()).equals(val)) continue;
                    match = true;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
    }
}

