/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render.model.triangle;

import com.mojang.logging.LogUtils;
import de.tomalbrc.cameraobscura.render.model.RenderModel;
import de.tomalbrc.cameraobscura.render.model.resource.RPElement;
import de.tomalbrc.cameraobscura.render.model.resource.RPModel;
import de.tomalbrc.cameraobscura.render.model.triangle.Triangle;
import de.tomalbrc.cameraobscura.util.RPHelper;
import de.tomalbrc.cameraobscura.util.TextureHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_9848;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4fc;

public class TriangleModel
implements RenderModel {
    private final List<Triangle> modelTriangles = new ObjectArrayList();
    private final Map<String, class_2960> textureMap = new Object2ObjectOpenHashMap();
    private static final Vector2f[] list = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};

    public TriangleModel(RPModel.View view) {
        this.readModel(view);
    }

    private void readModel(RPModel.View modelView) {
        List<RPElement> elementList = modelView.collectElements();
        for (int i = 0; i < elementList.size(); ++i) {
            RPElement element = elementList.get(i);
            Vector3f from = new Vector3f((Vector3fc)element.from);
            Vector3f to = new Vector3f((Vector3fc)element.to);
            Vector3f posOffset = new Vector3f(0.5f);
            from.div(16.0f).sub((Vector3fc)posOffset);
            to.div(16.0f).sub((Vector3fc)posOffset);
            Quaternionf elementRotation = null;
            Vector3f rotationOrigin = null;
            float rotationOriginLength = 0.0f;
            if (element.rotation != null) {
                elementRotation = element.rotation.toQuaternionf();
                rotationOrigin = element.rotation.getOrigin();
                rotationOriginLength = element.rotation.getOrigin().length();
            }
            List<Triangle> tris = this.generateCubeTriangles(from, to, element, new Vector3f(modelView.blockRotation()), modelView.uvlock());
            for (int j = 0; j < tris.size(); ++j) {
                Vector3f n = tris.get(j).getNormal().get(new Vector3f());
                if (element.rotation != null) {
                    if (rotationOriginLength > 0.0f) {
                        tris.get(j).translate(rotationOrigin.x, rotationOrigin.y, rotationOrigin.z);
                    }
                    tris.get(j).rotate(elementRotation);
                    if (rotationOriginLength > 0.0f) {
                        tris.get(j).translate(-rotationOrigin.x, -rotationOrigin.y, -rotationOrigin.z);
                    }
                }
                Vector3f rot = modelView.blockRotation().mul((float)(-Math.PI) / 180, new Vector3f());
                tris.get(j).rotate(new Quaternionf().rotateX(rot.x()).normalize());
                n.rotate((Quaternionfc)new Quaternionf().rotateX(rot.x()).normalize());
                tris.get(j).rotate(new Quaternionf().rotateY(rot.y()).normalize());
                n.rotate((Quaternionfc)new Quaternionf().rotateY(rot.y()).normalize());
                tris.get(j).rotate(new Quaternionf().rotateZ(rot.z()).normalize());
                n.rotate((Quaternionfc)new Quaternionf().rotateZ(rot.z()).normalize());
                tris.get(j).recalculateVectors();
                tris.get(j).setDirection((Vector3fc)n);
                tris.get(j).translate(modelView.offset().x(), modelView.offset().y(), modelView.offset().z());
            }
            this.modelTriangles.addAll(tris);
        }
        this.textureMap.putAll(modelView.collectTextures());
    }

    private List<Triangle> generateCubeTriangles(Vector3f from, Vector3f to, RPElement element, Vector3f normal, boolean uvlock) {
        Vector2f corner01;
        Vector2f corner11;
        Vector2f corner10;
        Vector2f corner00;
        int offset;
        ObjectArrayList triangles = new ObjectArrayList();
        float minX = from.x;
        float minY = from.y;
        float minZ = from.z;
        float maxX = to.x;
        float maxY = to.y;
        float maxZ = to.z;
        normal.set(0.0f);
        RPElement.TextureInfo textureInfo = element.faces.get("down");
        if (textureInfo != null) {
            offset = 4 - (int)normal.y / 90 - textureInfo.rotation / 90;
            corner00 = list[(0 + offset) % 4];
            corner10 = list[(1 + offset) % 4];
            corner11 = list[(2 + offset) % 4];
            corner01 = list[(3 + offset) % 4];
            triangles.add(new Triangle(new Vector3f(maxX, minY, maxZ), new Vector3f(minX, minY, minZ), new Vector3f(maxX, minY, minZ), corner01, corner11, corner10));
            triangles.add(new Triangle(new Vector3f(minX, minY, minZ), new Vector3f(maxX, minY, maxZ), new Vector3f(minX, minY, maxZ), corner10, corner00, corner01));
        }
        if ((textureInfo = element.faces.get("up")) != null) {
            offset = 4 - (int)normal.y / 90 - textureInfo.rotation / 90;
            corner00 = list[(0 + offset) % 4];
            corner10 = list[(1 + offset) % 4];
            corner11 = list[(2 + offset) % 4];
            corner01 = list[(3 + offset) % 4];
            triangles.add(new Triangle(new Vector3f(maxX, maxY, minZ), new Vector3f(minX, maxY, minZ), new Vector3f(maxX, maxY, maxZ), corner00, corner11, corner10));
            triangles.add(new Triangle(new Vector3f(minX, maxY, maxZ), new Vector3f(maxX, maxY, maxZ), new Vector3f(minX, maxY, minZ), corner11, corner00, corner01));
        }
        if ((textureInfo = element.faces.get("north")) != null) {
            offset = 4 - (int)normal.x / 90 - textureInfo.rotation / 90;
            corner00 = list[(0 + offset) % 4];
            corner10 = list[(1 + offset) % 4];
            corner11 = list[(2 + offset) % 4];
            corner01 = list[(3 + offset) % 4];
            triangles.add(new Triangle(new Vector3f(minX, minY, minZ), new Vector3f(minX, maxY, minZ), new Vector3f(maxX, maxY, minZ), corner10, corner00, corner11));
            triangles.add(new Triangle(new Vector3f(minX, minY, minZ), new Vector3f(maxX, maxY, minZ), new Vector3f(maxX, minY, minZ), corner00, corner01, corner11));
        }
        if ((textureInfo = element.faces.get("south")) != null) {
            offset = 4 - (int)normal.x / 90 - textureInfo.rotation / 90;
            corner00 = list[(0 + offset) % 4];
            corner10 = list[(1 + offset) % 4];
            corner11 = list[(2 + offset) % 4];
            corner01 = list[(3 + offset) % 4];
            triangles.add(new Triangle(new Vector3f(maxX, minY, maxZ), new Vector3f(maxX, maxY, maxZ), new Vector3f(minX, maxY, maxZ), corner10, corner00, corner11));
            triangles.add(new Triangle(new Vector3f(maxX, minY, maxZ), new Vector3f(minX, maxY, maxZ), new Vector3f(minX, minY, maxZ), corner00, corner01, corner11));
        }
        if ((textureInfo = element.faces.get("west")) != null) {
            offset = 4 - (int)normal.z / 90 - textureInfo.rotation / 90;
            corner00 = list[(0 + offset) % 4];
            corner10 = list[(1 + offset) % 4];
            corner11 = list[(2 + offset) % 4];
            corner01 = list[(3 + offset) % 4];
            triangles.add(new Triangle(new Vector3f(minX, minY, minZ), new Vector3f(minX, minY, maxZ), new Vector3f(minX, maxY, maxZ), corner11, corner10, corner01));
            triangles.add(new Triangle(new Vector3f(minX, minY, minZ), new Vector3f(minX, maxY, maxZ), new Vector3f(minX, maxY, minZ), corner10, corner00, corner01));
        }
        if ((textureInfo = element.faces.get("east")) != null) {
            offset = 4 - (int)normal.z / 90 - textureInfo.rotation / 90;
            corner00 = list[(0 + offset) % 4];
            corner10 = list[(1 + offset) % 4];
            corner11 = list[(2 + offset) % 4];
            corner01 = list[(3 + offset) % 4];
            triangles.add(new Triangle(new Vector3f(maxX, minY, minZ), new Vector3f(maxX, maxY, minZ), new Vector3f(maxX, maxY, maxZ), corner10, corner00, corner11));
            triangles.add(new Triangle(new Vector3f(maxX, minY, minZ), new Vector3f(maxX, maxY, maxZ), new Vector3f(maxX, minY, maxZ), corner00, corner01, corner11));
        }
        for (int i = 0; i < triangles.size(); ++i) {
            Triangle triangle = (Triangle)triangles.get(i);
            class_2350 d = triangle.getDirection();
            if (d != null) {
                triangle.textureInfo = element.faces.get(d.method_10151());
            }
            triangle.shade = element.shade;
            triangle.light = element.light;
        }
        return triangles;
    }

    @Override
    public List<RenderModel.ModelHit> intersect(Vector3f origin, Vector3f direction, Vector3f offset, int textureTint) {
        ObjectArrayList hitList = new ObjectArrayList();
        ObjectArrayList modelHitList = new ObjectArrayList();
        for (int i = 0; i < this.modelTriangles.size(); ++i) {
            Triangle.TriangleHit res = this.modelTriangles.get(i).rayIntersect(origin.sub((Vector3fc)offset, new Vector3f()), direction);
            if (res == null) continue;
            hitList.add(res);
        }
        hitList.sort((a, b) -> Float.compare(a.t(), b.t()));
        Vector2f uv = new Vector2f();
        for (int i = 0; i < hitList.size(); ++i) {
            Triangle.TriangleHit hit = (Triangle.TriangleHit)hitList.get(i);
            Triangle triangle = hit.triangle();
            uv.set(hit.u(), hit.v());
            class_2350 normalDir = hit.triangle().getDirection();
            RPElement.TextureInfo textureInfo = triangle.textureInfo;
            if (textureInfo == null) continue;
            String texKey = textureInfo.texture.charAt(0) == '#' ? textureInfo.texture.substring(1) : textureInfo.texture;
            class_2960 r = this.textureMap.get(texKey);
            while (this.textureMap.containsKey(texKey)) {
                r = this.textureMap.get(texKey);
                texKey = this.textureMap.get(texKey).method_12832();
            }
            BufferedImage img = null;
            try {
                img = RPHelper.loadTextureImage(r);
            }
            catch (Exception e) {
                LogUtils.getLogger().error("Could not load {}", (Object)r);
                continue;
            }
            if (img == null) continue;
            int width = img.getWidth();
            int realHeight = (int)((float)img.getHeight() / ((float)img.getHeight() / (float)img.getWidth()));
            if (textureInfo.uv != null) {
                uv = TextureHelper.remapUV((Vector2fc)uv, (Vector4fc)textureInfo.uv, width, realHeight);
            }
            int s = (int)((float)width * uv.x());
            int t = (int)((float)realHeight * uv.y());
            int imgData = img.getRGB(class_3532.method_15340((int)s, (int)0, (int)(img.getWidth() - 1)), class_3532.method_15340((int)t, (int)0, (int)(img.getHeight() - 1)));
            if (textureInfo.tintIndex != -1 && textureTint != -1) {
                imgData = class_9848.method_61322((int)imgData, (int)textureTint);
            }
            modelHitList.add(new RenderModel.ModelHit(imgData, normalDir, triangle.shade, triangle.light, hit.t()));
        }
        return modelHitList;
    }

    Vector2fc rotateUV(Vector2fc uv, Vector2fc pivot, float rotation) {
        float sine = class_3532.method_15374((float)rotation);
        float cosine = class_3532.method_15362((float)rotation);
        Vector2f ruv = new Vector2f(uv);
        ruv.sub(pivot);
        ruv.x = uv.x() * cosine - uv.x() * sine;
        ruv.y = uv.x() * sine + uv.y() * cosine;
        ruv.add(pivot);
        return ruv;
    }
}

