/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render.renderer;

import de.tomalbrc.cameraobscura.render.Raytracer;
import de.tomalbrc.cameraobscura.render.renderer.Renderer;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public abstract class AbstractRenderer<T>
implements Renderer<T> {
    protected final int width;
    protected final int height;
    protected final class_1309 entity;
    protected final Raytracer raytracer;

    public AbstractRenderer(class_1309 entity, int width, int height, int renderDistance) {
        this.entity = entity;
        this.width = width;
        this.height = height;
        this.raytracer = new Raytracer(this.entity, renderDistance);
        this.raytracer.preloadChunks(entity.method_23312());
    }

    public static class_243 yawPitchRotation(class_243 base, double angleYaw, double anglePitch) {
        double oldX = base.method_10216();
        double oldY = base.method_10214();
        double oldZ = base.method_10215();
        double sinOne = Math.sin(angleYaw);
        double sinTwo = Math.sin(anglePitch);
        double cosOne = Math.cos(angleYaw);
        double cosTwo = Math.cos(anglePitch);
        double newX = oldX * cosOne * cosTwo - oldY * cosOne * sinTwo - oldZ * sinOne;
        double newY = oldX * sinTwo + oldY * cosTwo;
        double newZ = oldX * sinOne * cosTwo - oldY * sinOne * sinTwo + oldZ * cosOne;
        return new class_243(newX, newY, newZ);
    }

    public static class_243 doubleYawPitchRotation(class_243 base, double firstYaw, double firstPitch, double secondYaw, double secondPitch) {
        return AbstractRenderer.yawPitchRotation(AbstractRenderer.yawPitchRotation(base, firstYaw, firstPitch), secondYaw, secondPitch);
    }

    protected class_243 rayAt(float yaw, float pitch, int x, int y) {
        double yawRad = (yaw + 90.0f) * ((float)Math.PI / 180);
        double pitchRad = -pitch * ((float)Math.PI / 180);
        class_243 baseVec = new class_243(1.0, 0.0, 0.0);
        class_243 lowerLeft = AbstractRenderer.doubleYawPitchRotation(baseVec, -FOV_YAW_RAD, -FOV_PITCH_RAD, yawRad, pitchRad);
        class_243 upperLeft = AbstractRenderer.doubleYawPitchRotation(baseVec, -FOV_YAW_RAD, FOV_PITCH_RAD, yawRad, pitchRad);
        class_243 lowerRight = AbstractRenderer.doubleYawPitchRotation(baseVec, FOV_YAW_RAD, -FOV_PITCH_RAD, yawRad, pitchRad);
        class_243 upperRight = AbstractRenderer.doubleYawPitchRotation(baseVec, FOV_YAW_RAD, FOV_PITCH_RAD, yawRad, pitchRad);
        double v = (double)y / (double)(this.height - 1);
        class_243 leftEdge = upperLeft.method_35590(lowerLeft, v);
        class_243 rightEdge = upperRight.method_35590(lowerRight, v);
        double u = (double)x / (double)(this.width - 1);
        class_243 ray = leftEdge.method_35590(rightEdge, u);
        return ray;
    }
}

