/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.util;

public class ColorHelper {
    public static int packColor(double[] color) {
        int alpha = (int)Math.max(0.0, Math.min(255.0, color[0] * 255.0));
        int red = (int)Math.max(0.0, Math.min(255.0, color[1] * 255.0));
        int green = (int)Math.max(0.0, Math.min(255.0, color[2] * 255.0));
        int blue = (int)Math.max(0.0, Math.min(255.0, color[3] * 255.0));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static double[] unpackColor(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new double[]{(double)alpha / 255.0, (double)red / 255.0, (double)green / 255.0, (double)blue / 255.0};
    }

    public static double[] multiplyColor(double[] color1, double[] color2) {
        return new double[]{color1[0] * color2[0], color1[1] * color2[1], color1[2] * color2[2], color1[3] * color2[3]};
    }

    public static int multiplyColor(int c1, int c2) {
        float a = (float)(c1 >> 24 & 0xFF) / 255.0f * (float)(c2 >> 24 & 0xFF) / 255.0f;
        float r = (float)(c1 >> 16 & 0xFF) / 255.0f * (float)(c2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(c1 >> 8 & 0xFF) / 255.0f * (float)(c2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(c1 & 0xFF) / 255.0f * (float)(c2 & 0xFF) / 255.0f;
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static int multiplyColor(int c1, float scale) {
        float r = (float)(c1 >> 16 & 0xFF) / 255.0f * scale;
        float g = (float)(c1 >> 8 & 0xFF) / 255.0f * scale;
        float b = (float)(c1 & 0xFF) / 255.0f * scale;
        return c1 >> 24 & 0xFF | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public static int alphaComposite(int color1, int color2) {
        return ColorHelper.packColor(ColorHelper.alphaComposite(ColorHelper.unpackColor(color1), ColorHelper.unpackColor(color2)));
    }

    public static double[] alphaComposite(double[] color1, double[] color2) {
        double alpha1 = color1[0];
        double alpha2 = color2[0];
        double alphaResult = alpha1 + alpha2 * (1.0 - alpha1);
        double[] result = new double[4];
        if (alphaResult == 0.0) {
            result[0] = 0.0;
            result[1] = 0.0;
            result[2] = 0.0;
            result[3] = 0.0;
        } else {
            result[0] = alphaResult;
            result[1] = (color1[1] * alpha1 + color2[1] * alpha2 * (1.0 - alpha1)) / alphaResult;
            result[2] = (color1[2] * alpha1 + color2[2] * alpha2 * (1.0 - alpha1)) / alphaResult;
            result[3] = (color1[3] * alpha1 + color2[3] * alpha2 * (1.0 - alpha1)) / alphaResult;
        }
        return result;
    }

    public static int interpolateColors(int[] colors, float fraction) {
        if (fraction <= 0.0f) {
            return colors[0];
        }
        if (fraction >= 1.0f) {
            return colors[colors.length - 1];
        }
        float segmentSize = 1.0f / (float)(colors.length - 1);
        float segment = fraction / segmentSize;
        int index1 = (int)Math.floor(segment);
        int index2 = Math.min(index1 + 1, colors.length - 1);
        float segmentFraction = segment - (float)index1;
        int color1 = colors[index1];
        int color2 = colors[index2];
        double[] color1Array = ColorHelper.unpackColor(color1);
        double[] color2Array = ColorHelper.unpackColor(color2);
        double[] interpolatedColorArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            interpolatedColorArray[i] = ColorHelper.interpolateComponent(color1Array[i], color2Array[i], segmentFraction);
        }
        return ColorHelper.packColor(interpolatedColorArray);
    }

    private static double interpolateComponent(double start, double end, float fraction) {
        return start + (end - start) * (double)fraction;
    }
}

