/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import de.tomalbrc.cameraobscura.json.ConditionDeserializer;
import de.tomalbrc.cameraobscura.json.MultipartDefinitionDeserializer;
import de.tomalbrc.cameraobscura.json.VariantDeserializer;
import de.tomalbrc.cameraobscura.json.Vector3fDeserializer;
import de.tomalbrc.cameraobscura.json.Vector4fDeserializer;
import de.tomalbrc.cameraobscura.render.model.resource.RPBlockState;
import de.tomalbrc.cameraobscura.render.model.resource.RPElement;
import de.tomalbrc.cameraobscura.render.model.resource.RPModel;
import de.tomalbrc.cameraobscura.render.model.resource.state.MultipartDefinition;
import de.tomalbrc.cameraobscura.render.model.resource.state.Variant;
import de.tomalbrc.cameraobscura.util.TextureHelper;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import xyz.nucleoid.packettweaker.PacketContext;

public class RPHelper {
    public static ResourcePackBuilder resourcePackBuilder;
    private static final ResourcePackBuilder vanillaBuilder;
    private static final Map<class_2960, RPModel> modelResources;
    private static final Map<class_2680, RPBlockState> blockStateResources;
    private static final Map<class_2960, BufferedImage> textureCache;
    public static final Gson gson;

    public static void clearCache() {
        modelResources.clear();
        blockStateResources.clear();
        textureCache.clear();
    }

    public static ResourcePackBuilder getBuilder() {
        return resourcePackBuilder == null ? vanillaBuilder : resourcePackBuilder;
    }

    @Nullable
    public static RPBlockState loadBlockState(class_2680 blockState) {
        if (blockStateResources.containsKey(blockState)) {
            return blockStateResources.get(blockState);
        }
        class_2960 location = blockState.method_26204().method_40142().method_40237().method_29177();
        byte[] data = RPHelper.getBuilder().getDataOrSource("assets/" + location.method_12836() + "/blockstates/" + location.method_12832() + ".json");
        if (data != null) {
            RPBlockState resource = (RPBlockState)gson.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(data)), RPBlockState.class);
            blockStateResources.put(blockState, resource);
            return resource;
        }
        return null;
    }

    public static RPModel.View loadModelView(class_2960 resourceLocation, Vector3fc blockRotation, boolean uvlock) {
        return new RPModel.View(RPHelper.loadModel(resourceLocation), blockRotation, uvlock);
    }

    public static RPModel loadModel(class_2960 resourceLocation) {
        if (modelResources.containsKey(resourceLocation)) {
            return modelResources.get(resourceLocation);
        }
        byte[] data = RPHelper.getBuilder().getDataOrSource("assets/" + resourceLocation.method_12836() + "/models/" + resourceLocation.method_12832() + ".json");
        if (data != null) {
            RPModel model = RPHelper.loadModel(new ByteArrayInputStream(data));
            modelResources.put(resourceLocation, model);
            return model;
        }
        return null;
    }

    public static RPModel loadModel(InputStream inputStream) {
        RPModel model = (RPModel)gson.fromJson((Reader)new InputStreamReader(inputStream), RPModel.class);
        if (model.elements != null) {
            for (int i = 0; i < model.elements.size(); ++i) {
                RPElement element = model.elements.get(i);
                for (Map.Entry<String, RPElement.TextureInfo> stringTextureInfoEntry : element.faces.entrySet()) {
                    if (stringTextureInfoEntry.getValue().uv != null) continue;
                    stringTextureInfoEntry.getValue().uv = new Vector4f(element.from.x(), element.from.y(), element.to.x(), element.to.y());
                }
            }
        }
        return model;
    }

    public static byte[] loadTextureBytes(class_2960 path) {
        return RPHelper.getBuilder().getDataOrSource("assets/" + path.method_12836() + "/textures/" + path.method_12832() + ".png");
    }

    public static BufferedImage loadTextureImage(class_2960 path) throws Exception {
        if (textureCache.containsKey(path)) {
            return textureCache.get(path);
        }
        if (path.method_12836().equals("dyn.p")) {
            BufferedImage img = RPHelper.imageFromBytes(RPHelper.getPlayerTexture(path.method_12832()));
            textureCache.put(path, img);
            return img;
        }
        if (path.method_12836().equals("dyn.s")) {
            BufferedImage img = RPHelper.imageFromBytes(RPHelper.getPlayerTexture(path.method_12832()));
            textureCache.put(path, img);
            return img;
        }
        if (path.method_12836().equals("dyn.m")) {
            BufferedImage img = RPHelper.imageFromBytes(RPHelper.getPlayerTexture(path.method_12832()));
            textureCache.put(path, img);
            return img;
        }
        byte[] data = RPHelper.loadTextureBytes(path);
        BufferedImage img = RPHelper.imageFromBytes(data);
        textureCache.put(path, img);
        return img;
    }

    private static BufferedImage imageFromBytes(byte[] data) throws Exception {
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(data));
        if (img.getType() == 10) {
            img = TextureHelper.darkenGrayscale(img);
        }
        return img;
    }

    @NotNull
    private static byte[] getPlayerTexture(String uuid) {
        InputStreamReader inputStreamReader = null;
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            inputStreamReader = new InputStreamReader(url.openStream());
            JsonObject textureProperty = new JsonParser().parse((Reader)inputStreamReader).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
            String texture = textureProperty.get("value").getAsString();
            String newJson = new String(Base64.getDecoder().decode(texture));
            String str = new JsonParser().parse(newJson).getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString();
            URL textureUrl = new URL(str);
            byte[] bytes = textureUrl.openStream().readAllBytes();
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<RPModel.View> loadModel(RPBlockState rpBlockState, class_2680 blockState) {
        if (rpBlockState != null && rpBlockState.variants != null) {
            for (Map.Entry<String, Variant> entry : rpBlockState.variants.entrySet()) {
                boolean matches = true;
                if (!entry.getKey().isEmpty()) {
                    try {
                        String str = String.format("%s[%s]", blockState.method_26204().method_40142().method_40237().method_29177(), entry.getKey());
                        class_2259.class_7211 blockResult = class_2259.method_41957((class_7225)class_7923.field_41175, (String)str, (boolean)false);
                        for (Map.Entry propertyComparableEntry : blockResult.comp_623().entrySet()) {
                            if (blockState.method_11654((class_2769)propertyComparableEntry.getKey()).equals(propertyComparableEntry.getValue())) continue;
                            matches = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (!entry.getKey().isEmpty() && !matches) continue;
                RPModel.View model = RPHelper.loadModelView(entry.getValue().model, (Vector3fc)new Vector3f((float)entry.getValue().x, (float)entry.getValue().y, (float)entry.getValue().z), entry.getValue().uvlock);
                return ObjectArrayList.of((Object[])new RPModel.View[]{model});
            }
        } else if (rpBlockState != null && rpBlockState.multipart != null) {
            ObjectArrayList list = new ObjectArrayList();
            int num = rpBlockState.multipart.size();
            for (int i = 0; i < num; ++i) {
                MultipartDefinition mp = rpBlockState.multipart.get(i);
                if (mp.when != null && !mp.when.canApply(blockState)) continue;
                for (int applyIndex = 0; applyIndex < mp.apply.size(); ++applyIndex) {
                    Variant apply = mp.apply.get(applyIndex);
                    RPModel.View model = RPHelper.loadModelView(apply.model, (Vector3fc)new Vector3f((float)apply.x, (float)apply.y, (float)apply.z), apply.uvlock);
                    list.add((Object)model);
                }
            }
            return list;
        }
        return null;
    }

    public static List<RPModel.View> loadBlockModelViews(class_2680 blockState) {
        class_2680 block = RPHelper.safePolymerBlockState(blockState);
        RPBlockState rpBlockState = RPHelper.loadBlockState(block);
        if (rpBlockState != null) {
            return RPHelper.loadModel(rpBlockState, block);
        }
        return null;
    }

    public static RPModel loadItemModel(class_1799 itemStack) {
        class_2960 resourceLocation = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        return RPHelper.loadModel(resourceLocation.method_45136("item/" + resourceLocation.method_12832()));
    }

    private static class_2680 safePolymerBlockState(class_2680 blockState) {
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof PolymerBlock) {
            PolymerBlock polymerBlock = (PolymerBlock)class_22482;
            blockState = polymerBlock.getPolymerBlockState(blockState, PacketContext.get());
        }
        return blockState;
    }

    static {
        vanillaBuilder = PolymerResourcePackUtils.createBuilder((Path)Path.of("polymer/camera-obscura", new String[0]));
        modelResources = Collections.synchronizedMap(new Object2ObjectOpenHashMap());
        blockStateResources = Collections.synchronizedMap(new Reference2ObjectOpenHashMap());
        textureCache = new ConcurrentHashMap<class_2960, BufferedImage>();
        gson = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new CachedResourceLocationDeserializer()).registerTypeAdapter(Variant.class, (Object)new VariantDeserializer()).registerTypeAdapter(MultipartDefinition.class, (Object)new MultipartDefinitionDeserializer()).registerTypeAdapter(MultipartDefinition.Condition.class, (Object)new ConditionDeserializer()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fDeserializer()).registerTypeAdapter(Vector4f.class, (Object)new Vector4fDeserializer()).create();
    }
}

