/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.world;

import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_4076;
import org.joml.Vector2i;

public abstract class AbstractWorldIterator<T> {
    protected final class_3218 level;
    private final Map<Vector2i, class_2818> cachedChunks;

    public AbstractWorldIterator(class_3218 level, Map<Vector2i, class_2818> cachedChunks) {
        this.level = level;
        this.cachedChunks = cachedChunks;
    }

    public void preloadChunks(class_2338 center, int distance) {
        int xc = class_4076.method_18675((int)center.method_10263());
        int zc = class_4076.method_18675((int)center.method_10260());
        int radius = distance / 16 + 1;
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                this.getChunkAt(new Vector2i(x + xc, z + zc));
            }
        }
    }

    protected class_2818 getChunkAt(Vector2i pos) {
        class_2818 levelChunk = this.cachedChunks.get(pos);
        if (levelChunk != null) {
            return levelChunk;
        }
        levelChunk = this.level.method_8497(pos.x, pos.y);
        this.cachedChunks.put(pos, levelChunk);
        return levelChunk;
    }

    public class_2818 getChunkAt(class_2338 blockPos) {
        return this.getChunkAt(new Vector2i(class_4076.method_18675((int)blockPos.method_10263()), class_4076.method_18675((int)blockPos.method_10260())));
    }

    public abstract List<T> raycast(class_3959 var1);
}

