/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.world;

import com.mojang.logging.LogUtils;
import de.tomalbrc.cameraobscura.ModConfig;
import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import de.tomalbrc.cameraobscura.util.RPHelper;
import de.tomalbrc.cameraobscura.world.AbstractWorldIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import org.joml.Quaternionf;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityIterator
extends AbstractWorldIterator<EntityHit> {
    private final class_1309 entity;
    private final List<EntityHit> allEntities;

    public EntityIterator(class_3218 level, Map<Vector2i, class_2818> cachedChunks, class_1309 entity1) {
        super(level, cachedChunks);
        this.entity = entity1;
        this.allEntities = new ObjectArrayList();
        if (ModConfig.getInstance().renderEntities) {
            List lst = this.level.method_8335((class_1297)this.entity, this.entity.method_5829().method_1014((double)ModConfig.getInstance().renderDistance));
            lst.sort(Comparator.comparingDouble(a -> a.method_73189().method_1022(entity1.method_73189())));
            for (int i = 0; i < lst.size() && this.allEntities.size() <= ModConfig.getInstance().renderEntitiesAmount; ++i) {
                class_1297 class_12972;
                class_1297 entity = (class_1297)lst.get(i);
                if (!this.isInFrustum(entity1.method_5828(1.0f), entity1.method_73189(), entity.method_73189(), ModConfig.getInstance().fov + 10) || !entity1.method_6057(entity)) continue;
                Objects.requireNonNull(entity);
                int n = 0;
                EntityHit hit = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1309.class, class_1533.class, class_1542.class}, (Object)class_12972, n)) {
                    case 0 -> {
                        class_1309 livingEntity = (class_1309)class_12972;
                        yield new EntityHit(entity.method_5864(), entity.method_5829().method_1014(1.0), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)new Vector3f(0.0f, livingEntity.field_6283, 0.0f), entity.method_5667(), null);
                    }
                    case 1 -> {
                        class_1533 itemFrame = (class_1533)class_12972;
                        Quaternionf rot = itemFrame.method_5735().method_23224();
                        yield new EntityHit(entity.method_5864(), entity.method_5829().method_1014(1.0), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)rot.getEulerAnglesXYZ(new Vector3f()).mul(57.295776f), entity.method_5667(), null);
                    }
                    case 2 -> {
                        class_1542 itemEntity = (class_1542)class_12972;
                        yield new EntityHit(entity.method_5864(), entity.method_5829(), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)new Vector3f(0.0f, itemEntity.method_73188(), 0.0f), entity.method_5667(), itemEntity.method_6983().method_7972());
                    }
                    default -> new EntityHit(entity.method_5864(), entity.method_5829().method_1014(1.0), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)new Vector3f(entity.method_36455(), entity.method_36454(), 0.0f), entity.method_5667(), null);
                };
                if (entity.method_5864() == class_1299.field_6097) {
                    try {
                        RPHelper.loadTextureImage(CachedResourceLocationDeserializer.get("dyn.p:" + entity.method_5667().toString().replace("-", "")));
                    }
                    catch (Exception e) {
                        LogUtils.getLogger().info("Could not render player");
                        continue;
                    }
                }
                this.allEntities.add(hit);
            }
        }
    }

    public boolean isInFrustum(class_243 viewVector, class_243 cameraPosition, class_243 targetPosition, float fov) {
        class_243 normalizedDirection = targetPosition.method_1020(cameraPosition).method_1029();
        class_243 normalizedViewVector = viewVector.method_1029();
        double dotProduct = normalizedViewVector.method_1026(normalizedDirection);
        return dotProduct >= Math.cos(Math.toRadians(fov) / 2.0);
    }

    @Override
    public List<EntityHit> raycast(class_3959 clipContext) {
        ObjectArrayList hits = new ObjectArrayList();
        for (int i = 0; i < this.allEntities.size(); ++i) {
            EntityHit entityHit = this.allEntities.get(i);
            if (!entityHit.boundingBox().method_993(clipContext.method_17750(), clipContext.method_17747())) continue;
            hits.add(entityHit);
        }
        return hits;
    }

    public record EntityHit(class_1299 type, class_238 boundingBox, Vector3fc position, Vector3fc rotation, UUID uuid, Object data) {
    }
}

