/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked;

import com.uravgcode.survivalunlocked.listener.CustomPortalListener;
import com.uravgcode.survivalunlocked.listener.FireballThrowListener;
import com.uravgcode.survivalunlocked.listener.ItemFrameInvisibleListener;
import com.uravgcode.survivalunlocked.listener.PlayerHeadDropListener;
import com.uravgcode.survivalunlocked.listener.VillagerFollowListener;
import com.uravgcode.survivalunlocked.mobheads.MobHeadDropListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class SurvivalUnlocked
extends JavaPlugin {
    public void onEnable() {
        this.saveDefaultConfig();
        if (!Files.exists(this.getDataFolder().toPath().resolve("heads.yml"), new LinkOption[0])) {
            this.saveResource("heads.yml", false);
        }
        FileConfiguration config = this.getConfig();
        Logger logger = this.getLogger();
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (config.getBoolean("custom-shaped-portals.enabled", false)) {
            pluginManager.registerEvents((Listener)new CustomPortalListener(this), (Plugin)this);
            logger.info("custom shaped nether portals enabled");
        }
        if (config.getBoolean("throwable-fireballs.enabled", false)) {
            pluginManager.registerEvents((Listener)new FireballThrowListener(), (Plugin)this);
            logger.info("throwable fireballs enabled");
        }
        if (config.getBoolean("invisible-item-frames.enabled", false)) {
            pluginManager.registerEvents((Listener)new ItemFrameInvisibleListener(), (Plugin)this);
            logger.info("invisible item frames enabled");
        }
        if (config.getBoolean("villagers-follow-emeralds.enabled", false)) {
            pluginManager.registerEvents((Listener)new VillagerFollowListener(this), (Plugin)this);
            logger.info("villagers follow emeralds enabled");
        }
        if (config.getBoolean("more-mob-heads.enabled", false)) {
            pluginManager.registerEvents((Listener)new MobHeadDropListener(this), (Plugin)this);
            logger.info("more mob heads enabled");
        }
        if (config.getBoolean("player-head-drops.enabled", false)) {
            pluginManager.registerEvents((Listener)new PlayerHeadDropListener(), (Plugin)this);
            logger.info("player head drops enabled");
        }
    }
}

