/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.listener;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BoundingBox;

public class CustomPortalListener
implements Listener {
    private static final int minPortalSize = 6;
    private static final int maxWidth = 21;
    private static final int maxHeight = 21;
    private static final Set<Material> portalFrameMaterials = Set.of(Material.OBSIDIAN, Material.CRYING_OBSIDIAN);
    private final JavaPlugin plugin;

    public CustomPortalListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        Block fireBlock = event.getBlock();
        if (!portalFrameMaterials.contains(fireBlock.getRelative(BlockFace.DOWN).getType())) {
            return;
        }
        World world = fireBlock.getWorld();
        if (world.getEnvironment() == World.Environment.THE_END) {
            return;
        }
        Entity entity = event.getIgnitingEntity();
        Location location = fireBlock.getLocation();
        for (Axis axis : new Axis[]{Axis.X, Axis.Z}) {
            Optional<Set<Block>> portalBlocks = this.getPortalBlocks(fireBlock, axis);
            if (!portalBlocks.isPresent()) continue;
            this.buildPortal(portalBlocks.get(), axis, world, entity, location);
            event.setCancelled(true);
            break;
        }
    }

    private Optional<Set<Block>> getPortalBlocks(Block fireBlock, Axis axis) {
        BlockFace[] blockFaceArray;
        HashSet<Block> visited = new HashSet<Block>(Collections.singletonList(fireBlock));
        ArrayDeque<Block> queue = new ArrayDeque<Block>(Collections.singletonList(fireBlock));
        if (axis == Axis.Z) {
            BlockFace[] blockFaceArray2 = new BlockFace[4];
            blockFaceArray2[0] = BlockFace.UP;
            blockFaceArray2[1] = BlockFace.DOWN;
            blockFaceArray2[2] = BlockFace.NORTH;
            blockFaceArray = blockFaceArray2;
            blockFaceArray2[3] = BlockFace.SOUTH;
        } else {
            BlockFace[] blockFaceArray3 = new BlockFace[4];
            blockFaceArray3[0] = BlockFace.UP;
            blockFaceArray3[1] = BlockFace.DOWN;
            blockFaceArray3[2] = BlockFace.EAST;
            blockFaceArray = blockFaceArray3;
            blockFaceArray3[3] = BlockFace.WEST;
        }
        BlockFace[] directions = blockFaceArray;
        BoundingBox bounds = new BoundingBox((double)fireBlock.getX(), (double)fireBlock.getY(), (double)fireBlock.getZ(), (double)fireBlock.getX(), (double)fireBlock.getY(), (double)fireBlock.getZ());
        while (!queue.isEmpty()) {
            Block current = (Block)queue.poll();
            for (BlockFace direction : directions) {
                Block neighbor = current.getRelative(direction);
                if (visited.contains(neighbor)) continue;
                Material material = neighbor.getType();
                if (!material.equals((Object)Material.AIR) && !material.equals((Object)Material.FIRE)) {
                    if (portalFrameMaterials.contains(material)) continue;
                    return Optional.empty();
                }
                visited.add(neighbor);
                queue.add(neighbor);
                bounds.union((double)neighbor.getX(), (double)neighbor.getY(), (double)neighbor.getZ());
                double width = axis == Axis.X ? bounds.getWidthX() : bounds.getWidthZ();
                double height = bounds.getHeight();
                if (!(width >= 21.0) && !(height >= 21.0)) continue;
                return Optional.empty();
            }
        }
        return visited.size() < 6 ? Optional.empty() : Optional.of(visited);
    }

    private void buildPortal(Set<Block> validPortalBlocks, Axis axis, World world, Entity entity, Location location) {
        this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, location, task -> {
            Orientable portalData = (Orientable)Material.NETHER_PORTAL.createBlockData();
            portalData.setAxis(axis);
            ArrayList<BlockState> blockStates = new ArrayList<BlockState>(validPortalBlocks.size());
            for (Block block : validPortalBlocks) {
                BlockState state2 = block.getState();
                state2.setBlockData((BlockData)portalData);
                blockStates.add(state2);
            }
            PortalCreateEvent portalCreateEvent = new PortalCreateEvent(blockStates, world, entity, PortalCreateEvent.CreateReason.FIRE);
            if (portalCreateEvent.callEvent()) {
                blockStates.forEach(state -> state.update(true));
            }
        });
    }
}

