/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.listener;

import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;

public class ItemFrameInvisibleListener
implements Listener {
    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        Player player = event.getPlayer();
        ItemStack handItem = player.getInventory().getItem(event.getHand());
        if (handItem.getType() != Material.SHEARS) {
            return;
        }
        ItemStack frameItem = frame.getItem();
        if (frameItem.getType() == Material.AIR || !frame.isVisible()) {
            return;
        }
        frame.getWorld().spawnParticle(Particle.CRIT, frame.getLocation().add(0.0, 0.5, 0.0), 5, 0.2, 0.2, 0.2, 0.05);
        event.getPlayer().playSound(frame.getLocation(), Sound.BLOCK_BEEHIVE_SHEAR, 1.0f, 1.0f);
        frame.setVisible(false);
        event.setCancelled(true);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            frame.setVisible(true);
        }
    }
}

