/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.listener;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VillagerFollowListener
implements Listener {
    private static final double MIN_FOLLOW_DISTANCE = 2.0;
    private final Set<Player> players = new HashSet<Player>();

    public VillagerFollowListener(JavaPlugin plugin) {
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, () -> {
            for (Player player : this.players) {
                if (!player.isConnected()) {
                    this.players.remove(player);
                    continue;
                }
                for (Entity entity : player.getNearbyEntities(10.0, 5.0, 10.0)) {
                    if (entity.getType() != EntityType.VILLAGER) continue;
                    Villager villager = (Villager)entity;
                    Pathfinder pathfinder = villager.getPathfinder();
                    double distance = villager.getLocation().distance(player.getLocation());
                    if (distance > 2.0) {
                        pathfinder.moveTo((LivingEntity)player, 0.6);
                        continue;
                    }
                    pathfinder.stopPathfinding();
                }
            }
        }, 0L, 10L);
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getNewSlot());
        if (item != null && item.getType() == Material.EMERALD_BLOCK) {
            this.players.add(player);
        } else {
            this.players.remove(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.players.remove(event.getPlayer());
    }
}

