/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.mobheads;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.uravgcode.survivalunlocked.mobheads.variant.BeeVariant;
import com.uravgcode.survivalunlocked.mobheads.variant.CatType;
import com.uravgcode.survivalunlocked.mobheads.variant.VillagerProfession;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class MobHeadDropListener
implements Listener {
    private final JavaPlugin plugin;
    private final YamlConfiguration config;

    public MobHeadDropListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.config = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "heads.yml"));
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity killed = event.getEntity();
        Player killer = killed.getKiller();
        if (killer == null) {
            return;
        }
        this.getEntityConfig(killed).ifPresent(configSection -> {
            double chance = configSection.getDouble("chance", 0.0);
            double looting = configSection.getDouble("looting", 0.0);
            int lootingLevel = killer.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LOOTING);
            double finalChance = chance + looting * (double)lootingLevel;
            if (ThreadLocalRandom.current().nextDouble() > finalChance) {
                return;
            }
            String texture = configSection.getString("texture");
            String display = configSection.getString("display");
            String sound = configSection.getString("sound");
            ItemStack head = this.createHead(texture, display, sound);
            event.getDrops().add(head);
        });
    }

    private ItemStack createHead(String texture, String display, String sound) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (texture != null) {
            PlayerProfile profile = this.plugin.getServer().createProfile(new UUID(0L, 0L), "");
            profile.getProperties().add(new ProfileProperty("textures", texture));
            meta.setPlayerProfile(profile);
        }
        if (display != null) {
            meta.displayName(Component.text((String)display).decoration(TextDecoration.ITALIC, false));
        }
        if (sound != null) {
            meta.setNoteBlockSound(NamespacedKey.minecraft((String)sound));
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private Optional<ConfigurationSection> getEntityConfig(LivingEntity entity) {
        ConfigurationSection configSection = this.config.getConfigurationSection(entity.getType().name().toLowerCase());
        if (configSection == null) {
            return Optional.empty();
        }
        LivingEntity livingEntity = entity;
        Objects.requireNonNull(livingEntity);
        LivingEntity livingEntity2 = livingEntity;
        int n = 0;
        String key = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Axolotl.class, Bee.class, Cat.class, Chicken.class, Cow.class, Creeper.class, Fox.class, Frog.class, Goat.class, Horse.class, TraderLlama.class, Llama.class, MushroomCow.class, Panda.class, Parrot.class, Pig.class, Rabbit.class, Sheep.class, Villager.class, Wolf.class, ZombieVillager.class}, (Object)livingEntity2, n)) {
            case 0 -> {
                Axolotl axolotl = (Axolotl)livingEntity2;
                yield axolotl.getVariant().name().toLowerCase();
            }
            case 1 -> {
                Bee bee = (Bee)livingEntity2;
                yield BeeVariant.name(bee.hasNectar(), bee.getAnger() > 0);
            }
            case 2 -> {
                Cat cat = (Cat)livingEntity2;
                yield CatType.name(cat.getCatType());
            }
            case 3 -> {
                Chicken chicken = (Chicken)livingEntity2;
                yield chicken.getVariant().key().value();
            }
            case 4 -> {
                Cow cow = (Cow)livingEntity2;
                yield cow.getVariant().key().value();
            }
            case 5 -> {
                Creeper creeper = (Creeper)livingEntity2;
                if (creeper.isPowered()) {
                    yield "charged";
                }
                yield null;
            }
            case 6 -> {
                Fox fox = (Fox)livingEntity2;
                yield fox.getFoxType().name().toLowerCase();
            }
            case 7 -> {
                Frog frog = (Frog)livingEntity2;
                yield frog.getVariant().key().value();
            }
            case 8 -> {
                Goat goat = (Goat)livingEntity2;
                if (goat.isScreaming()) {
                    yield "screaming";
                }
                yield "normal";
            }
            case 9 -> {
                Horse horse = (Horse)livingEntity2;
                yield horse.getColor().name().toLowerCase();
            }
            case 10 -> {
                TraderLlama traderLlama = (TraderLlama)livingEntity2;
                yield traderLlama.getColor().name().toLowerCase();
            }
            case 11 -> {
                Llama llama = (Llama)livingEntity2;
                yield llama.getColor().name().toLowerCase();
            }
            case 12 -> {
                MushroomCow mooshroom = (MushroomCow)livingEntity2;
                yield mooshroom.getVariant().name().toLowerCase();
            }
            case 13 -> {
                Panda panda = (Panda)livingEntity2;
                yield panda.getMainGene().name().toLowerCase();
            }
            case 14 -> {
                Parrot parrot = (Parrot)livingEntity2;
                yield parrot.getVariant().name().toLowerCase();
            }
            case 15 -> {
                Pig pig = (Pig)livingEntity2;
                yield pig.getVariant().key().value();
            }
            case 16 -> {
                Rabbit rabbit = (Rabbit)livingEntity2;
                if (Component.text((String)"Toast").equals((Object)rabbit.customName())) {
                    yield "toast";
                }
                yield rabbit.getRabbitType().name().toLowerCase();
            }
            case 17 -> {
                Sheep sheep = (Sheep)livingEntity2;
                if (Component.text((String)"jeb_").equals((Object)sheep.customName())) {
                    yield "jeb";
                }
                yield Objects.requireNonNull(sheep.getColor()).name().toLowerCase();
            }
            case 18 -> {
                Villager villager = (Villager)livingEntity2;
                yield VillagerProfession.name(villager.getProfession());
            }
            case 19 -> {
                Wolf wolf = (Wolf)livingEntity2;
                yield wolf.getVariant().key().value() + (wolf.isAngry() ? "_angry" : "");
            }
            case 20 -> {
                ZombieVillager zombieVillager = (ZombieVillager)livingEntity2;
                yield VillagerProfession.name(zombieVillager.getVillagerProfession());
            }
            default -> null;
        };
        return Optional.of(configSection).map(section -> key == null ? section : section.getConfigurationSection(key));
    }
}

