/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.lockchests;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="lock-chests")
public final class LockChestsModule
extends PluginModule {
    private final NamespacedKey lockKey;
    private final NamespacedKey recipeKey;
    private final ShapelessRecipe keyRecipe;

    public LockChestsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.lockKey = new NamespacedKey((Plugin)plugin, "lock");
        this.recipeKey = new NamespacedKey((Plugin)plugin, "trial_key_recipe");
        ItemStack result = ItemStack.of((Material)Material.TRIAL_KEY);
        this.keyRecipe = new ShapelessRecipe(this.recipeKey, result);
        this.keyRecipe.addIngredient(Material.TRIAL_KEY);
    }

    @Override
    public void enable() {
        super.enable();
        Server server = this.plugin.getServer();
        if (server.getRecipe(this.recipeKey) == null) {
            server.addRecipe((Recipe)this.keyRecipe);
        }
    }

    @Override
    public void disable() {
        super.disable();
        Server server = this.plugin.getServer();
        if (server.getRecipe(this.recipeKey) != null) {
            server.removeRecipe(this.recipeKey);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChestLock(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)state;
        if (chest.isLocked()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        ItemStack key = player.getInventory().getItemInMainHand();
        if (key.getType() != Material.TRIAL_KEY) {
            return;
        }
        Long lockValue = (Long)key.getPersistentDataContainer().get(this.lockKey, PersistentDataType.LONG);
        if (lockValue == null) {
            lockValue = ThreadLocalRandom.current().nextLong();
        }
        this.setKeyMeta(key);
        this.setLockValue(key, lockValue);
        this.lockChest(chest, lockValue);
        player.swingMainHand();
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_VAULT_INSERT_ITEM_FAIL, 1.0f, 1.0f);
    }

    @EventHandler
    public void onTrialKeyCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (!(recipe instanceof ShapelessRecipe)) {
            return;
        }
        ShapelessRecipe recipe2 = (ShapelessRecipe)recipe;
        if (!recipe2.key().equals((Object)this.recipeKey)) {
            return;
        }
        boolean isContainerKey = Arrays.stream(event.getInventory().getMatrix()).filter(Objects::nonNull).allMatch(item -> item.getPersistentDataContainer().has(this.lockKey, PersistentDataType.LONG));
        if (!isContainerKey) {
            event.getInventory().setResult(null);
        }
    }

    private void setKeyMeta(ItemStack item) {
        item.setData(DataComponentTypes.ITEM_NAME, (Object)Component.translatable((String)"item.survivalunlocked.key").fallback("Key"));
        item.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (DataComponentBuilder)CustomModelData.customModelData().addString("key"));
    }

    private void setLockValue(ItemStack item, long value) {
        item.editPersistentDataContainer(container -> container.set(this.lockKey, PersistentDataType.LONG, (Object)value));
    }

    private void lockChest(Chest chest, long value) {
        ItemStack item = ItemStack.of((Material)Material.TRIAL_KEY);
        this.setLockValue(item, value);
        InventoryHolder inventoryHolder = chest.getInventory().getHolder();
        if (inventoryHolder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
            InventoryHolder inventoryHolder2 = doubleChest.getLeftSide();
            if (inventoryHolder2 instanceof Chest) {
                Chest leftSide = (Chest)inventoryHolder2;
                leftSide.setLockItem(item);
                leftSide.update(false, false);
            }
            if ((inventoryHolder2 = doubleChest.getRightSide()) instanceof Chest) {
                Chest rightSide = (Chest)inventoryHolder2;
                rightSide.setLockItem(item);
                rightSide.update(false, false);
            }
        } else {
            chest.setLockItem(item);
            chest.update(false, false);
        }
    }
}

