/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.moremobheads;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConfigModule(path="more-mob-heads")
public final class MoreMobHeadsModule
extends PluginModule {
    private final Map<@NotNull HeadKey, @NotNull HeadData> heads = new HashMap<HeadKey, HeadData>();

    public MoreMobHeadsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public void reload() {
        super.reload();
        this.heads.clear();
        ComponentLogger logger = this.plugin.getComponentLogger();
        File file = this.plugin.getDataPath().resolve("heads.yml").toFile();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.getKeys(false).forEach(entityName -> {
            ConfigurationSection entitySection = config.getConfigurationSection(entityName);
            if (entitySection == null) {
                return;
            }
            try {
                EntityType entityType = EntityType.valueOf((String)entityName.toUpperCase());
                Set variants = entitySection.getKeys(false);
                if (variants.stream().anyMatch(arg_0 -> ((ConfigurationSection)entitySection).isConfigurationSection(arg_0))) {
                    variants.forEach(variant -> {
                        ConfigurationSection variantSection = entitySection.getConfigurationSection(variant);
                        if (variantSection == null) {
                            return;
                        }
                        this.heads.put(new HeadKey(entityType, (String)variant), MoreMobHeadsModule.createHeadData(variantSection));
                    });
                } else {
                    this.heads.put(new HeadKey(entityType, null), MoreMobHeadsModule.createHeadData(entitySection));
                }
            }
            catch (IllegalArgumentException e) {
                logger.warn("invalid entity type in heads.yml: {}", entityName);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity killed = event.getEntity();
        Player killer = killed.getKiller();
        if (killer == null) {
            return;
        }
        HeadData headData = this.heads.get(new HeadKey(killed.getType(), MoreMobHeadsModule.getVariant(killed)));
        if (headData == null) {
            return;
        }
        ItemStack item = killer.getInventory().getItemInMainHand();
        int looting = item.getEnchantmentLevel(Enchantment.LOOTING);
        double chance = headData.chance + headData.looting * (double)looting;
        if (ThreadLocalRandom.current().nextDouble() > chance) {
            return;
        }
        ItemStack head = MoreMobHeadsModule.createHead(headData.texture, headData.display, headData.sound);
        event.getDrops().add(head);
    }

    @NotNull
    private static ItemStack createHead(@Nullable String texture, @Nullable String display, @Nullable String sound) {
        ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD);
        if (display != null) {
            head.setData(DataComponentTypes.ITEM_NAME, (Object)Component.text((String)display));
        }
        if (sound != null) {
            head.setData(DataComponentTypes.NOTE_BLOCK_SOUND, (Object)NamespacedKey.minecraft((String)sound));
        }
        if (texture != null) {
            head.setData(DataComponentTypes.PROFILE, (Object)((ResolvableProfile)ResolvableProfile.resolvableProfile().addProperty(new ProfileProperty("textures", texture)).build()));
        }
        return head;
    }

    @NotNull
    private static HeadData createHeadData(@NotNull ConfigurationSection section) {
        return new HeadData(section.getString("texture"), section.getString("display"), section.getString("sound"), section.getDouble("chance", 0.0), section.getDouble("looting", 0.0));
    }

    @Nullable
    private static String getVariant(@NotNull LivingEntity entity) {
        LivingEntity livingEntity = entity;
        Objects.requireNonNull(livingEntity);
        LivingEntity livingEntity2 = livingEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Axolotl.class, Bee.class, Cat.class, Chicken.class, CopperGolem.class, Cow.class, Creeper.class, Fox.class, Frog.class, Goat.class, Horse.class, TraderLlama.class, Llama.class, MushroomCow.class, Panda.class, Parrot.class, Pig.class, Rabbit.class, Sheep.class, Villager.class, Wolf.class, ZombieVillager.class}, (Object)livingEntity2, n)) {
            case 0 -> {
                Axolotl axolotl = (Axolotl)livingEntity2;
                yield axolotl.getVariant().name().toLowerCase();
            }
            case 1 -> {
                Bee bee = (Bee)livingEntity2;
                if (bee.getAnger() > 0) {
                    if (bee.hasNectar()) {
                        yield "nectar_angry";
                    }
                    yield "angry";
                }
                if (bee.hasNectar()) {
                    yield "nectar";
                }
                yield "plain";
            }
            case 2 -> {
                Cat cat = (Cat)livingEntity2;
                yield cat.getCatType().key().value();
            }
            case 3 -> {
                Chicken chicken = (Chicken)livingEntity2;
                yield chicken.getVariant().key().value();
            }
            case 4 -> {
                CopperGolem copperGolem = (CopperGolem)livingEntity2;
                yield copperGolem.getWeatheringState().name().toLowerCase();
            }
            case 5 -> {
                Cow cow = (Cow)livingEntity2;
                yield cow.getVariant().key().value();
            }
            case 6 -> {
                Creeper creeper = (Creeper)livingEntity2;
                if (creeper.isPowered()) {
                    yield "charged";
                }
                yield null;
            }
            case 7 -> {
                Fox fox = (Fox)livingEntity2;
                yield fox.getFoxType().name().toLowerCase();
            }
            case 8 -> {
                Frog frog = (Frog)livingEntity2;
                yield frog.getVariant().key().value();
            }
            case 9 -> {
                Goat goat = (Goat)livingEntity2;
                if (goat.isScreaming()) {
                    yield "screaming";
                }
                yield "normal";
            }
            case 10 -> {
                Horse horse = (Horse)livingEntity2;
                yield horse.getColor().name().toLowerCase();
            }
            case 11 -> {
                TraderLlama traderLlama = (TraderLlama)livingEntity2;
                yield traderLlama.getColor().name().toLowerCase();
            }
            case 12 -> {
                Llama llama = (Llama)livingEntity2;
                yield llama.getColor().name().toLowerCase();
            }
            case 13 -> {
                MushroomCow mushroomCow = (MushroomCow)livingEntity2;
                yield mushroomCow.getVariant().name().toLowerCase();
            }
            case 14 -> {
                Panda panda = (Panda)livingEntity2;
                yield panda.getMainGene().name().toLowerCase();
            }
            case 15 -> {
                Parrot parrot = (Parrot)livingEntity2;
                yield parrot.getVariant().name().toLowerCase();
            }
            case 16 -> {
                Pig pig = (Pig)livingEntity2;
                yield pig.getVariant().key().value();
            }
            case 17 -> {
                Rabbit rabbit = (Rabbit)livingEntity2;
                if (Component.text((String)"Toast").equals((Object)rabbit.customName())) {
                    yield "toast";
                }
                yield rabbit.getRabbitType().name().toLowerCase();
            }
            case 18 -> {
                Sheep sheep = (Sheep)livingEntity2;
                if (Component.text((String)"jeb_").equals((Object)sheep.customName())) {
                    yield "jeb";
                }
                yield Objects.requireNonNull(sheep.getColor()).name().toLowerCase();
            }
            case 19 -> {
                Villager villager = (Villager)livingEntity2;
                yield villager.getProfession().key().value();
            }
            case 20 -> {
                Wolf wolf = (Wolf)livingEntity2;
                yield wolf.getVariant().key().value() + (wolf.isAngry() ? "_angry" : "");
            }
            case 21 -> {
                ZombieVillager zombieVillager = (ZombieVillager)livingEntity2;
                yield zombieVillager.getVillagerProfession().key().value();
            }
            default -> null;
        };
    }

    private record HeadKey(@NotNull EntityType type, @Nullable String variant) {
    }

    private record HeadData(@Nullable String texture, @Nullable String display, @Nullable String sound, double chance, double looting) {
    }
}

