/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.shearnametags;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.datacomponent.DataComponentTypes;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="shear-name-tags")
public final class ShearNameTagsModule
extends PluginModule {
    public ShearNameTagsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        ItemStack item = player.getInventory().getItem(hand);
        if (item.getType() != Material.SHEARS || !player.isSneaking()) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Component customName = entity2.customName();
        if (customName == null) {
            return;
        }
        player.swingHand(hand);
        entity2.customName(null);
        ItemStack nameTag = ItemStack.of((Material)Material.NAME_TAG);
        nameTag.setData(DataComponentTypes.CUSTOM_NAME, (Object)customName);
        World world = entity2.getWorld();
        Location location = entity2.getLocation();
        world.dropItemNaturally(location, nameTag);
        world.playSound(location, Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
        event.setCancelled(true);
    }
}

