/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.silencemobs;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="silence-mobs")
public final class SilenceMobsModule
extends PluginModule {
    public SilenceMobsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItem(event.getHand());
        if (item.getType() != Material.NAME_TAG) {
            return;
        }
        Component name = (Component)item.getData(DataComponentTypes.CUSTOM_NAME);
        if (Component.text((String)"silence").equals((Object)name)) {
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.subtract();
            }
            player.sendActionBar((Component)Component.text((String)(this.getMobName(mob) + " silenced")));
            mob.setSilent(true);
            event.setCancelled(true);
        } else if (Component.text((String)"unsilence").equals((Object)name)) {
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.subtract();
            }
            player.sendActionBar((Component)Component.text((String)(this.getMobName(mob) + " unsilenced")));
            mob.setSilent(false);
            event.setCancelled(true);
        }
    }

    @NotNull
    private String getMobName(@NotNull Mob entity) {
        return Arrays.stream(entity.getType().name().toLowerCase().split("_")).map(part -> Character.toUpperCase(part.charAt(0)) + part.substring(1)).collect(Collectors.joining(" "));
    }
}

