/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.dialog;

import com.uravgcode.survivalunlocked.SurvivalUnlocked;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SettingsDialog {
    private SettingsDialog() {
    }

    public static Dialog create() {
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)Component.text((String)"Survival Unlocked Settings")).inputs(SettingsDialog.generateDialogInputs()).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.builder((Component)Component.text((String)"Confirm", (TextColor)NamedTextColor.GREEN)).action((DialogAction)DialogAction.customClick(SettingsDialog::updateSettings, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().build()))).width(100).build(), (ActionButton)ActionButton.builder((Component)Component.text((String)"Discard", (TextColor)NamedTextColor.RED)).width(100).build())));
    }

    private static void updateSettings(DialogResponseView response, Audience audience) {
        SurvivalUnlocked plugin = SurvivalUnlocked.instance();
        FileConfiguration config = plugin.getConfig();
        for (String key : SettingsDialog.getConfigKeys()) {
            String sanitizedKey = key.replace("-", "");
            String responseText = response.getText(sanitizedKey);
            boolean enabled = "enabled".equals(responseText);
            config.set("modules." + key + ".enabled", (Object)enabled);
        }
        plugin.saveConfig();
        plugin.reload();
    }

    private static List<DialogInput> generateDialogInputs() {
        return SettingsDialog.getConfigKeys().stream().map(key -> {
            FileConfiguration config = SurvivalUnlocked.instance().getConfig();
            boolean enabled = config.getBoolean("modules." + key + ".enabled", false);
            SingleOptionDialogInput.OptionEntry enabledOption = SingleOptionDialogInput.OptionEntry.create((String)"enabled", (Component)Component.text((String)"enabled", (TextColor)NamedTextColor.GREEN), (boolean)enabled);
            SingleOptionDialogInput.OptionEntry disabledOption = SingleOptionDialogInput.OptionEntry.create((String)"disabled", (Component)Component.text((String)"disabled", (TextColor)NamedTextColor.RED), (!enabled ? 1 : 0) != 0);
            String label = Arrays.stream(key.split("-")).map(part -> Character.toUpperCase(part.charAt(0)) + part.substring(1)).collect(Collectors.joining(" "));
            return DialogInput.singleOption((String)key.replace("-", ""), (int)200, List.of(enabledOption, disabledOption), (Component)Component.text((String)label), (boolean)true);
        }).collect(Collectors.toList());
    }

    private static Set<String> getConfigKeys() {
        Configuration defaults = SurvivalUnlocked.instance().getConfig().getDefaults();
        if (defaults == null) {
            return Collections.emptySet();
        }
        ConfigurationSection modulesSection = defaults.getConfigurationSection("modules");
        if (modulesSection == null) {
            return Collections.emptySet();
        }
        return modulesSection.getKeys(false);
    }
}

